/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.org.apache.commons.configuration;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.flink.table.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.flink.table.shaded.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.flink.table.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.flink.table.shaded.org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPropertiesConfiguration
extends PropertiesConfiguration {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public XMLPropertiesConfiguration() {
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(URL url) throws ConfigurationException {
        super(url);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public void load(Reader in) throws ConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(true);
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(this.getClass().getClassLoader().getResourceAsStream("properties.dtd"));
                }
            });
            xmlReader.setContentHandler(new XMLPropertiesHandler());
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e2) {
            throw new ConfigurationException("Unable to parse the configuration file", e2);
        }
    }

    public void save(Writer out) throws ConfigurationException {
        PrintWriter writer = new PrintWriter(out);
        String encoding = this.getEncoding() != null ? this.getEncoding() : DEFAULT_ENCODING;
        writer.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        writer.println("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">");
        writer.println("<properties>");
        if (this.getHeader() != null) {
            writer.println("  <comment>" + StringEscapeUtils.escapeXml(this.getHeader()) + "</comment>");
        }
        Iterator keys = this.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.getProperty(key);
            if (value instanceof List) {
                this.writeProperty(writer, key, (List)value);
                continue;
            }
            this.writeProperty(writer, key, value);
        }
        writer.println("</properties>");
        writer.flush();
    }

    private void writeProperty(PrintWriter out, String key, Object value) {
        String k = StringEscapeUtils.escapeXml(key);
        if (value != null) {
            String v = StringEscapeUtils.escapeXml(String.valueOf(value));
            v = StringUtils.replace(v, String.valueOf(this.getListDelimiter()), "\\" + this.getListDelimiter());
            out.println("  <entry key=\"" + k + "\">" + v + "</entry>");
        } else {
            out.println("  <entry key=\"" + k + "\"/>");
        }
    }

    private void writeProperty(PrintWriter out, String key, List values) {
        for (int i = 0; i < values.size(); ++i) {
            this.writeProperty(out, key, values.get(i));
        }
    }

    private class XMLPropertiesHandler
    extends DefaultHandler {
        private String key;
        private StringBuffer value = new StringBuffer();
        private boolean inCommentElement;
        private boolean inEntryElement;

        private XMLPropertiesHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            if ("comment".equals(qName)) {
                this.inCommentElement = true;
            }
            if ("entry".equals(qName)) {
                this.key = attrs.getValue("key");
                this.inEntryElement = true;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.inCommentElement) {
                XMLPropertiesConfiguration.this.setHeader(this.value.toString());
                this.inCommentElement = false;
            }
            if (this.inEntryElement) {
                XMLPropertiesConfiguration.this.addProperty(this.key, this.value.toString());
                this.inEntryElement = false;
            }
            this.value = new StringBuffer();
        }

        public void characters(char[] chars, int start, int length) {
            this.value.append(chars, start, length);
        }
    }
}

