/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.org.apache.commons.configuration;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.shaded.org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.flink.table.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.flink.table.shaded.org.apache.commons.configuration.FileConfiguration;
import org.apache.flink.table.shaded.org.apache.commons.configuration.FileSystem;
import org.apache.flink.table.shaded.org.apache.commons.configuration.FileSystemBased;
import org.apache.flink.table.shaded.org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.flink.table.shaded.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.flink.table.shaded.org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.flink.table.shaded.org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.flink.table.shaded.org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.flink.table.shaded.org.apache.commons.configuration.reloading.Reloadable;
import org.apache.flink.table.shaded.org.apache.commons.configuration.reloading.ReloadingStrategy;

public abstract class AbstractHierarchicalFileConfiguration
extends HierarchicalConfiguration
implements FileConfiguration,
ConfigurationListener,
ConfigurationErrorListener,
FileSystemBased,
Reloadable {
    private FileConfigurationDelegate delegate;

    protected AbstractHierarchicalFileConfiguration() {
        this.initialize();
    }

    protected AbstractHierarchicalFileConfiguration(HierarchicalConfiguration c) {
        super(c);
        this.initialize();
    }

    public AbstractHierarchicalFileConfiguration(String fileName) throws ConfigurationException {
        this();
        this.delegate.setFileName(fileName);
        this.load();
    }

    public AbstractHierarchicalFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractHierarchicalFileConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    private void initialize() {
        this.delegate = this.createDelegate();
        this.initDelegate(this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPropertyDirect(String key, Object obj) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.addPropertyDirect(key, obj);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperty(String key) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.clearProperty(key);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTree(String key) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.clearTree(key);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.setProperty(key, value);
            this.delegate.possiblySave();
        }
    }

    public void load() throws ConfigurationException {
        this.delegate.load();
    }

    public void load(String fileName) throws ConfigurationException {
        this.delegate.load(fileName);
    }

    public void load(File file) throws ConfigurationException {
        this.delegate.load(file);
    }

    public void load(URL url) throws ConfigurationException {
        this.delegate.load(url);
    }

    public void load(InputStream in) throws ConfigurationException {
        this.delegate.load(in);
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        this.delegate.load(in, encoding);
    }

    public void save() throws ConfigurationException {
        this.delegate.save();
    }

    public void save(String fileName) throws ConfigurationException {
        this.delegate.save(fileName);
    }

    public void save(File file) throws ConfigurationException {
        this.delegate.save(file);
    }

    public void save(URL url) throws ConfigurationException {
        this.delegate.save(url);
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.delegate.save(out);
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        this.delegate.save(out, encoding);
    }

    public String getFileName() {
        return this.delegate.getFileName();
    }

    public void setFileName(String fileName) {
        this.delegate.setFileName(fileName);
    }

    public String getBasePath() {
        return this.delegate.getBasePath();
    }

    public void setBasePath(String basePath) {
        this.delegate.setBasePath(basePath);
    }

    public File getFile() {
        return this.delegate.getFile();
    }

    public void setFile(File file) {
        this.delegate.setFile(file);
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public void setURL(URL url) {
        this.delegate.setURL(url);
    }

    public void setAutoSave(boolean autoSave) {
        this.delegate.setAutoSave(autoSave);
    }

    public boolean isAutoSave() {
        return this.delegate.isAutoSave();
    }

    public ReloadingStrategy getReloadingStrategy() {
        return this.delegate.getReloadingStrategy();
    }

    public void setReloadingStrategy(ReloadingStrategy strategy) {
        this.delegate.setReloadingStrategy(strategy);
    }

    public void reload() {
        this.reload(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reload(boolean checkReload) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            boolean bl;
            this.setDetailEvents(false);
            try {
                bl = this.delegate.reload(checkReload);
            }
            catch (Throwable throwable) {
                this.setDetailEvents(true);
                throw throwable;
            }
            this.setDetailEvents(true);
            return bl;
        }
    }

    public void refresh() throws ConfigurationException {
        this.delegate.refresh();
    }

    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.delegate.setEncoding(encoding);
    }

    public Object getReloadLock() {
        return this.delegate.getReloadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKeys() {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.getKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKeys(String prefix) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.getKeys(prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        if (this.reload(true)) {
            Object object = this.delegate.getReloadLock();
            synchronized (object) {
                return super.getProperty(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(String key, Collection nodes) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.addNodes(key, nodes);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List fetchNodeList(String key) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.fetchNodeList(key);
        }
    }

    protected void subnodeConfigurationChanged(ConfigurationEvent event) {
        this.delegate.possiblySave();
        super.subnodeConfigurationChanged(event);
    }

    protected FileConfigurationDelegate createDelegate() {
        return new FileConfigurationDelegate();
    }

    private void initDelegate(FileConfigurationDelegate del) {
        del.addConfigurationListener(this);
        del.addErrorListener(this);
        del.setLogger(this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationChanged(ConfigurationEvent event) {
        this.setDetailEvents(true);
        try {
            this.fireEvent(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.isBeforeUpdate());
        }
        finally {
            this.setDetailEvents(false);
        }
    }

    public void configurationError(ConfigurationErrorEvent event) {
        this.fireError(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.getCause());
    }

    protected FileConfigurationDelegate getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(FileConfigurationDelegate delegate) {
        this.delegate = delegate;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.delegate.setFileSystem(fileSystem);
    }

    public void resetFileSystem() {
        this.delegate.resetFileSystem();
    }

    public FileSystem getFileSystem() {
        return this.delegate.getFileSystem();
    }

    protected class FileConfigurationDelegate
    extends AbstractFileConfiguration {
        protected FileConfigurationDelegate() {
        }

        public void load(Reader in) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.load(in);
        }

        public void save(Writer out) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.save(out);
        }

        public void clear() {
            AbstractHierarchicalFileConfiguration.this.clear();
        }
    }
}

