/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.triggers;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.runtime.triggers.StateCleaningCountTrigger$;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001=\u0011\u0011d\u0015;bi\u0016\u001cE.Z1oS:<7i\\;oiR\u0013\u0018nZ4fe*\u00111\u0001B\u0001\tiJLwmZ3sg*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\tEI2$I\u0007\u0002%)\u00111a\u0005\u0006\u0003)U\t\u0011b^5oI><\u0018N\\4\u000b\u0005Y9\u0012aA1qS*\u0011\u0001\u0004C\u0001\ngR\u0014X-Y7j]\u001eL!A\u0007\n\u0003\u000fQ\u0013\u0018nZ4feB\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t\u0019\u0011I\\=\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\u001a\u0012aB<j]\u0012|wo]\u0005\u0003M\r\u0012Ab\u00127pE\u0006dw+\u001b8e_^D\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\fcV,'/_\"p]\u001aLw\r\u0005\u0002+Y5\t1F\u0003\u0002\u0017\r%\u0011Qf\u000b\u0002\u0012'R\u0014X-Y7Rk\u0016\u0014\u0018pQ8oM&<\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u00115\f\u0007pQ8v]R\u0004\"\u0001H\u0019\n\u0005Ij\"\u0001\u0002'p]\u001eDQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtDc\u0001\u001c9sA\u0011q\u0007A\u0007\u0002\u0005!)\u0001f\ra\u0001S!)qf\ra\u0001a!91\b\u0001b\u0001\n#a\u0014\u0001E7j]J+G/\u001a8uS>tG+[7f+\u0005\u0001\u0004B\u0002 \u0001A\u0003%\u0001'A\tnS:\u0014V\r^3oi&|g\u000eV5nK\u0002Bq\u0001\u0011\u0001C\u0002\u0013EA(\u0001\tnCb\u0014V\r^3oi&|g\u000eV5nK\"1!\t\u0001Q\u0001\nA\n\u0011#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3!\u0011\u001d!\u0005A1A\u0005\u0012\u0015\u000bAc\u001d;bi\u0016\u001cE.Z1oS:<WI\\1cY\u0016$W#\u0001$\u0011\u0005q9\u0015B\u0001%\u001e\u0005\u001d\u0011un\u001c7fC:DaA\u0013\u0001!\u0002\u00131\u0015!F:uCR,7\t\\3b]&tw-\u00128bE2,G\r\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0003%\u0019H/\u0019;f\t\u0016\u001c8-F\u0001O!\ryUkV\u0007\u0002!*\u0011\u0011KU\u0001\u0006gR\fG/\u001a\u0006\u0003'R\u000baaY8n[>t'B\u0001\f\t\u0013\t1\u0006KA\fSK\u0012,8-\u001b8h'R\fG/\u001a#fg\u000e\u0014\u0018\u000e\u001d;peB\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\u0005Y\u0006twMC\u0001]\u0003\u0011Q\u0017M^1\n\u0005IJ\u0006BB0\u0001A\u0003%a*\u0001\u0006ti\u0006$X\rR3tG\u0002Bq!\u0019\u0001C\u0002\u0013%!-\u0001\tdY\u0016\fg.\u001e9Ti\u0006$X\rR3tGV\t1\rE\u0002PI^K!!\u001a)\u0003)Y\u000bG.^3Ti\u0006$X\rR3tGJL\u0007\u000f^8s\u0011\u00199\u0007\u0001)A\u0005G\u0006\t2\r\\3b]V\u00048\u000b^1uK\u0012+7o\u0019\u0011\t\u000b%\u0004A\u0011\t6\u0002\u0011\r\fg.T3sO\u0016$\u0012A\u0012\u0005\u0006Y\u0002!\t%\\\u0001\ti>\u001cFO]5oOR\ta\u000e\u0005\u0002pe:\u0011A\u0004]\u0005\u0003cv\ta\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011/\b\u0005\u0006m\u0002!\te^\u0001\n_:,E.Z7f]R$b\u0001_>~\u007f\u0006\r\u0001CA\tz\u0013\tQ(CA\u0007Ue&<w-\u001a:SKN,H\u000e\u001e\u0005\u0006yV\u0004\raG\u0001\bK2,W.\u001a8u\u0011\u0015qX\u000f1\u00011\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0004\u0002\u0002U\u0004\r!I\u0001\u0007o&tGm\\<\t\u000f\u0005\u0015Q\u000f1\u0001\u0002\b\u0005\u00191\r\u001e=\u0011\t\u0005%\u0011\u0011\u0007\b\u0005\u0003\u0017\tiC\u0004\u0003\u0002\u000e\u0005-b\u0002BA\b\u0003SqA!!\u0005\u0002(9!\u00111CA\u0013\u001d\u0011\t)\"a\t\u000f\t\u0005]\u0011\u0011\u0005\b\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\u0019\u0011%\u0011acF\u0005\u0003)UI!aA\n\n\u0007\u0005=\"#A\u0004Ue&<w-\u001a:\n\t\u0005M\u0012Q\u0007\u0002\u000f)JLwmZ3s\u0007>tG/\u001a=u\u0015\r\tyC\u0005\u0005\b\u0003s\u0001A\u0011IA\u001e\u0003Ayg\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\rF\u0004y\u0003{\t\t%a\u0011\t\u000f\u0005}\u0012q\u0007a\u0001a\u0005!A/[7f\u0011\u001d\t\t!a\u000eA\u0002\u0005B\u0001\"!\u0002\u00028\u0001\u0007\u0011q\u0001\u0005\b\u0003\u000f\u0002A\u0011IA%\u0003-yg.\u0012<f]R$\u0016.\\3\u0015\u000fa\fY%!\u0014\u0002P!9\u0011qHA#\u0001\u0004\u0001\u0004bBA\u0001\u0003\u000b\u0002\r!\t\u0005\t\u0003\u000b\t)\u00051\u0001\u0002\b!9\u00111\u000b\u0001\u0005B\u0005U\u0013!B2mK\u0006\u0014HCBA,\u0003;\ny\u0006E\u0002\u001d\u00033J1!a\u0017\u001e\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005\u0011\u0011\u000ba\u0001C!A\u0011QAA)\u0001\u0004\t9aB\u0004\u0002d\tA\t!!\u001a\u00023M#\u0018\r^3DY\u0016\fg.\u001b8h\u0007>,h\u000e\u001e+sS\u001e<WM\u001d\t\u0004o\u0005\u001ddAB\u0001\u0003\u0011\u0003\tIg\u0005\u0004\u0002h\u0005-\u0014\u0011\u000f\t\u00049\u00055\u0014bAA8;\t1\u0011I\\=SK\u001a\u00042\u0001HA:\u0013\r\t)(\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bi\u0005\u001dD\u0011AA=)\t\t)\u0007\u0003\u0005\u0002~\u0005\u001dD\u0011AA@\u0003\tyg\rF\u00037\u0003\u0003\u000b\u0019\t\u0003\u0004)\u0003w\u0002\r!\u000b\u0005\u0007_\u0005m\u0004\u0019\u0001\u0019\u0007\u000f\u0005\u001d\u0015q\r\u0001\u0002\n\n\u00191+^7\u0014\r\u0005\u0015\u00151RAI!\rA\u0016QR\u0005\u0004\u0003\u001fK&AB(cU\u0016\u001cG\u000fE\u0003\u0002\u0014\u0006eu+\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013*\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018\u0002BAN\u0003+\u0013aBU3ek\u000e,g)\u001e8di&|g\u000eC\u00045\u0003\u000b#\t!a(\u0015\u0005\u0005\u0005\u0006\u0003BAR\u0003\u000bk!!a\u001a\t\u0011\u0005\u001d\u0016Q\u0011C!\u0003S\u000baA]3ek\u000e,G#B,\u0002,\u0006=\u0006bBAW\u0003K\u0003\raV\u0001\u0007m\u0006dW/Z\u0019\t\u000f\u0005E\u0016Q\u0015a\u0001/\u00061a/\u00197vKJB!\"!.\u0002h\u0005\u0005I\u0011BA\\\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005-\u0005")
public class StateCleaningCountTrigger
extends Trigger<Object, GlobalWindow> {
    private final StreamQueryConfig queryConfig;
    private final long maxCount;
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final boolean stateCleaningEnabled;
    private final ReducingStateDescriptor<Long> stateDesc;
    private final ValueStateDescriptor<Long> cleanupStateDesc;

    public static StateCleaningCountTrigger of(StreamQueryConfig streamQueryConfig, long l) {
        return StateCleaningCountTrigger$.MODULE$.of(streamQueryConfig, l);
    }

    public long minRetentionTime() {
        return this.minRetentionTime;
    }

    public long maxRetentionTime() {
        return this.maxRetentionTime;
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    private ReducingStateDescriptor<Long> stateDesc() {
        return this.stateDesc;
    }

    private ValueStateDescriptor<Long> cleanupStateDesc() {
        return this.cleanupStateDesc;
    }

    public boolean canMerge() {
        return false;
    }

    public String toString() {
        return new StringBuilder().append((Object)"CountTriggerGlobalWindowithCleanupState(minIdleStateRetentionTime=").append((Object)BoxesRunTime.boxToLong((long)this.queryConfig.getMinIdleStateRetentionTime())).append((Object)", ").append((Object)"maxIdleStateRetentionTime=").append((Object)BoxesRunTime.boxToLong((long)this.queryConfig.getMaxIdleStateRetentionTime())).append((Object)", ").append((Object)"maxCount=").append((Object)BoxesRunTime.boxToLong((long)this.maxCount)).append((Object)")").toString();
    }

    public TriggerResult onElement(Object element, long timestamp, GlobalWindow window, Trigger.TriggerContext ctx) {
        TriggerResult triggerResult;
        Long curCleanupTime;
        long currentTime2 = ctx.getCurrentProcessingTime();
        if (this.stateCleaningEnabled() && ((curCleanupTime = (Long)((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).value()) == null || currentTime2 + this.minRetentionTime() > Predef$.MODULE$.Long2long(curCleanupTime))) {
            long cleanupTime = currentTime2 + this.maxRetentionTime();
            ctx.registerProcessingTimeTimer(cleanupTime);
            ((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).update((Object)Predef$.MODULE$.long2Long(cleanupTime));
        }
        ReducingState count = (ReducingState)ctx.getPartitionedState(this.stateDesc());
        count.add((Object)Predef$.MODULE$.long2Long(1L));
        if (Predef$.MODULE$.Long2long((Long)count.get()) >= this.maxCount) {
            count.clear();
            triggerResult = TriggerResult.FIRE;
        } else {
            triggerResult = TriggerResult.CONTINUE;
        }
        return triggerResult;
    }

    public TriggerResult onProcessingTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        Long cleanupTime;
        if (this.stateCleaningEnabled() && (cleanupTime = (Long)((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).value()) != null && BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)time), (Object)cleanupTime)) {
            this.clear(window, ctx);
            return TriggerResult.FIRE_AND_PURGE;
        }
        return TriggerResult.CONTINUE;
    }

    public TriggerResult onEventTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        return TriggerResult.CONTINUE;
    }

    public void clear(GlobalWindow window, Trigger.TriggerContext ctx) {
        ctx.getPartitionedState(this.stateDesc()).clear();
        ctx.getPartitionedState(this.cleanupStateDesc()).clear();
    }

    public StateCleaningCountTrigger(StreamQueryConfig queryConfig, long maxCount) {
        this.queryConfig = queryConfig;
        this.maxCount = maxCount;
        this.minRetentionTime = queryConfig.getMinIdleStateRetentionTime();
        this.maxRetentionTime = queryConfig.getMaxIdleStateRetentionTime();
        this.stateCleaningEnabled = this.minRetentionTime() > 1L;
        this.stateDesc = new ReducingStateDescriptor("count", (ReduceFunction)new Sum(), Types$.MODULE$.LONG());
        this.cleanupStateDesc = new ValueStateDescriptor("countCleanup", Types$.MODULE$.LONG());
    }

    public static class Sum
    implements ReduceFunction<Long> {
        public Long reduce(Long value1, Long value2) {
            return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(value1) + Predef$.MODULE$.Long2long(value2));
        }
    }
}

