/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001=\u00111\u0004\u0015:pGRKW.Z*peR\u0004&o\\2fgN4UO\\2uS>t'BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001B!\u0005\r\u001b55\t!C\u0003\u0002\u0014)\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003+Y\t1!\u00199j\u0015\t9\u0002\"A\u0005tiJ,\u0017-\\5oO&\u0011\u0011D\u0005\u0002\u0010!J|7-Z:t\rVt7\r^5p]B\u00111DH\u0007\u00029)\u0011Q\u0004B\u0001\u0006if\u0004Xm]\u0005\u0003?q\u0011Aa\u0011*po\"A\u0011\u0005\u0001BC\u0002\u0013%!%\u0001\u0007j]B,HOU8x)f\u0004X-F\u0001$!\tYB%\u0003\u0002&9\ta1IU8x)f\u0004X-\u00138g_\"Aq\u0005\u0001B\u0001B\u0003%1%A\u0007j]B,HOU8x)f\u0004X\r\t\u0005\tS\u0001\u0011)\u0019!C\u0005U\u0005i!o\\<D_6\u0004\u0018M]1u_J,\u0012a\u000b\t\u0003Y5j\u0011AA\u0005\u0003]\t\u0011qcQ8mY\u0016\u001cG/[8o%><8i\\7qCJ\fGo\u001c:\t\u0011A\u0002!\u0011!Q\u0001\n-\naB]8x\u0007>l\u0007/\u0019:bi>\u0014\b\u0005C\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0004iU2\u0004C\u0001\u0017\u0001\u0011\u0015\t\u0013\u00071\u0001$\u0011\u0015I\u0013\u00071\u0001,\u0011%A\u0004\u00011AA\u0002\u0013%\u0011(\u0001\bck\u001a4WM]3e\u000bZ,g\u000e^:\u0016\u0003i\u00022aO!D\u001b\u0005a$BA\u001f?\u0003\u0015\u0019H/\u0019;f\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003+!I!A\u0011\u001f\u0003\u00131K7\u000f^*uCR,\u0007C\u0001#G\u001b\u0005)%BA\u000f\t\u0013\t9UIA\u0002S_^D\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0002&\u0002%\t,hMZ3sK\u0012,e/\u001a8ug~#S-\u001d\u000b\u0003\u0017F\u0003\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013A!\u00168ji\"9!\u000bSA\u0001\u0002\u0004Q\u0014a\u0001=%c!1A\u000b\u0001Q!\ni\nqBY;gM\u0016\u0014X\rZ#wK:$8\u000f\t\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0003)\u0019xN\u001d;Ck\u001a4WM]\u000b\u00021B\u0019\u0011LX\"\u000e\u0003iS!a\u0017/\u0002\tU$\u0018\u000e\u001c\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&LA\u0005BeJ\f\u0017\u0010T5ti\"1\u0011\r\u0001Q\u0001\na\u000b1b]8si\n+hMZ3sA!I1\r\u0001a\u0001\u0002\u0004%I\u0001Z\u0001\b_V$\b/\u001e;D+\u0005Q\u0002\"\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0003h\u0003-yW\u000f\u001e9vi\u000e{F%Z9\u0015\u0005-C\u0007b\u0002*f\u0003\u0003\u0005\rA\u0007\u0005\u0007U\u0002\u0001\u000b\u0015\u0002\u000e\u0002\u0011=,H\u000f];u\u0007\u0002BQ\u0001\u001c\u0001\u0005B5\fAa\u001c9f]R\u00111J\u001c\u0005\u0006_.\u0004\r\u0001]\u0001\u0007G>tg-[4\u0011\u0005E$X\"\u0001:\u000b\u0005MD\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002ve\ni1i\u001c8gS\u001e,(/\u0019;j_:DQa\u001e\u0001\u0005Ba\fa\u0002\u001d:pG\u0016\u001c8/\u00127f[\u0016tG\u000fF\u0003Lsn\f\t\u0001C\u0003{m\u0002\u0007!$\u0001\u0004j]B,Ho\u0011\u0005\u0006yZ\u0004\r!`\u0001\u0004GRD\bC\u0001\t\u007f\u0013\ty\bDA\u0004D_:$X\r\u001f;\t\u000f\u0005\ra\u000f1\u0001\u0002\u0006\u0005\u0019q.\u001e;\u0011\u000b\u0005\u001d\u00111\u0002\u000e\u000e\u0005\u0005%!BA.\t\u0013\u0011\ti!!\u0003\u0003\u0013\r{G\u000e\\3di>\u0014\bbBA\t\u0001\u0011\u0005\u00131C\u0001\b_:$\u0016.\\3s)\u001dY\u0015QCA\u0010\u0003OA\u0001\"a\u0006\u0002\u0010\u0001\u0007\u0011\u0011D\u0001\ni&lWm\u001d;b[B\u00042\u0001TA\u000e\u0013\r\ti\"\u0014\u0002\u0005\u0019>tw\rC\u0004}\u0003\u001f\u0001\r!!\t\u0011\u0007A\t\u0019#C\u0002\u0002&a\u0011ab\u00148US6,'oQ8oi\u0016DH\u000f\u0003\u0005\u0002\u0004\u0005=\u0001\u0019AA\u0003\u0001")
public class ProcTimeSortProcessFunction
extends ProcessFunction<CRow, CRow> {
    private final CRowTypeInfo inputRowType;
    private final CollectionRowComparator rowComparator;
    private ListState<Row> bufferedEvents;
    private final ArrayList<Row> sortBuffer;
    private CRow outputC;

    private CRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private CollectionRowComparator rowComparator() {
        return this.rowComparator;
    }

    private ListState<Row> bufferedEvents() {
        return this.bufferedEvents;
    }

    private void bufferedEvents_$eq(ListState<Row> x$1) {
        this.bufferedEvents = x$1;
    }

    private ArrayList<Row> sortBuffer() {
        return this.sortBuffer;
    }

    private CRow outputC() {
        return this.outputC;
    }

    private void outputC_$eq(CRow x$1) {
        this.outputC = x$1;
    }

    public void open(Configuration config) {
        ListStateDescriptor sortDescriptor = new ListStateDescriptor("sortState", (TypeInformation)this.inputRowType().rowType());
        this.bufferedEvents_$eq((ListState<Row>)this.getRuntimeContext().getListState(sortDescriptor));
        this.outputC_$eq(new CRow());
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        long currentTime2 = ctx.timerService().currentProcessingTime();
        this.bufferedEvents().add((Object)input);
        ctx.timerService().registerProcessingTimeTimer(currentTime2 + 1L);
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator iter = ((Iterable)this.bufferedEvents().get()).iterator();
        this.sortBuffer().clear();
        while (iter.hasNext()) {
            this.sortBuffer().add((Row)iter.next());
        }
        Collections.sort(this.sortBuffer(), this.rowComparator());
        for (int i = 0; i < this.sortBuffer().size(); ++i) {
            this.outputC().row_$eq(this.sortBuffer().get(i));
            out.collect((Object)this.outputC());
        }
        this.bufferedEvents().clear();
    }

    public ProcTimeSortProcessFunction(CRowTypeInfo inputRowType, CollectionRowComparator rowComparator) {
        this.inputRowType = inputRowType;
        this.rowComparator = rowComparator;
        Preconditions.checkNotNull((Object)rowComparator);
        this.sortBuffer = new ArrayList();
    }
}

