/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.util.InputRefVisitor;
import org.apache.flink.table.plan.util.RefFieldAccessorVisitor;
import org.apache.flink.table.plan.util.RexNodeToExpressionConverter;
import org.apache.flink.table.validate.FunctionCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RexProgramExtractor$ {
    public static final RexProgramExtractor$ MODULE$;
    private Logger LOG;
    private volatile boolean bitmap$0;

    static {
        new RexProgramExtractor$();
    }

    private Logger LOG$lzycompute() {
        RexProgramExtractor$ rexProgramExtractor$ = this;
        synchronized (rexProgramExtractor$) {
            if (!this.bitmap$0) {
                this.LOG = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
            return this.LOG;
        }
    }

    public Logger LOG() {
        return this.bitmap$0 ? this.LOG : this.LOG$lzycompute();
    }

    public int[] extractRefInputFields(RexProgram rexProgram) {
        InputRefVisitor visitor = new InputRefVisitor();
        JavaConversions$.MODULE$.asScalaBuffer(rexProgram.getProjectList()).foreach((Function1)new Serializable(rexProgram, visitor){
            public static final long serialVersionUID = 0L;
            private final RexProgram rexProgram$1;
            private final InputRefVisitor visitor$1;

            public final void apply(RexLocalRef exp) {
                this.rexProgram$1.expandLocalRef(exp).accept(this.visitor$1);
            }
            {
                this.rexProgram$1 = rexProgram$1;
                this.visitor$1 = visitor$1;
            }
        });
        RexLocalRef condition = rexProgram.getCondition();
        BoxedUnit boxedUnit = condition == null ? BoxedUnit.UNIT : rexProgram.expandLocalRef(condition).accept(visitor);
        return visitor.getFields();
    }

    public Tuple2<Expression[], RexNode[]> extractConjunctiveConditions(RexProgram rexProgram, RexBuilder rexBuilder, FunctionCatalog catalog) {
        Tuple2 tuple2;
        RexLocalRef rexLocalRef = rexProgram.getCondition();
        if (rexLocalRef != null) {
            RexLocalRef rexLocalRef2 = rexLocalRef;
            RexNode expanded = rexProgram.expandLocalRef(rexLocalRef2);
            RexNode cnf = RexUtil.toCnf(rexBuilder, expanded);
            List<RexNode> conjunctions = RelOptUtil.conjunctions(cnf);
            ArrayBuffer convertedExpressions = new ArrayBuffer();
            ArrayBuffer unconvertedRexNodes = new ArrayBuffer();
            String[] inputNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rexProgram.getInputRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
            RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(inputNames, catalog);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(conjunctions).asScala()).foreach((Function1)new Serializable(convertedExpressions, unconvertedRexNodes, converter){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer convertedExpressions$1;
                private final ArrayBuffer unconvertedRexNodes$1;
                private final RexNodeToExpressionConverter converter$1;

                public final ArrayBuffer<? super Expression> apply(RexNode rex) {
                    Option<Expression> option;
                    block4: {
                        ArrayBuffer arrayBuffer;
                        block3: {
                            block2: {
                                option = rex.accept(this.converter$1);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Expression expression2 = (Expression)some.x();
                                arrayBuffer = this.convertedExpressions$1.$plus$eq((Object)expression2);
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            arrayBuffer = this.unconvertedRexNodes$1.$plus$eq((Object)rex);
                        }
                        return arrayBuffer;
                    }
                    throw new MatchError(option);
                }
                {
                    this.convertedExpressions$1 = convertedExpressions$1;
                    this.unconvertedRexNodes$1 = unconvertedRexNodes$1;
                    this.converter$1 = converter$1;
                }
            });
            tuple2 = new Tuple2(convertedExpressions.toArray(ClassTag$.MODULE$.apply(Expression.class)), unconvertedRexNodes.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
        } else {
            tuple2 = new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Expression.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RexNode.class)));
        }
        return tuple2;
    }

    public String[][] extractRefNestedInputFields(RexProgram rexProgram, int[] usedFields) {
        RefFieldAccessorVisitor visitor = new RefFieldAccessorVisitor(usedFields);
        JavaConversions$.MODULE$.asScalaBuffer(rexProgram.getProjectList()).foreach((Function1)new Serializable(rexProgram, visitor){
            public static final long serialVersionUID = 0L;
            private final RexProgram rexProgram$2;
            private final RefFieldAccessorVisitor visitor$2;

            public final void apply(RexLocalRef exp) {
                this.rexProgram$2.expandLocalRef(exp).accept(this.visitor$2);
            }
            {
                this.rexProgram$2 = rexProgram$2;
                this.visitor$2 = visitor$2;
            }
        });
        RexLocalRef condition = rexProgram.getCondition();
        BoxedUnit boxedUnit = condition == null ? BoxedUnit.UNIT : rexProgram.expandLocalRef(condition).accept(visitor);
        return visitor.getProjectedFields();
    }

    private RexProgramExtractor$() {
        MODULE$ = this;
    }
}

