/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.explain;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.flink.table.explain.CompilerHints;
import org.apache.flink.table.explain.Costs;
import org.apache.flink.table.explain.Estimates;
import org.apache.flink.table.explain.GlobalProperties;
import org.apache.flink.table.explain.LocalProperty;
import org.apache.flink.table.explain.Node;
import org.apache.flink.table.explain.PlanTree;
import org.apache.flink.table.explain.Predecessors;

public class PlanJsonParser {
    public static String getSqlExecutionPlan(String t, Boolean extended) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        PlanTree tree = (PlanTree)objectMapper.readValue(t, PlanTree.class);
        LinkedHashMap<String, Integer> map2 = new LinkedHashMap<String, Integer>();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int tabCount = 0;
        for (int index = 0; index < tree.getNodes().size(); ++index) {
            Node tempNode = tree.getNodes().get(index);
            if (tempNode.getPact().equals("Data Source") && map2.containsKey(tempNode.getPact())) {
                tabCount = (Integer)map2.get(tempNode.getPact());
            } else {
                map2.put(tempNode.getPact(), tabCount);
            }
            PlanJsonParser.printTab(tabCount, pw);
            pw.print("Stage " + tempNode.getId() + " : " + tempNode.getPact() + "\n");
            PlanJsonParser.printTab(tabCount + 1, pw);
            String content = tempNode.getContents();
            int dele = tempNode.getContents().indexOf("@");
            if (dele > -1) {
                content = tempNode.getContents().substring(0, dele);
            }
            if (tempNode.getPact().equals("Data Source")) {
                content = "collect elements with CollectionInputFormat";
            }
            pw.print("content : " + content + "\n");
            List<Predecessors> predecessors = tempNode.getPredecessors();
            if (predecessors != null) {
                PlanJsonParser.printTab(tabCount + 1, pw);
                pw.print("ship_strategy : " + predecessors.get(0).getShipStrategy() + "\n");
                String mode = predecessors.get(0).getExchangeMode();
                if (mode != null) {
                    PlanJsonParser.printTab(tabCount + 1, pw);
                    pw.print("exchange_mode : " + mode + "\n");
                }
            }
            if (tempNode.getDriverStrategy() != null) {
                PlanJsonParser.printTab(tabCount + 1, pw);
                pw.print("driver_strategy : " + tempNode.getDriverStrategy() + "\n");
            }
            if (tempNode.getGlobalProperties() != null) {
                PlanJsonParser.printTab(tabCount + 1, pw);
                pw.print(tempNode.getGlobalProperties().get(0).getName() + " : " + tempNode.getGlobalProperties().get(0).getValue() + "\n");
            }
            if (extended.booleanValue()) {
                List<GlobalProperties> globalProperties = tempNode.getGlobalProperties();
                for (int i = 1; i < globalProperties.size(); ++i) {
                    PlanJsonParser.printTab(tabCount + 1, pw);
                    pw.print(globalProperties.get(i).getName() + " : " + globalProperties.get(i).getValue() + "\n");
                }
                List<LocalProperty> localProperties = tempNode.getLocalProperties();
                for (int i = 0; i < localProperties.size(); ++i) {
                    PlanJsonParser.printTab(tabCount + 1, pw);
                    pw.print(localProperties.get(i).getName() + " : " + localProperties.get(i).getValue() + "\n");
                }
                List<Estimates> estimates = tempNode.getEstimates();
                for (int i = 0; i < estimates.size(); ++i) {
                    PlanJsonParser.printTab(tabCount + 1, pw);
                    pw.print(estimates.get(i).getName() + " : " + estimates.get(i).getValue() + "\n");
                }
                List<Costs> costs = tempNode.getCosts();
                for (int i = 0; i < costs.size(); ++i) {
                    PlanJsonParser.printTab(tabCount + 1, pw);
                    pw.print(costs.get(i).getName() + " : " + costs.get(i).getValue() + "\n");
                }
                List<CompilerHints> compilerHints = tempNode.getCompilerHints();
                for (int i = 0; i < compilerHints.size(); ++i) {
                    PlanJsonParser.printTab(tabCount + 1, pw);
                    pw.print(compilerHints.get(i).getName() + " : " + compilerHints.get(i).getValue() + "\n");
                }
            }
            ++tabCount;
            pw.print("\n");
        }
        pw.close();
        return sw.toString();
    }

    private static void printTab(int tabCount, PrintWriter pw) {
        for (int i = 0; i < tabCount; ++i) {
            pw.print("\t");
        }
    }
}

