/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.CollectStreamResult;
import org.apache.flink.table.client.gateway.local.MaterializedResult;
import org.apache.flink.types.Row;

public class MaterializedCollectStreamResult<C>
extends CollectStreamResult<C>
implements MaterializedResult<C> {
    private final List<Row> materializedTable = new ArrayList<Row>();
    private final Map<Row, List<Integer>> rowPositions = new HashMap<Row, List<Integer>>();
    private final List<Row> snapshot = new ArrayList<Row>();
    private int pageCount = 0;
    private int pageSize;
    private boolean isLastSnapshot = false;

    public MaterializedCollectStreamResult(TypeInformation<Row> outputType, ExecutionConfig config, InetAddress gatewayAddress, int gatewayPort) {
        super(outputType, config, gatewayAddress, gatewayPort);
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedResult<Integer> snapshot(int pageSize) {
        Object object = this.resultLock;
        synchronized (object) {
            if (!this.isRetrieving() && this.isLastSnapshot || this.executionException != null) {
                return this.handleMissingResult();
            }
            if (!this.isRetrieving()) {
                this.isLastSnapshot = true;
            }
            this.pageSize = pageSize;
            this.snapshot.clear();
            this.snapshot.addAll(this.materializedTable);
            this.pageCount = Math.max(1, (int)Math.ceil((double)this.snapshot.size() / (double)pageSize));
            return TypedResult.payload(this.pageCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row> retrievePage(int page) {
        Object object = this.resultLock;
        synchronized (object) {
            if (page <= 0 || page > this.pageCount) {
                throw new SqlExecutionException("Invalid page '" + page + "'.");
            }
            return this.snapshot.subList(this.pageSize * (page - 1), Math.min(this.snapshot.size(), this.pageSize * page));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRecord(Tuple2<Boolean, Row> change) {
        Object object = this.resultLock;
        synchronized (object) {
            List<Integer> positions = this.rowPositions.get(change.f1);
            if (((Boolean)change.f0).booleanValue()) {
                this.materializedTable.add((Row)change.f1);
                if (positions == null) {
                    ArrayList<Integer> pos = new ArrayList<Integer>(1);
                    pos.add(this.materializedTable.size() - 1);
                    this.rowPositions.put((Row)change.f1, pos);
                } else {
                    positions.add(this.materializedTable.size() - 1);
                }
            } else if (positions != null) {
                int pos = positions.remove(positions.size() - 1);
                this.materializedTable.remove(pos);
                if (positions.isEmpty()) {
                    this.rowPositions.remove(change.f1);
                }
            }
        }
    }
}

