/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.cli.RunOptions;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.BatchQueryConfig;
import org.apache.flink.table.api.QueryConfig;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.client.config.Deployment;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.gateway.SessionContext;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.descriptors.TableSourceDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceFactoryService;
import org.apache.flink.util.FlinkException;

public class ExecutionContext<T> {
    private final SessionContext sessionContext;
    private final Environment mergedEnv;
    private final List<URL> dependencies;
    private final ClassLoader classLoader;
    private final Map<String, TableSource<?>> tableSources;
    private final Configuration flinkConfig;
    private final CommandLine commandLine;
    private final CustomCommandLine<T> activeCommandLine;
    private final RunOptions runOptions;
    private final T clusterId;
    private final ClusterSpecification clusterSpec;

    public ExecutionContext(Environment defaultEnvironment, SessionContext sessionContext, List<URL> dependencies, Configuration flinkConfig, Options commandLineOptions, List<CustomCommandLine<?>> availableCommandLines) {
        this.sessionContext = sessionContext.copy();
        this.mergedEnv = Environment.merge(defaultEnvironment, sessionContext.getEnvironment());
        this.dependencies = dependencies;
        this.flinkConfig = flinkConfig;
        this.classLoader = FlinkUserCodeClassLoaders.parentFirst((URL[])dependencies.toArray(new URL[dependencies.size()]), (ClassLoader)this.getClass().getClassLoader());
        this.tableSources = new HashMap();
        this.mergedEnv.getTables().forEach((name, descriptor) -> {
            if (descriptor instanceof TableSourceDescriptor) {
                TableSource<?> tableSource = TableSourceFactoryService.findAndCreateTableSource((TableSourceDescriptor)descriptor, this.classLoader);
                this.tableSources.put((String)name, tableSource);
            }
        });
        this.commandLine = ExecutionContext.createCommandLine(this.mergedEnv.getDeployment(), commandLineOptions);
        this.activeCommandLine = ExecutionContext.findActiveCommandLine(availableCommandLines, this.commandLine);
        this.runOptions = ExecutionContext.createRunOptions(this.commandLine);
        this.clusterId = this.activeCommandLine.getClusterId(this.commandLine);
        this.clusterSpec = ExecutionContext.createClusterSpecification(this.activeCommandLine, this.commandLine);
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Environment getMergedEnvironment() {
        return this.mergedEnv;
    }

    public ClusterSpecification getClusterSpec() {
        return this.clusterSpec;
    }

    public T getClusterId() {
        return this.clusterId;
    }

    public ClusterDescriptor<T> createClusterDescriptor() throws Exception {
        return this.activeCommandLine.createClusterDescriptor(this.commandLine);
    }

    public EnvironmentInstance createEnvironmentInstance() {
        return new EnvironmentInstance();
    }

    private static CommandLine createCommandLine(Deployment deployment, Options commandLineOptions) {
        try {
            return deployment.getCommandLine(commandLineOptions);
        }
        catch (Exception e2) {
            throw new SqlExecutionException("Invalid deployment options.", e2);
        }
    }

    private static <T> CustomCommandLine<T> findActiveCommandLine(List<CustomCommandLine<?>> availableCommandLines, CommandLine commandLine) {
        for (CustomCommandLine<?> cli : availableCommandLines) {
            if (!cli.isActive(commandLine)) continue;
            return cli;
        }
        throw new SqlExecutionException("Could not find a matching deployment.");
    }

    private static RunOptions createRunOptions(CommandLine commandLine) {
        try {
            return new RunOptions(commandLine);
        }
        catch (CliArgsException e2) {
            throw new SqlExecutionException("Invalid deployment run options.", e2);
        }
    }

    private static ClusterSpecification createClusterSpecification(CustomCommandLine<?> activeCommandLine, CommandLine commandLine) {
        try {
            return activeCommandLine.getClusterSpecification(commandLine);
        }
        catch (FlinkException e2) {
            throw new SqlExecutionException("Could not create cluster specification for the given deployment.", e2);
        }
    }

    public class EnvironmentInstance {
        private final QueryConfig queryConfig;
        private final ExecutionEnvironment execEnv;
        private final StreamExecutionEnvironment streamExecEnv;
        private final TableEnvironment tableEnv;

        private EnvironmentInstance() {
            if (ExecutionContext.this.mergedEnv.getExecution().isStreamingExecution()) {
                this.streamExecEnv = this.createStreamExecutionEnvironment();
                this.execEnv = null;
                this.tableEnv = TableEnvironment.getTableEnvironment(this.streamExecEnv);
            } else {
                this.streamExecEnv = null;
                this.execEnv = this.createExecutionEnvironment();
                this.tableEnv = TableEnvironment.getTableEnvironment(this.execEnv);
            }
            this.queryConfig = this.createQueryConfig();
            ExecutionContext.this.tableSources.forEach(this.tableEnv::registerTableSource);
        }

        public QueryConfig getQueryConfig() {
            return this.queryConfig;
        }

        public ExecutionEnvironment getExecutionEnvironment() {
            return this.execEnv;
        }

        public StreamExecutionEnvironment getStreamExecutionEnvironment() {
            return this.streamExecEnv;
        }

        public TableEnvironment getTableEnvironment() {
            return this.tableEnv;
        }

        public ExecutionConfig getExecutionConfig() {
            if (this.streamExecEnv != null) {
                return this.streamExecEnv.getConfig();
            }
            return this.execEnv.getConfig();
        }

        public JobGraph createJobGraph(String name) {
            FlinkPlan plan = this.createPlan(name, ExecutionContext.this.flinkConfig);
            return ClusterClient.getJobGraph((Configuration)ExecutionContext.this.flinkConfig, (FlinkPlan)plan, (List)ExecutionContext.this.dependencies, (List)ExecutionContext.this.runOptions.getClasspaths(), (SavepointRestoreSettings)ExecutionContext.this.runOptions.getSavepointRestoreSettings());
        }

        private FlinkPlan createPlan(String name, Configuration flinkConfig) {
            if (this.streamExecEnv != null) {
                StreamGraph graph = this.streamExecEnv.getStreamGraph();
                graph.setJobName(name);
                return graph;
            }
            int parallelism = this.execEnv.getParallelism();
            Plan unoptimizedPlan = this.execEnv.createProgramPlan();
            unoptimizedPlan.setJobName(name);
            Optimizer compiler = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), flinkConfig);
            return ClusterClient.getOptimizedPlan((Optimizer)compiler, (Plan)unoptimizedPlan, (int)parallelism);
        }

        private ExecutionEnvironment createExecutionEnvironment() {
            ExecutionEnvironment execEnv = ExecutionEnvironment.getExecutionEnvironment();
            execEnv.setParallelism(ExecutionContext.this.mergedEnv.getExecution().getParallelism());
            return execEnv;
        }

        private StreamExecutionEnvironment createStreamExecutionEnvironment() {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(ExecutionContext.this.mergedEnv.getExecution().getParallelism());
            env.setMaxParallelism(ExecutionContext.this.mergedEnv.getExecution().getMaxParallelism());
            env.setStreamTimeCharacteristic(ExecutionContext.this.mergedEnv.getExecution().getTimeCharacteristic());
            return env;
        }

        private QueryConfig createQueryConfig() {
            if (this.streamExecEnv != null) {
                StreamQueryConfig config = new StreamQueryConfig();
                long minRetention = ExecutionContext.this.mergedEnv.getExecution().getMinStateRetention();
                long maxRetention = ExecutionContext.this.mergedEnv.getExecution().getMaxStateRetention();
                config.withIdleStateRetentionTime(Time.milliseconds((long)minRetention), Time.milliseconds((long)maxRetention));
                return config;
            }
            return new BatchQueryConfig();
        }
    }
}

