/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.net.InetAddress;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.experimental.CollectSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;

public class CollectStreamTableSink
implements RetractStreamTableSink<Row> {
    private final InetAddress targetAddress;
    private final int targetPort;
    private final TypeSerializer<Tuple2<Boolean, Row>> serializer;
    private String[] fieldNames;
    private TypeInformation<?>[] fieldTypes;

    public CollectStreamTableSink(InetAddress targetAddress, int targetPort, TypeSerializer<Tuple2<Boolean, Row>> serializer) {
        this.targetAddress = targetAddress;
        this.targetPort = targetPort;
        this.serializer = serializer;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        CollectStreamTableSink copy = new CollectStreamTableSink(this.targetAddress, this.targetPort, this.serializer);
        copy.fieldNames = fieldNames;
        copy.fieldTypes = fieldTypes;
        return copy;
    }

    @Override
    public TypeInformation<Row> getRecordType() {
        return Types.ROW_NAMED((String[])this.fieldNames, this.fieldTypes);
    }

    @Override
    public void emitDataStream(DataStream<Tuple2<Boolean, Row>> stream) {
        stream.addSink((SinkFunction)new CollectSink(this.targetAddress, this.targetPort, this.serializer)).name("SQL Client Collect Sink").setParallelism(1);
    }

    @Override
    public TupleTypeInfo<Tuple2<Boolean, Row>> getOutputType() {
        return new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN, this.getRecordType()});
    }
}

