/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

public class TypedResult<P> {
    private ResultType type;
    private P payload;

    private TypedResult(ResultType type, P payload) {
        this.type = type;
        this.payload = payload;
    }

    public void setType(ResultType type) {
        this.type = type;
    }

    public void setPayload(P payload) {
        this.payload = payload;
    }

    public ResultType getType() {
        return this.type;
    }

    public P getPayload() {
        return this.payload;
    }

    public String toString() {
        return "TypedResult<" + (Object)((Object)this.type) + ">";
    }

    public static <T> TypedResult<T> empty() {
        return new TypedResult<Object>(ResultType.EMPTY, null);
    }

    public static <T> TypedResult<T> payload(T payload) {
        return new TypedResult<T>(ResultType.PAYLOAD, payload);
    }

    public static <T> TypedResult<T> endOfStream() {
        return new TypedResult<Object>(ResultType.EOS, null);
    }

    public static enum ResultType {
        PAYLOAD,
        EMPTY,
        EOS;

    }
}

