/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.client.config.Environment;

public class SessionContext {
    private final String name;
    private final Environment defaultEnvironment;
    private final Map<String, String> sessionProperties;

    public SessionContext(String name, Environment defaultEnvironment) {
        this.name = name;
        this.defaultEnvironment = defaultEnvironment;
        this.sessionProperties = new HashMap<String, String>();
    }

    public void setSessionProperty(String key, String value) {
        this.sessionProperties.put(key, value);
    }

    public void resetSessionProperties() {
        this.sessionProperties.clear();
    }

    public String getName() {
        return this.name;
    }

    public Environment getEnvironment() {
        return Environment.enrich(this.defaultEnvironment, this.sessionProperties);
    }

    public SessionContext copy() {
        SessionContext session = new SessionContext(this.name, this.defaultEnvironment);
        session.sessionProperties.putAll(this.sessionProperties);
        return session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionContext)) {
            return false;
        }
        SessionContext context = (SessionContext)o;
        return Objects.equals(this.name, context.name) && Objects.equals(this.defaultEnvironment, context.defaultEnvironment) && Objects.equals(this.sessionProperties, context.sessionProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.defaultEnvironment, this.sessionProperties);
    }
}

