/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.TableSourceDescriptor;

public class Source
extends TableSourceDescriptor {
    private String name;
    private Map<String, String> properties;
    private static final String NAME = "name";

    private Source(String name, Map<String, String> properties2) {
        this.name = name;
        this.properties = properties2;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static Source create(Map<String, Object> config) {
        if (!config.containsKey(NAME)) {
            throw new SqlClientException("The 'name' attribute of a table source is missing.");
        }
        Object name = config.get(NAME);
        if (name == null || !(name instanceof String) || ((String)name).length() <= 0) {
            throw new SqlClientException("Invalid table source name '" + name + "'.");
        }
        HashMap<String, Object> properties2 = new HashMap<String, Object>(config);
        properties2.remove(NAME);
        return new Source((String)name, ConfigUtil.normalizeYaml(properties2));
    }

    @Override
    public void addProperties(DescriptorProperties properties2) {
        this.properties.forEach(properties2::putString);
    }
}

