/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.table.client.config.ConfigUtil;

public class Execution {
    private final Map<String, String> properties;

    public Execution() {
        this.properties = Collections.emptyMap();
    }

    private Execution(Map<String, String> properties2) {
        this.properties = properties2;
    }

    public boolean isStreamingExecution() {
        return Objects.equals(this.properties.getOrDefault("type", "streaming"), "streaming");
    }

    public boolean isBatchExecution() {
        return Objects.equals(this.properties.getOrDefault("type", "streaming"), "batch");
    }

    public TimeCharacteristic getTimeCharacteristic() {
        String s;
        switch (s = this.properties.getOrDefault("time-characteristic", "event-time")) {
            case "event-time": {
                return TimeCharacteristic.EventTime;
            }
            case "processing-time": {
                return TimeCharacteristic.ProcessingTime;
            }
        }
        return TimeCharacteristic.EventTime;
    }

    public long getMinStateRetention() {
        return Long.parseLong(this.properties.getOrDefault("min-idle-state-retention", Long.toString(Long.MIN_VALUE)));
    }

    public long getMaxStateRetention() {
        return Long.parseLong(this.properties.getOrDefault("max-idle-state-retention", Long.toString(Long.MIN_VALUE)));
    }

    public int getParallelism() {
        return Integer.parseInt(this.properties.getOrDefault("parallelism", Integer.toString(1)));
    }

    public int getMaxParallelism() {
        return Integer.parseInt(this.properties.getOrDefault("max-parallelism", Integer.toString(128)));
    }

    public boolean isChangelogMode() {
        return Objects.equals(this.properties.getOrDefault("result-mode", "changelog"), "changelog");
    }

    public Map<String, String> toProperties() {
        HashMap<String, String> copy = new HashMap<String, String>();
        this.properties.forEach((k, v) -> copy.put("execution." + k, (String)v));
        return copy;
    }

    public static Execution create(Map<String, Object> config) {
        return new Execution(ConfigUtil.normalizeYaml(config));
    }

    public static Execution merge(Execution exec1, Execution exec2) {
        HashMap<String, String> newProperties = new HashMap<String, String>(exec1.properties);
        newProperties.putAll(exec2.properties);
        return new Execution(newProperties);
    }

    public static Execution enrich(Execution exec, Map<String, String> properties2) {
        HashMap<String, String> newProperties = new HashMap<String, String>(exec.properties);
        properties2.forEach((k, v) -> {
            String normalizedKey = k.toLowerCase();
            if (k.startsWith("execution.")) {
                newProperties.put(normalizedKey.substring("execution".length() + 1), (String)v);
            }
        });
        return new Execution(newProperties);
    }
}

