/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.client.config.Deployment;
import org.apache.flink.table.client.config.Execution;
import org.apache.flink.table.client.config.Source;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.TableDescriptor;
import org.apache.flink.table.descriptors.TableDescriptorValidator;

public class Environment {
    private Map<String, TableDescriptor> tables = Collections.emptyMap();
    private Execution execution = new Execution();
    private Deployment deployment = new Deployment();

    public Map<String, TableDescriptor> getTables() {
        return this.tables;
    }

    public void setTables(List<Map<String, Object>> tables) {
        this.tables = new HashMap<String, TableDescriptor>(tables.size());
        tables.forEach(config -> {
            Source s;
            if (!config.containsKey(TableDescriptorValidator.TABLE_TYPE())) {
                throw new SqlClientException("The 'type' attribute of a table is missing.");
            }
            if (config.get(TableDescriptorValidator.TABLE_TYPE()).equals(TableDescriptorValidator.TABLE_TYPE_VALUE_SOURCE())) {
                config.remove(TableDescriptorValidator.TABLE_TYPE());
                s = Source.create(config);
                if (this.tables.containsKey(s.getName())) {
                    throw new SqlClientException("Duplicate source name '" + s + "'.");
                }
            } else {
                throw new SqlClientException("Invalid table 'type' attribute value, only 'source' is supported");
            }
            this.tables.put(s.getName(), s);
        });
    }

    public void setExecution(Map<String, Object> config) {
        this.execution = Execution.create(config);
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setDeployment(Map<String, Object> config) {
        this.deployment = Deployment.create(config);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("===================== Tables =====================\n");
        this.tables.forEach((name, table) -> {
            sb.append("- name: ").append((String)name).append("\n");
            DescriptorProperties props = new DescriptorProperties(true);
            table.addProperties(props);
            props.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Execution ====================\n");
        this.execution.toProperties().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        sb.append("=================== Deployment ===================\n");
        this.deployment.toProperties().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        return sb.toString();
    }

    public static Environment parse(URL url) throws IOException {
        return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(url, Environment.class);
    }

    public static Environment parse(String content) throws IOException {
        return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(content, Environment.class);
    }

    public static Environment merge(Environment env1, Environment env2) {
        Environment mergedEnv = new Environment();
        HashMap<String, TableDescriptor> tables = new HashMap<String, TableDescriptor>(env1.getTables());
        tables.putAll(env2.getTables());
        mergedEnv.tables = tables;
        mergedEnv.execution = Execution.merge(env1.getExecution(), env2.getExecution());
        mergedEnv.deployment = Deployment.merge(env1.getDeployment(), env2.getDeployment());
        return mergedEnv;
    }

    public static Environment enrich(Environment env, Map<String, String> properties2) {
        Environment enrichedEnv = new Environment();
        enrichedEnv.tables = new HashMap<String, TableDescriptor>(env.getTables());
        enrichedEnv.execution = Execution.enrich(env.execution, properties2);
        enrichedEnv.deployment = Deployment.enrich(env.deployment, properties2);
        return enrichedEnv;
    }
}

