/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.table.client.config.ConfigUtil;

public class Deployment {
    private final Map<String, String> properties;

    public Deployment() {
        this.properties = Collections.emptyMap();
    }

    private Deployment(Map<String, String> properties2) {
        this.properties = properties2;
    }

    public boolean isStandaloneDeployment() {
        return Objects.equals(this.properties.getOrDefault("type", "standalone"), "standalone");
    }

    public long getResponseTimeout() {
        return Long.parseLong(this.properties.getOrDefault("response-timeout", Long.toString(10000L)));
    }

    public String getGatewayAddress() {
        return this.properties.getOrDefault("gateway-address", "");
    }

    public int getGatewayPort() {
        return Integer.parseInt(this.properties.getOrDefault("gateway-port", Integer.toString(0)));
    }

    public CommandLine getCommandLine(Options commandLineOptions) throws Exception {
        ArrayList args = new ArrayList();
        this.properties.forEach((k, v) -> {
            if (commandLineOptions.hasOption(k)) {
                Option o = commandLineOptions.getOption(k);
                String argument = "--" + o.getLongOpt();
                if (!o.hasArg()) {
                    Boolean flag = Boolean.parseBoolean(v);
                    if (flag.booleanValue()) {
                        args.add(argument);
                    }
                } else if (!o.hasArgs()) {
                    args.add(argument);
                    args.add(v);
                } else {
                    throw new IllegalArgumentException("Option '" + o + "' is not supported yet.");
                }
            }
        });
        return CliFrontendParser.parse((Options)commandLineOptions, (String[])args.toArray(new String[args.size()]), (boolean)true);
    }

    public Map<String, String> toProperties() {
        HashMap<String, String> copy = new HashMap<String, String>();
        this.properties.forEach((k, v) -> copy.put("deployment." + k, (String)v));
        return copy;
    }

    public static Deployment create(Map<String, Object> config) {
        return new Deployment(ConfigUtil.normalizeYaml(config));
    }

    public static Deployment merge(Deployment deploy1, Deployment deploy2) {
        HashMap<String, String> properties2 = new HashMap<String, String>(deploy1.properties);
        properties2.putAll(deploy2.properties);
        return new Deployment(properties2);
    }

    public static Deployment enrich(Deployment deploy, Map<String, String> properties2) {
        HashMap<String, String> newProperties = new HashMap<String, String>(deploy.properties);
        properties2.forEach((k, v) -> {
            String normalizedKey = k.toLowerCase();
            if (k.startsWith("deployment.")) {
                newProperties.put(normalizedKey.substring("deployment".length() + 1), (String)v);
            }
        });
        return new Deployment(newProperties);
    }
}

