/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

public final class SqlCommandParser {
    private SqlCommandParser() {
    }

    public static SqlCommandCall parse(String stmt) {
        String trimmed = stmt.trim();
        if (trimmed.endsWith(";")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        block0: for (SqlCommand cmd : SqlCommand.values()) {
            int pos = 0;
            int tokenCount = 0;
            for (String token : trimmed.split("\\s")) {
                pos += token.length() + 1;
                if (token.length() <= 0) continue;
                if (tokenCount >= cmd.tokens.length || !token.equalsIgnoreCase(cmd.tokens[tokenCount])) continue block0;
                if (tokenCount == cmd.tokens.length - 1) {
                    return new SqlCommandCall(cmd, SqlCommandParser.splitOperands(cmd, trimmed, trimmed.substring(Math.min(pos, trimmed.length()))));
                }
                ++tokenCount;
            }
        }
        return null;
    }

    private static String[] splitOperands(SqlCommand cmd, String originalCall, String operands) {
        switch (cmd) {
            case SET: {
                int delimiter = operands.indexOf(61);
                if (delimiter < 0) {
                    return new String[0];
                }
                return new String[]{operands.substring(0, delimiter), operands.substring(delimiter + 1)};
            }
            case SELECT: {
                return new String[]{originalCall};
            }
        }
        return new String[]{operands};
    }

    public static class SqlCommandCall {
        public final SqlCommand command;
        public final String[] operands;

        public SqlCommandCall(SqlCommand command, String[] operands) {
            this.command = command;
            this.operands = operands;
        }
    }

    static enum SqlCommand {
        QUIT("quit"),
        EXIT("exit"),
        CLEAR("clear"),
        HELP("help"),
        SHOW_TABLES("show tables"),
        DESCRIBE("describe"),
        EXPLAIN("explain"),
        SELECT("select"),
        SET("set"),
        RESET("reset"),
        SOURCE("source");

        public final String command;
        public final String[] tokens;

        private SqlCommand(String command) {
            this.command = command;
            this.tokens = command.split(" ");
        }

        public String toString() {
            return this.command.toUpperCase();
        }
    }
}

