/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliOptions;

public class CliOptionsParser {
    public static final Option OPTION_HELP = Option.builder((String)"h").required(false).longOpt("help").desc("Show the help message with descriptions of all options.").build();
    public static final Option OPTION_SESSION = Option.builder((String)"s").required(false).longOpt("session").numberOfArgs(1).argName("session identifier").desc("The identifier for a session. 'default' is the default identifier.").build();
    public static final Option OPTION_ENVIRONMENT = Option.builder((String)"e").required(false).longOpt("environment").numberOfArgs(1).argName("environment file").desc("The environment properties to be imported into the session. It might overwrite default environment properties.").build();
    public static final Option OPTION_DEFAULTS = Option.builder((String)"d").required(false).longOpt("defaults").numberOfArgs(1).argName("environment file").desc("The environment properties with which every new session is initialized. Properties might be overwritten by session properties.").build();
    public static final Option OPTION_JAR = Option.builder((String)"j").required(false).longOpt("jar").numberOfArgs(1).argName("JAR file").desc("A JAR file to be imported into the session. The file might contain user-defined classes needed for the execution of statements such as functions, table sources, or sinks. Can be used multiple times.").build();
    public static final Option OPTION_LIBRARY = Option.builder((String)"l").required(false).longOpt("library").numberOfArgs(1).argName("JAR directory").desc("A JAR file directory with which every new session is initialized. The files might contain user-defined classes needed for the execution of statements such as functions, table sources, or sinks. Can be used multiple times.").build();
    private static final Options EMBEDDED_MODE_CLIENT_OPTIONS = CliOptionsParser.getEmbeddedModeClientOptions(new Options());
    private static final Options GATEWAY_MODE_CLIENT_OPTIONS = CliOptionsParser.getGatewayModeClientOptions(new Options());
    private static final Options GATEWAY_MODE_GATEWAY_OPTIONS = CliOptionsParser.getGatewayModeGatewayOptions(new Options());

    private static void buildGeneralOptions(Options options) {
        options.addOption(OPTION_HELP);
    }

    public static Options getEmbeddedModeClientOptions(Options options) {
        CliOptionsParser.buildGeneralOptions(options);
        options.addOption(OPTION_SESSION);
        options.addOption(OPTION_ENVIRONMENT);
        options.addOption(OPTION_DEFAULTS);
        options.addOption(OPTION_JAR);
        options.addOption(OPTION_LIBRARY);
        return options;
    }

    public static Options getGatewayModeClientOptions(Options options) {
        CliOptionsParser.buildGeneralOptions(options);
        options.addOption(OPTION_SESSION);
        options.addOption(OPTION_ENVIRONMENT);
        return options;
    }

    public static Options getGatewayModeGatewayOptions(Options options) {
        CliOptionsParser.buildGeneralOptions(options);
        options.addOption(OPTION_DEFAULTS);
        options.addOption(OPTION_JAR);
        options.addOption(OPTION_LIBRARY);
        return options;
    }

    public static void printHelpClient() {
        System.out.println("./sql-client [MODE] [OPTIONS]");
        System.out.println();
        System.out.println("The following options are available:");
        CliOptionsParser.printHelpEmbeddedModeClient();
        CliOptionsParser.printHelpGatewayModeClient();
        System.out.println();
    }

    public static void printHelpGateway() {
        System.out.println("./sql-gateway [OPTIONS]");
        System.out.println();
        System.out.println("The following options are available:");
        CliOptionsParser.printHelpGatewayModeGateway();
        System.out.println();
    }

    public static void printHelpEmbeddedModeClient() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(5);
        formatter.setWidth(80);
        System.out.println("\nMode \"embedded\" submits Flink jobs from the local machine.");
        System.out.println("\n  Syntax: embedded [OPTIONS]");
        formatter.setSyntaxPrefix("  \"embedded\" mode options:");
        formatter.printHelp(" ", EMBEDDED_MODE_CLIENT_OPTIONS);
        System.out.println();
    }

    public static void printHelpGatewayModeClient() {
    }

    public static void printHelpGatewayModeGateway() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(5);
        formatter.setWidth(80);
        formatter.printHelp(" ", GATEWAY_MODE_GATEWAY_OPTIONS);
        System.out.println();
    }

    public static CliOptions parseEmbeddedModeClient(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(EMBEDDED_MODE_CLIENT_OPTIONS, args, true);
            return new CliOptions(line.hasOption(OPTION_HELP.getOpt()), CliOptionsParser.checkSessionId(line), CliOptionsParser.checkUrl(line, OPTION_ENVIRONMENT), CliOptionsParser.checkUrl(line, OPTION_DEFAULTS), CliOptionsParser.checkUrls(line, OPTION_JAR), CliOptionsParser.checkUrls(line, OPTION_LIBRARY));
        }
        catch (ParseException e2) {
            throw new SqlClientException(e2.getMessage());
        }
    }

    public static CliOptions parseGatewayModeClient(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(GATEWAY_MODE_CLIENT_OPTIONS, args, true);
            return new CliOptions(line.hasOption(OPTION_HELP.getOpt()), CliOptionsParser.checkSessionId(line), CliOptionsParser.checkUrl(line, OPTION_ENVIRONMENT), null, CliOptionsParser.checkUrls(line, OPTION_JAR), CliOptionsParser.checkUrls(line, OPTION_LIBRARY));
        }
        catch (ParseException e2) {
            throw new SqlClientException(e2.getMessage());
        }
    }

    public static CliOptions parseGatewayModeGateway(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(GATEWAY_MODE_GATEWAY_OPTIONS, args, true);
            return new CliOptions(line.hasOption(OPTION_HELP.getOpt()), null, null, CliOptionsParser.checkUrl(line, OPTION_DEFAULTS), CliOptionsParser.checkUrls(line, OPTION_JAR), CliOptionsParser.checkUrls(line, OPTION_LIBRARY));
        }
        catch (ParseException e2) {
            throw new SqlClientException(e2.getMessage());
        }
    }

    private static URL checkUrl(CommandLine line, Option option) {
        List<URL> urls = CliOptionsParser.checkUrls(line, option);
        if (urls != null && !urls.isEmpty()) {
            return urls.get(0);
        }
        return null;
    }

    private static List<URL> checkUrls(CommandLine line, Option option) {
        if (line.hasOption(option.getOpt())) {
            String[] urls = line.getOptionValues(option.getOpt());
            return Arrays.stream(urls).distinct().map(url -> {
                try {
                    return Path.fromLocalFile((File)new File((String)url).getAbsoluteFile()).toUri().toURL();
                }
                catch (Exception e2) {
                    throw new SqlClientException("Invalid path for option '" + option.getLongOpt() + "': " + url, e2);
                }
            }).collect(Collectors.toList());
        }
        return null;
    }

    private static String checkSessionId(CommandLine line) {
        String sessionId = line.getOptionValue(OPTION_SESSION.getOpt());
        if (sessionId != null && !sessionId.matches("[a-zA-Z0-9_\\-.]+")) {
            throw new SqlClientException("Session identifier must only consists of 'a-zA-Z0-9_-.'.");
        }
        return sessionId;
    }
}

