/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.annotation.TableType;
import org.apache.flink.table.api.AmbiguousTableSourceConverterException;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.NoMatchedTableSourceConverterException;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.ExternalTableSourceUtil$;
import org.apache.flink.table.catalog.TableSourceConverter;
import org.apache.flink.table.plan.schema.BatchTableSourceTable;
import org.apache.flink.table.plan.schema.StreamTableSourceTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.plan.stats.FlinkStatistic$;
import org.apache.flink.table.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.flink.table.shaded.org.apache.commons.configuration.ConversionException;
import org.apache.flink.table.shaded.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.flink.table.shaded.org.reflections.Reflections;
import org.apache.flink.table.shaded.org.reflections.scanners.Scanner;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceFactoryService$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;

public final class ExternalTableSourceUtil$
implements Logging {
    public static final ExternalTableSourceUtil$ MODULE$;
    private final String tableSourceConverterConfigFileName;
    private final HashMap<String, scala.collection.mutable.Set<Class<? extends TableSourceConverter<?>>>> tableTypeToTableSourceConvertersClazz;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ExternalTableSourceUtil$();
    }

    private Logger LOG$lzycompute() {
        ExternalTableSourceUtil$ externalTableSourceUtil$ = this;
        synchronized (externalTableSourceUtil$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public TableSourceTable<?> fromExternalCatalogTable(TableEnvironment tableEnv, ExternalCatalogTable externalCatalogTable) {
        block7: {
            void var3_3;
            block8: {
                TableSourceTable<?> tableSourceTable;
                block3: {
                    TableSourceTable tableSourceTable2;
                    block6: {
                        TableEnvironment tableEnvironment;
                        TableSource<?> source;
                        block4: {
                            block5: {
                                BatchTableSourceTable batchTableSourceTable;
                                block2: {
                                    if (!externalCatalogTable.isLegacyTableType()) break block2;
                                    this.LOG().warn("External catalog tables based on TableType annotations are deprecated. Please consider updating them to TableSourceFactories.");
                                    tableSourceTable = this.fromExternalCatalogTableType(externalCatalogTable);
                                    break block3;
                                }
                                source = TableSourceFactoryService$.MODULE$.findAndCreateTableSource(externalCatalogTable);
                                tableEnvironment = tableEnv;
                                if (!(tableEnvironment instanceof BatchTableEnvironment)) break block4;
                                TableSource<?> tableSource = source;
                                if (!(tableSource instanceof BatchTableSource)) break block5;
                                BatchTableSource batchTableSource = (BatchTableSource)tableSource;
                                tableSourceTable2 = batchTableSourceTable = new BatchTableSourceTable(batchTableSource, new FlinkStatistic(externalCatalogTable.getTableStats()));
                                break block6;
                            }
                            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found table source '", "' is not applicable "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in a batch environment."})).s((Seq)Nil$.MODULE$)).toString());
                        }
                        if (!(tableEnvironment instanceof StreamTableEnvironment)) break block7;
                        TableSource<?> tableSource = source;
                        if (!(tableSource instanceof StreamTableSource)) break block8;
                        StreamTableSource streamTableSource = (StreamTableSource)tableSource;
                        StreamTableSourceTable streamTableSourceTable = new StreamTableSourceTable(streamTableSource, new FlinkStatistic(externalCatalogTable.getTableStats()));
                        tableSourceTable2 = streamTableSourceTable;
                    }
                    tableSourceTable = tableSourceTable2;
                }
                return tableSourceTable;
            }
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found table source '", "' is not applicable "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in a streaming environment."})).s((Seq)Nil$.MODULE$)).toString());
        }
        throw new TableException("Unsupported table environment.");
    }

    private String tableSourceConverterConfigFileName() {
        return this.tableSourceConverterConfigFileName;
    }

    private HashMap<String, scala.collection.mutable.Set<Class<? extends TableSourceConverter<?>>>> tableTypeToTableSourceConvertersClazz() {
        return this.tableTypeToTableSourceConvertersClazz;
    }

    @VisibleForTesting
    public HashMap<String, scala.collection.mutable.Set<Class<? extends TableSourceConverter<?>>>> injectTableSourceConverter(String tableType2, Class<? extends TableSourceConverter<?>> converterClazz) {
        return (HashMap)((MultiMap)this.tableTypeToTableSourceConvertersClazz()).addBinding((Object)tableType2, converterClazz);
    }

    private scala.collection.immutable.Set<String> parseScanPackagesFromConfigFile(URL url) {
        scala.collection.immutable.Set set;
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(url);
            config.setListDelimiter(',');
            set = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])config.getStringArray("scan.packages")).filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1.isEmpty();
                }
            })).toSet();
        }
        catch (ConversionException conversionException) {
            this.LOG().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error happened while parsing 'scan.packages' field of properties file [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The value is not a String or List of Strings."})).s((Seq)Nil$.MODULE$)).toString(), (Throwable)conversionException);
            set = Predef$.MODULE$.Set().empty();
        }
        catch (ConfigurationException configurationException) {
            this.LOG().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error happened while loading the properties file [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})), (Throwable)configurationException);
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public TableSourceTable<?> fromExternalCatalogTableType(ExternalCatalogTable externalCatalogTable) {
        Option option;
        block7: {
            block10: {
                TableSourceTable tableSourceTable;
                block9: {
                    Object t;
                    FlinkStatistic flinkStatistic;
                    block8: {
                        String tableType2 = externalCatalogTable.tableType();
                        Set<String> propertyKeys = externalCatalogTable.properties().keySet();
                        option = this.tableTypeToTableSourceConvertersClazz().get((Object)tableType2);
                        if (!(option instanceof Some)) break block7;
                        Some some = (Some)option;
                        scala.collection.mutable.Set converterClasses = (scala.collection.mutable.Set)some.x();
                        scala.collection.mutable.Set matchedConverters = (scala.collection.mutable.Set)converterClasses.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final TableSourceConverter<?> apply(Class<? extends TableSourceConverter<?>> x$2) {
                                return (TableSourceConverter)InstantiationUtil.instantiate(x$2);
                            }
                        }, Set$.MODULE$.canBuildFrom());
                        if (matchedConverters.isEmpty()) {
                            this.LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find any TableSourceConverter binded to table type [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Register TableSourceConverter via externalCatalogTable.properties file."})).s((Seq)Nil$.MODULE$)).toString());
                            throw new NoMatchedTableSourceConverterException(tableType2);
                        }
                        scala.collection.mutable.Set filteredMatchedConverters = (scala.collection.mutable.Set)matchedConverters.filter((Function1)new Serializable(propertyKeys){
                            public static final long serialVersionUID = 0L;
                            private final Set propertyKeys$1;

                            public final boolean apply(TableSourceConverter<?> converter) {
                                return this.propertyKeys$1.containsAll(converter.requiredProperties());
                            }
                            {
                                this.propertyKeys$1 = propertyKeys$1;
                            }
                        });
                        if (filteredMatchedConverters.isEmpty()) {
                            this.LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find any matched TableSourceConverter for type [", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"because the required properties does not match."})).s((Seq)Nil$.MODULE$)).toString());
                            throw new NoMatchedTableSourceConverterException(tableType2);
                        }
                        if (filteredMatchedConverters.size() > 1) {
                            this.LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finds more than one matched TableSourceConverter for type [", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"they are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filteredMatchedConverters.map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(TableSourceConverter<?> x$3) {
                                    return x$3.getClass().getName();
                                }
                            }, Set$.MODULE$.canBuildFrom())}))).toString());
                            throw new AmbiguousTableSourceConverterException(tableType2);
                        }
                        Object convertedTableSource = ((TableSourceConverter)filteredMatchedConverters.head()).fromExternalCatalogTable(externalCatalogTable);
                        flinkStatistic = externalCatalogTable.stats() == null ? FlinkStatistic$.MODULE$.UNKNOWN() : FlinkStatistic$.MODULE$.of(externalCatalogTable.stats());
                        t = convertedTableSource;
                        if (!(t instanceof StreamTableSource)) break block8;
                        StreamTableSource streamTableSource = (StreamTableSource)t;
                        tableSourceTable = new StreamTableSourceTable(streamTableSource, flinkStatistic);
                        break block9;
                    }
                    if (!(t instanceof BatchTableSource)) break block10;
                    BatchTableSource batchTableSource = (BatchTableSource)t;
                    tableSourceTable = new BatchTableSourceTable(batchTableSource, flinkStatistic);
                }
                StreamTableSourceTable streamTableSourceTable = tableSourceTable;
                return streamTableSourceTable;
            }
            throw new TableException("Unknown TableSource type.");
        }
        if (None$.MODULE$.equals(option)) {
            void var2_2;
            this.LOG().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find any TableSourceConverter binded to table type [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Register TableSourceConverter via externalCatalogTable.properties file."})).s((Seq)Nil$.MODULE$)).toString());
            throw new NoMatchedTableSourceConverterException((String)var2_2);
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    private ExternalTableSourceUtil$() {
        void var1_1;
        MODULE$ = this;
        Logging$class.$init$(this);
        this.tableSourceConverterConfigFileName = "tableSourceConverter.properties";
        MultiMap registeredConverters = new MultiMap<String, Class<? extends TableSourceConverter<?>>>(){

            public scala.collection.mutable.Set<Class<? extends TableSourceConverter<?>>> makeSet() {
                return MultiMap.class.makeSet((MultiMap)this);
            }

            public MultiMap addBinding(Object key, Object value) {
                return MultiMap.class.addBinding((MultiMap)this, (Object)key, (Object)value);
            }

            public MultiMap removeBinding(Object key, Object value) {
                return MultiMap.class.removeBinding((MultiMap)this, (Object)key, (Object)value);
            }

            public boolean entryExists(Object key, Function1 p) {
                return MultiMap.class.entryExists((MultiMap)this, (Object)key, (Function1)p);
            }
            {
                MultiMap.class.$init$((MultiMap)this);
            }
        };
        Enumeration<URL> resourceUrls = this.getClass().getClassLoader().getResources(this.tableSourceConverterConfigFileName());
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            scala.collection.immutable.Set<String> scanPackages = this.parseScanPackagesFromConfigFile(url);
            scanPackages.foreach((Function1)new Serializable((HashMap)registeredConverters){
                public static final long serialVersionUID = 0L;
                public final HashMap registeredConverters$1;

                public final void apply(String scanPackage) {
                    Set<Class<?>> clazzWithAnnotations = new Reflections(scanPackage, new Scanner[0]).getTypesAnnotatedWith(TableType.class);
                    ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(clazzWithAnnotations).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.1 $outer;

                        public final void apply(Class<?> clazz) {
                            if (TableSourceConverter.class.isAssignableFrom(clazz)) {
                                String errorInfo = InstantiationUtil.checkForInstantiationError(clazz);
                                if (errorInfo == null) {
                                    TableType tableTypeAnnotation = clazz.getAnnotation(TableType.class);
                                    String tableType2 = tableTypeAnnotation.value();
                                    Class<?> converterClazz = clazz;
                                    ((MultiMap)this.$outer.registeredConverters$1).addBinding((Object)tableType2, converterClazz);
                                    ExternalTableSourceUtil$.MODULE$.LOG().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registers the converter ", " to table type [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName(), tableType2})));
                                } else {
                                    ExternalTableSourceUtil$.MODULE$.LOG().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class ", " is annotated with TableType, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but is not instantiable because ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorInfo}))).toString());
                                }
                            } else {
                                ExternalTableSourceUtil$.MODULE$.LOG().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class ", " is annotated with TableType, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but does not implement the TableSourceConverter interface."})).s((Seq)Nil$.MODULE$)).toString());
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.registeredConverters$1 = registeredConverters$1;
                }
            });
        }
        this.tableTypeToTableSourceConvertersClazz = var1_1;
    }
}

