/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc;

import java.nio.ByteBuffer;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Geometry;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.GeometryEngine;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Operator;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorBoundary;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorExportToGeoJson;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorExportToWkb;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.OperatorFactoryLocal;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Polyline;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.SpatialReference;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc.OGCLineString;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.ogc.OGCMultiCurve;

public class OGCMultiLineString
extends OGCMultiCurve {
    Polyline polyline;

    public OGCMultiLineString(Polyline poly, SpatialReference sr) {
        this.polyline = poly;
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 8);
    }

    @Override
    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(1, null, this.getEsriGeometry());
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(8, this.getEsriGeometry(), null);
    }

    @Override
    public OGCGeometry geometryN(int n) {
        OGCLineString ls = new OGCLineString(this.polyline, n, this.esriSR);
        return ls;
    }

    @Override
    public String geometryType() {
        return "MultiLineString";
    }

    @Override
    public OGCGeometry boundary() {
        OperatorBoundary op = (OperatorBoundary)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Boundary);
        Geometry g = op.execute(this.polyline, null);
        return OGCGeometry.createFromEsriGeometry(g, this.esriSR, true);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polyline;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }
}

