/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry;

import java.nio.ByteBuffer;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.AttributeStreamBase;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.GeometryException;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.NumberUtils;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Point;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.VertexDescription;

final class AttributeStreamOfFloat
extends AttributeStreamBase {
    private float[] m_buffer = null;
    private int m_size;

    public int size() {
        return this.m_size;
    }

    public void reserve(int reserve) {
        if (reserve <= 0) {
            return;
        }
        if (this.m_buffer == null) {
            this.m_buffer = new float[reserve];
        } else {
            if (reserve <= this.m_buffer.length) {
                return;
            }
            float[] buf = new float[reserve];
            System.arraycopy(this.m_buffer, 0, buf, 0, this.m_size);
            this.m_buffer = buf;
        }
    }

    public int capacity() {
        return this.m_buffer != null ? this.m_buffer.length : 0;
    }

    public AttributeStreamOfFloat(int size) {
        int sz = size;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new float[sz];
        this.m_size = size;
    }

    public AttributeStreamOfFloat(int size, float defaultValue) {
        int sz = size;
        if (sz < 2) {
            sz = 2;
        }
        this.m_buffer = new float[sz];
        this.m_size = size;
        for (int i = 0; i < size; ++i) {
            this.m_buffer[i] = defaultValue;
        }
    }

    public AttributeStreamOfFloat(AttributeStreamOfFloat other) {
        this.m_buffer = (float[])other.m_buffer.clone();
        this.m_size = other.m_size;
    }

    public AttributeStreamOfFloat(AttributeStreamOfFloat other, int maxSize) {
        int sz;
        this.m_size = other.size();
        if (this.m_size > maxSize) {
            this.m_size = maxSize;
        }
        if ((sz = this.m_size) < 2) {
            sz = 2;
        }
        this.m_buffer = new float[sz];
        System.arraycopy(other.m_buffer, 0, this.m_buffer, 0, this.m_size);
    }

    public float read(int offset) {
        return this.m_buffer[offset];
    }

    public void write(int offset, float value) {
        if (this.m_bReadonly) {
            throw new RuntimeException("invalid_call");
        }
        this.m_buffer[offset] = value;
    }

    public void add(float v) {
        this.resize(this.m_size + 1);
        this.m_buffer[this.m_size - 1] = v;
    }

    @Override
    public AttributeStreamBase restrictedClone(int maxsize) {
        int len = this.m_size;
        int newSize = maxsize < len ? maxsize : len;
        float[] newBuffer = new float[newSize];
        System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
        this.m_buffer = newBuffer;
        this.m_size = newSize;
        return this;
    }

    @Override
    public int virtualSize() {
        return this.size();
    }

    @Override
    public int getPersistence() {
        return 0;
    }

    @Override
    public double readAsDbl(int offset) {
        return this.read(offset);
    }

    @Override
    public int readAsInt(int offset) {
        return (int)this.read(offset);
    }

    @Override
    public long readAsInt64(int offset) {
        return (long)this.read(offset);
    }

    @Override
    public void resize(int newSize) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                float[] newBuffer = new float[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                float[] newBuffer = new float[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        }
    }

    @Override
    public void resizePreserveCapacity(int newSize) {
        if (this.m_buffer == null || newSize > this.m_buffer.length) {
            this.resize(newSize);
        }
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        this.m_size = newSize;
    }

    @Override
    public void resize(int newSize, double defaultValue) {
        if (this.m_bLockedInSize) {
            throw new GeometryException("invalid call. Attribute Stream is locked and cannot be resized.");
        }
        if (newSize <= this.m_size) {
            if (newSize * 5 / 4 < this.m_buffer.length) {
                float[] newBuffer = new float[newSize];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, newSize);
                this.m_buffer = newBuffer;
            }
            this.m_size = newSize;
        } else {
            if (newSize > this.m_buffer.length) {
                int sz = newSize < 64 ? Math.max(newSize * 2, 4) : newSize * 5 / 4;
                float[] newBuffer = new float[sz];
                System.arraycopy(this.m_buffer, 0, newBuffer, 0, this.m_size);
                this.m_buffer = newBuffer;
            }
            for (int i = this.m_size; i < newSize; ++i) {
                this.m_buffer[i] = (float)defaultValue;
            }
            this.m_size = newSize;
        }
    }

    @Override
    public void writeAsDbl(int offset, double d) {
        this.write(offset, (float)d);
    }

    @Override
    public void writeAsInt64(int offset, long d) {
        this.write(offset, d);
    }

    @Override
    public void writeAsInt(int offset, int d) {
        this.write(offset, d);
    }

    @Override
    public int calculateHashImpl(int hashCode, int start, int end) {
        int n = this.size();
        for (int i = start; i < n && i < end; ++i) {
            hashCode = NumberUtils.hash(hashCode, this.read(i));
        }
        return hashCode;
    }

    @Override
    public boolean equals(AttributeStreamBase other, int start, int end) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeStreamOfFloat)) {
            return false;
        }
        AttributeStreamOfFloat _other = (AttributeStreamOfFloat)other;
        int size = this.size();
        int sizeOther = _other.size();
        if (end > size || end > sizeOther && size != sizeOther) {
            return false;
        }
        if (end > size) {
            end = size;
        }
        for (int i = start; i < end; ++i) {
            if (this.read(i) == _other.read(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addRange(AttributeStreamBase src, int start, int count, boolean bForward, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.m_size;
        int newSize = oldSize + count;
        this.resize(newSize);
        if (bForward) {
            System.arraycopy(((AttributeStreamOfFloat)src).m_buffer, start, this.m_buffer, oldSize, count);
        } else {
            int n = count;
            for (int i = 0; i < count; i += stride) {
                n -= stride;
                for (int s = 0; s < stride; ++s) {
                    this.m_buffer[oldSize + i + s] = ((AttributeStreamOfFloat)src).m_buffer[start + n + s];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, AttributeStreamBase src, int srcStart, int count, boolean bForward, int stride, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (!(bForward || stride >= 1 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count, validSize - start);
        if (this.m_buffer == ((AttributeStreamOfFloat)src).m_buffer && start < srcStart) {
            srcStart += count;
        }
        if (bForward) {
            System.arraycopy(((AttributeStreamOfFloat)src).m_buffer, srcStart, this.m_buffer, start, count);
        } else {
            int n = count;
            for (int i = 0; i < count; i += stride) {
                n -= stride;
                for (int s = 0; s < stride; ++s) {
                    this.m_buffer[start + i + s] = ((AttributeStreamOfFloat)src).m_buffer[srcStart + n + s];
                }
            }
        }
    }

    @Override
    public void insertRange(int start, double value, int count, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + count, validSize - start);
        float v = (float)value;
        for (int i = 0; i < count; ++i) {
            this.m_buffer[start + i] = v;
        }
    }

    @Override
    public void insertAttributes(int start, Point pt, int semantics, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        int comp = VertexDescription.getComponentCount(semantics);
        System.arraycopy(this.m_buffer, start, this.m_buffer, start + comp, validSize - start);
        for (int c = 0; c < comp; ++c) {
            this.m_buffer[start + c] = (float)pt.getAttributeAsDbl(semantics, c);
        }
    }

    @Override
    public void eraseRange(int index, int count, int validSize) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (index + count > this.m_size) {
            throw new GeometryException("invalid_call");
        }
        System.arraycopy(this.m_buffer, index + count, this.m_buffer, index, validSize - (index + count));
        this.m_size -= count;
    }

    @Override
    public void readRange(int srcStart, int count, ByteBuffer dst, int dstOffset, boolean bForward) {
        if (srcStart < 0 || count < 0 || dstOffset < 0 || this.size() < count + srcStart) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (dst.capacity() < dstOffset + elmSize * count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        int j2 = srcStart;
        if (!bForward) {
            j2 += count - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = dstOffset;
        int i = 0;
        while (i < count) {
            dst.putFloat(offset, this.m_buffer[j2]);
            j2 += dj;
            ++i;
            offset += elmSize;
        }
    }

    @Override
    public void reverseRange(int index, int count, int stride) {
        if (this.m_bReadonly) {
            throw new GeometryException("invalid_call");
        }
        if (stride < 1 || count % stride != 0) {
            throw new GeometryException("invalid_call");
        }
        int cIterations = count >> 1;
        int n = count;
        for (int i = 0; i < cIterations; i += stride) {
            n -= stride;
            for (int s = 0; s < stride; ++s) {
                float temp = this.m_buffer[index + i + s];
                this.m_buffer[index + i + s] = this.m_buffer[index + n + s];
                this.m_buffer[index + n + s] = temp;
            }
        }
    }

    @Override
    public void setRange(double value, int start, int count) {
        if (start < 0 || count < 0 || start < 0 || count + start > this.size()) {
            throw new IllegalArgumentException();
        }
        float v = (float)value;
        int n = start + count;
        for (int i = start; i < n; ++i) {
            this.write(i, v);
        }
    }

    @Override
    public void writeRange(int startElement, int count, AttributeStreamBase _src, int srcStart, boolean bForward, int stride) {
        if (startElement < 0 || count < 0 || srcStart < 0) {
            throw new IllegalArgumentException();
        }
        if (!(bForward || stride > 0 && count % stride == 0)) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfFloat src = (AttributeStreamOfFloat)_src;
        if (src.size() < srcStart + count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + startElement) {
            this.resize(count + startElement);
        }
        if (_src == this) {
            this._selfWriteRangeImpl(startElement, count, srcStart, bForward, stride);
            return;
        }
        if (bForward) {
            int j2 = startElement;
            int offset = srcStart;
            for (int i = 0; i < count; ++i) {
                this.m_buffer[j2] = src.m_buffer[offset];
                ++j2;
                ++offset;
            }
        } else {
            int j3 = startElement;
            int offset = srcStart + count - stride;
            if (stride == 1) {
                for (int i = 0; i < count; ++i) {
                    this.m_buffer[j3] = src.m_buffer[offset];
                    ++j3;
                    --offset;
                }
            } else {
                int n = count / stride;
                for (int i = 0; i < n; ++i) {
                    for (int k = 0; k < stride; ++k) {
                        this.m_buffer[j3 + k] = src.m_buffer[offset + k];
                    }
                    j3 += stride;
                    offset -= stride;
                }
            }
        }
    }

    private void _selfWriteRangeImpl(int toElement, int count, int fromElement, boolean bForward, int stride) {
        int dj;
        int k;
        int i;
        int n;
        int j2;
        int offset;
        if (bForward && toElement == fromElement) {
            return;
        }
        if (fromElement < toElement) {
            offset = fromElement + count - stride;
            j2 = toElement + count - stride;
            n = count / 2;
            for (i = 0; i < n; ++i) {
                for (k = 0; k < stride; ++k) {
                    this.m_buffer[j2 + k] = this.m_buffer[offset + k];
                }
                j2 -= stride;
                offset -= stride;
            }
        } else {
            offset = fromElement;
            j2 = toElement;
            dj = 1;
            for (i = 0; i < count; ++i) {
                this.m_buffer[j2] = this.m_buffer[offset];
                ++j2;
                ++offset;
            }
        }
        if (!bForward) {
            j2 = toElement;
            offset = toElement + count - stride;
            dj = stride;
            n = count / 2;
            for (i = 0; i < n; ++i) {
                for (k = 0; k < stride; ++k) {
                    float v = this.m_buffer[j2 + k];
                    this.m_buffer[j2 + k] = this.m_buffer[offset + k];
                    this.m_buffer[offset + k] = v;
                }
                j2 += stride;
                offset -= stride;
            }
        }
    }

    @Override
    public void writeRange(int startElement, int count, ByteBuffer src, int offsetBytes, boolean bForward) {
        if (startElement < 0 || count < 0 || offsetBytes < 0) {
            throw new IllegalArgumentException();
        }
        int elmSize = NumberUtils.sizeOf(0.0);
        if (src.capacity() < offsetBytes + elmSize * count) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return;
        }
        if (this.size() < count + startElement) {
            this.resize(count + startElement);
        }
        int j2 = startElement;
        if (!bForward) {
            j2 += count - 1;
        }
        int dj = bForward ? 1 : -1;
        int offset = offsetBytes;
        int i = 0;
        while (i < count) {
            this.m_buffer[j2] = src.getFloat(offset);
            j2 += dj;
            ++i;
            offset += elmSize;
        }
    }
}

