/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.validate.ScopeChild;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.com.google.common.base.Function;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;

public interface SqlValidatorScope {
    public SqlValidator getValidator();

    public SqlNode getNode();

    public void resolve(List<String> var1, SqlNameMatcher var2, boolean var3, Resolved var4);

    @Deprecated
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String var1, SqlNode var2);

    public Map<String, ScopeChild> findQualifyingTableNames(String var1, SqlNode var2, SqlNameMatcher var3);

    public void findAllColumnNames(List<SqlMoniker> var1);

    public void findAliases(Collection<SqlMoniker> var1);

    public SqlQualified fullyQualify(SqlIdentifier var1);

    public void addChild(SqlValidatorNamespace var1, String var2, boolean var3);

    public SqlWindow lookupWindow(String var1);

    public SqlMonotonicity getMonotonicity(SqlNode var1);

    public SqlNodeList getOrderList();

    public RelDataType resolveColumn(String var1, SqlNode var2);

    public SqlValidatorScope getOperandScope(SqlCall var1);

    public void validateExpr(SqlNode var1);

    @Deprecated
    public SqlValidatorNamespace getTableNamespace(List<String> var1);

    public void resolveTable(List<String> var1, SqlNameMatcher var2, Path var3, Resolved var4);

    public RelDataType nullifyType(SqlNode var1, RelDataType var2);

    public static class Resolve {
        public final SqlValidatorNamespace namespace;
        private final boolean nullable;
        public final SqlValidatorScope scope;
        public final Path path;
        final List<String> remainingNames;

        Resolve(SqlValidatorNamespace namespace, boolean nullable, SqlValidatorScope scope, Path path, List<String> remainingNames) {
            this.namespace = Preconditions.checkNotNull(namespace);
            this.nullable = nullable;
            this.scope = scope;
            this.path = Preconditions.checkNotNull(path);
            this.remainingNames = remainingNames == null ? ImmutableList.of() : ImmutableList.copyOf(remainingNames);
        }

        public RelDataType rowType() {
            return this.namespace.getValidator().getTypeFactory().createTypeWithNullability(this.namespace.getRowType(), this.nullable);
        }
    }

    public static class ResolvedImpl
    implements Resolved {
        final List<Resolve> resolves = new ArrayList<Resolve>();

        @Override
        public void found(SqlValidatorNamespace namespace, boolean nullable, SqlValidatorScope scope, Path path, List<String> remainingNames) {
            this.resolves.add(new Resolve(namespace, nullable, scope, path, remainingNames));
        }

        @Override
        public int count() {
            return this.resolves.size();
        }

        public Resolve only() {
            return Iterables.getOnlyElement(this.resolves);
        }

        public void clear() {
            this.resolves.clear();
        }
    }

    public static class Step
    extends Path {
        final Path parent;
        final RelDataType rowType;
        public final int i;
        public final String name;
        final StructKind kind;

        Step(Path parent, RelDataType rowType, int i, String name, StructKind kind) {
            this.parent = Preconditions.checkNotNull(parent);
            this.rowType = rowType;
            this.i = i;
            this.name = name;
            this.kind = Preconditions.checkNotNull(kind);
        }

        @Override
        public int stepCount() {
            return 1 + this.parent.stepCount();
        }

        @Override
        protected void build(ImmutableList.Builder<Step> paths) {
            this.parent.build(paths);
            paths.add((Object)this);
        }
    }

    public static class EmptyPath
    extends Path {
    }

    public static abstract class Path {
        public static final EmptyPath EMPTY = new EmptyPath();

        public Step plus(RelDataType rowType, int i, String name, StructKind kind) {
            return new Step(this, rowType, i, name, kind);
        }

        public int stepCount() {
            return 0;
        }

        public List<Step> steps() {
            ImmutableList.Builder<Step> paths = new ImmutableList.Builder<Step>();
            this.build(paths);
            return paths.build();
        }

        List<String> stepNames() {
            return Lists.transform(this.steps(), new Function<Step, String>(){

                @Override
                public String apply(Step input) {
                    return input.name;
                }
            });
        }

        protected void build(ImmutableList.Builder<Step> paths) {
        }
    }

    public static interface Resolved {
        public void found(SqlValidatorNamespace var1, boolean var2, SqlValidatorScope var3, Path var4, List<String> var5);

        public int count();
    }
}

