/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.base.Function;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;

public class SqlParserPos
implements Serializable {
    public static final SqlParserPos ZERO = new SqlParserPos(0, 0);
    private static final long serialVersionUID = 1L;
    private static final Function<SqlNode, SqlParserPos> NODE_TO_POS = new Function<SqlNode, SqlParserPos>(){

        @Override
        public SqlParserPos apply(SqlNode input) {
            return input.getParserPosition();
        }
    };
    private final int lineNumber;
    private final int columnNumber;
    private final int endLineNumber;
    private final int endColumnNumber;

    public SqlParserPos(int lineNumber, int columnNumber) {
        this(lineNumber, columnNumber, lineNumber, columnNumber);
    }

    public SqlParserPos(int startLineNumber, int startColumnNumber, int endLineNumber, int endColumnNumber) {
        this.lineNumber = startLineNumber;
        this.columnNumber = startColumnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
        assert (startLineNumber < endLineNumber || startLineNumber == endLineNumber && startColumnNumber <= endColumnNumber);
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.columnNumber, this.endLineNumber, this.endColumnNumber);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SqlParserPos && this.lineNumber == ((SqlParserPos)o).lineNumber && this.columnNumber == ((SqlParserPos)o).columnNumber && this.endLineNumber == ((SqlParserPos)o).endLineNumber && this.endColumnNumber == ((SqlParserPos)o).endColumnNumber;
    }

    public int getLineNum() {
        return this.lineNumber;
    }

    public int getColumnNum() {
        return this.columnNumber;
    }

    public int getEndLineNum() {
        return this.endLineNumber;
    }

    public int getEndColumnNum() {
        return this.endColumnNumber;
    }

    public String toString() {
        return Static.RESOURCE.parserContext(this.lineNumber, this.columnNumber).str();
    }

    public SqlParserPos plus(SqlParserPos pos) {
        return new SqlParserPos(this.getLineNum(), this.getColumnNum(), pos.getEndLineNum(), pos.getEndColumnNum());
    }

    public SqlParserPos plusAll(SqlNode[] nodes) {
        return this.plusAll(Arrays.asList(nodes));
    }

    public SqlParserPos plusAll(Collection<SqlNode> nodeList) {
        int line = this.getLineNum();
        int column = this.getColumnNum();
        int endLine = this.getEndLineNum();
        int endColumn = this.getEndColumnNum();
        return SqlParserPos.sum(SqlParserPos.toPos(nodeList), line, column, endLine, endColumn);
    }

    public static SqlParserPos sum(SqlNode[] nodes) {
        return SqlParserPos.sum(SqlParserPos.toPos(nodes));
    }

    private static List<SqlParserPos> toPos(final SqlNode[] nodes) {
        return new AbstractList<SqlParserPos>(){

            @Override
            public SqlParserPos get(int index) {
                return nodes[index].getParserPosition();
            }

            @Override
            public int size() {
                return nodes.length;
            }
        };
    }

    private static Iterable<SqlParserPos> toPos(Iterable<SqlNode> nodes) {
        return Iterables.transform(nodes, NODE_TO_POS);
    }

    public static SqlParserPos sum(List<? extends SqlNode> nodes) {
        return SqlParserPos.sum(Lists.transform(nodes, NODE_TO_POS));
    }

    public static SqlParserPos sum(Iterable<SqlParserPos> poses) {
        ArrayList<SqlParserPos> list = poses instanceof List ? (ArrayList<SqlParserPos>)poses : Lists.newArrayList(poses);
        return SqlParserPos.sum_(list);
    }

    private static SqlParserPos sum_(final List<SqlParserPos> positions) {
        switch (positions.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return positions.get(0);
            }
        }
        AbstractList<SqlParserPos> poses = new AbstractList<SqlParserPos>(){

            @Override
            public SqlParserPos get(int index) {
                return (SqlParserPos)positions.get(index + 1);
            }

            @Override
            public int size() {
                return positions.size() - 1;
            }
        };
        SqlParserPos p = positions.get(0);
        return SqlParserPos.sum((Iterable<SqlParserPos>)poses, p.lineNumber, p.columnNumber, p.endLineNumber, p.endColumnNumber);
    }

    private static SqlParserPos sum(Iterable<SqlParserPos> poses, int line, int column, int endLine, int endColumn) {
        for (SqlParserPos pos : poses) {
            if (pos == null || pos.equals(ZERO)) continue;
            int testLine = pos.getLineNum();
            int testColumn = pos.getColumnNum();
            if (testLine < line || testLine == line && testColumn < column) {
                line = testLine;
                column = testColumn;
            }
            testLine = pos.getEndLineNum();
            testColumn = pos.getEndColumnNum();
            if (testLine <= endLine && (testLine != endLine || testColumn <= endColumn)) continue;
            endLine = testLine;
            endColumn = testColumn;
        }
        return new SqlParserPos(line, column, endLine, endColumn);
    }

    public boolean overlaps(SqlParserPos pos) {
        return this.startsBefore(pos) && this.endsAfter(pos) || pos.startsBefore(this) && pos.endsAfter(this);
    }

    private boolean startsBefore(SqlParserPos pos) {
        return this.lineNumber < pos.lineNumber || this.lineNumber == pos.lineNumber && this.columnNumber <= pos.columnNumber;
    }

    private boolean endsAfter(SqlParserPos pos) {
        return this.endLineNumber > pos.endLineNumber || this.endLineNumber == pos.endLineNumber && this.endColumnNumber >= pos.endColumnNumber;
    }

    public boolean startsAt(SqlParserPos pos) {
        return this.lineNumber == pos.lineNumber && this.columnNumber == pos.columnNumber;
    }
}

