/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlFloorFunction;

public class PostgresqlSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new PostgresqlSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.POSTGRESQL).withIdentifierQuoteString("\""));

    public PostgresqlSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    protected boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                SqlFloorFunction.unparseDatetimeFunction(writer, call2, "DATE_TRUNC", false);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }
}

