/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;

public abstract class SqlNode
implements Cloneable {
    public static final SqlNode[] EMPTY_ARRAY = new SqlNode[0];
    protected final SqlParserPos pos;

    SqlNode(SqlParserPos pos) {
        this.pos = Preconditions.checkNotNull(pos);
    }

    @Deprecated
    public Object clone() {
        return this.clone(this.getParserPosition());
    }

    public static <E extends SqlNode> E clone(E e2) {
        return (E)e2.clone(e2.pos);
    }

    public abstract SqlNode clone(SqlParserPos var1);

    public SqlKind getKind() {
        return SqlKind.OTHER;
    }

    public final boolean isA(Set<SqlKind> category) {
        return this.getKind().belongsTo(category);
    }

    @Deprecated
    public static SqlNode[] cloneArray(SqlNode[] nodes) {
        SqlNode[] clones = (SqlNode[])nodes.clone();
        for (int i = 0; i < clones.length; ++i) {
            SqlNode node = clones[i];
            if (node == null) continue;
            clones[i] = SqlNode.clone(node);
        }
        return clones;
    }

    public String toString() {
        return this.toSqlString(null).getSql();
    }

    public SqlString toSqlString(SqlDialect dialect, boolean forceParens) {
        if (dialect == null) {
            dialect = AnsiSqlDialect.DEFAULT;
        }
        SqlPrettyWriter writer = new SqlPrettyWriter(dialect);
        writer.setAlwaysUseParentheses(forceParens);
        writer.setSelectListItemsOnSeparateLines(false);
        writer.setIndentation(0);
        this.unparse(writer, 0, 0);
        String sql = writer.toString();
        return new SqlString(dialect, sql);
    }

    public SqlString toSqlString(SqlDialect dialect) {
        return this.toSqlString(dialect, false);
    }

    public abstract void unparse(SqlWriter var1, int var2, int var3);

    public SqlParserPos getParserPosition() {
        return this.pos;
    }

    public abstract void validate(SqlValidator var1, SqlValidatorScope var2);

    public void findValidOptions(SqlValidator validator, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
    }

    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        this.validate(validator, scope);
        Util.discard(validator.deriveType(scope, this));
    }

    public abstract <R> R accept(SqlVisitor<R> var1);

    public abstract boolean equalsDeep(SqlNode var1, Litmus var2);

    @Deprecated
    public final boolean equalsDeep(SqlNode node, boolean fail) {
        return this.equalsDeep(node, fail ? Litmus.THROW : Litmus.IGNORE);
    }

    public static boolean equalDeep(SqlNode node1, SqlNode node2, Litmus litmus) {
        if (node1 == null) {
            return node2 == null;
        }
        if (node2 == null) {
            return false;
        }
        return node1.equalsDeep(node2, litmus);
    }

    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    public static boolean equalDeep(List<SqlNode> operands0, List<SqlNode> operands1, Litmus litmus) {
        if (operands0.size() != operands1.size()) {
            return litmus.fail(null, new Object[0]);
        }
        for (int i = 0; i < operands0.size(); ++i) {
            if (SqlNode.equalDeep(operands0.get(i), operands1.get(i), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }
}

