/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class ViewTableMacro
implements TableMacro {
    protected final String viewSql;
    protected final CalciteSchema schema;
    private final Boolean modifiable;
    protected final List<String> schemaPath;
    protected final List<String> viewPath;

    public ViewTableMacro(CalciteSchema schema2, String viewSql, List<String> schemaPath, List<String> viewPath, Boolean modifiable) {
        this.viewSql = viewSql;
        this.schema = schema2;
        this.viewPath = viewPath == null ? null : ImmutableList.copyOf(viewPath);
        this.modifiable = modifiable;
        this.schemaPath = schemaPath == null ? null : ImmutableList.copyOf(schemaPath);
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public TranslatableTable apply(List<Object> arguments) {
        List<String> schemaPath1;
        CalciteConnection connection = MaterializedViewTable.MATERIALIZATION_CONNECTION;
        CalcitePrepare.AnalyzeViewResult parsed = Schemas.analyzeView(connection, this.schema, this.schemaPath, this.viewSql, this.viewPath, this.modifiable != null && this.modifiable != false);
        List<String> list = schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
        if ((this.modifiable == null || this.modifiable.booleanValue()) && parsed.modifiable && parsed.table != null) {
            return this.modifiableViewTable(parsed, this.viewSql, schemaPath1, this.viewPath, this.schema);
        }
        return this.viewTable(parsed, this.viewSql, schemaPath1, this.viewPath);
    }

    protected ModifiableViewTable modifiableViewTable(CalcitePrepare.AnalyzeViewResult parsed, String viewSql, List<String> schemaPath, List<String> viewPath, CalciteSchema schema2) {
        JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
        Type elementType = typeFactory.getJavaClass(parsed.rowType);
        return new ModifiableViewTable(elementType, RelDataTypeImpl.proto(parsed.rowType), viewSql, schemaPath, viewPath, parsed.table, Schemas.path(schema2.root(), parsed.tablePath), parsed.constraint, parsed.columnMapping);
    }

    protected ViewTable viewTable(CalcitePrepare.AnalyzeViewResult parsed, String viewSql, List<String> schemaPath, List<String> viewPath) {
        JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
        Type elementType = typeFactory.getJavaClass(parsed.rowType);
        return new ViewTable(elementType, RelDataTypeImpl.proto(parsed.rowType), viewSql, schemaPath, viewPath);
    }
}

