/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.AbstractList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public abstract class Window
extends SingleRel {
    public final ImmutableList<Group> groups;
    public final ImmutableList<RexLiteral> constants;

    public Window(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Group> groups) {
        super(cluster, traitSet, input);
        this.constants = ImmutableList.copyOf(constants);
        assert (rowType != null);
        this.rowType = rowType;
        this.groups = ImmutableList.copyOf(groups);
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        final RelDataType childRowType = this.getInput().getRowType();
        final int childFieldCount = childRowType.getFieldCount();
        final int inputSize = childFieldCount + this.constants.size();
        AbstractList<RelDataType> inputTypes = new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return index < childFieldCount ? childRowType.getFieldList().get(index).getType() : ((RexLiteral)Window.this.constants.get(index - childFieldCount)).getType();
            }

            @Override
            public int size() {
                return inputSize;
            }
        };
        RexChecker checker = new RexChecker((List<RelDataType>)inputTypes, context, litmus);
        int count = 0;
        for (Group group : this.groups) {
            for (RexWinAggCall over2 : group.aggCalls) {
                ++count;
                if (checker.isValid(over2)) continue;
                return litmus.fail(null, new Object[0]);
            }
        }
        if (count == 0) {
            return litmus.fail("empty", new Object[0]);
        }
        return litmus.succeed();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<Group> window : Ord.zip(this.groups)) {
            pw.item("window#" + window.i, ((Group)window.e).toString());
        }
        return pw;
    }

    public static ImmutableIntList getProjectOrdinals(final List<RexNode> exprs) {
        return ImmutableIntList.copyOf((Iterable<? extends Number>)new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return ((RexSlot)exprs.get(index)).getIndex();
            }

            @Override
            public int size() {
                return exprs.size();
            }
        });
    }

    public static RelCollation getCollation(final List<RexFieldCollation> collations) {
        return RelCollations.of((List<RelFieldCollation>)new AbstractList<RelFieldCollation>(){

            @Override
            public RelFieldCollation get(int index) {
                RexFieldCollation collation = (RexFieldCollation)collations.get(index);
                return new RelFieldCollation(((RexLocalRef)collation.left).getIndex(), collation.getDirection(), collation.getNullDirection());
            }

            @Override
            public int size() {
                return collations.size();
            }
        });
    }

    public List<RexLiteral> getConstants() {
        return this.constants;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowsIn = mq.getRowCount(this.getInput());
        int count = this.groups.size();
        for (Group group : this.groups) {
            count += group.aggCalls.size();
        }
        return planner.getCostFactory().makeCost(rowsIn, rowsIn * (double)count, 0.0);
    }

    public static class RexWinAggCall
    extends RexCall {
        public final int ordinal;
        public final boolean distinct;

        public RexWinAggCall(SqlAggFunction aggFun, RelDataType type, List<RexNode> operands, int ordinal, boolean distinct) {
            super(type, aggFun, operands);
            this.ordinal = ordinal;
            this.distinct = distinct;
        }

        @Override
        public RexCall clone(RelDataType type, List<RexNode> operands) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Group {
        public final ImmutableBitSet keys;
        public final boolean isRows;
        public final RexWindowBound lowerBound;
        public final RexWindowBound upperBound;
        public final RelCollation orderKeys;
        private final String digest;
        public final ImmutableList<RexWinAggCall> aggCalls;

        public Group(ImmutableBitSet keys, boolean isRows, RexWindowBound lowerBound, RexWindowBound upperBound, RelCollation orderKeys, List<RexWinAggCall> aggCalls) {
            assert (orderKeys != null) : "precondition: ordinals != null";
            assert (keys != null);
            this.keys = keys;
            this.isRows = isRows;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.orderKeys = orderKeys;
            this.aggCalls = ImmutableList.copyOf(aggCalls);
            this.digest = this.computeString();
        }

        public String toString() {
            return this.digest;
        }

        private String computeString() {
            StringBuilder buf = new StringBuilder();
            buf.append("window(partition ");
            buf.append(this.keys);
            buf.append(" order by ");
            buf.append(this.orderKeys);
            buf.append(this.isRows ? " rows " : " range ");
            if (this.lowerBound != null) {
                if (this.upperBound != null) {
                    buf.append("between ");
                    buf.append(this.lowerBound);
                    buf.append(" and ");
                    buf.append(this.upperBound);
                } else {
                    buf.append(this.lowerBound);
                }
            } else if (this.upperBound != null) {
                buf.append(this.upperBound);
            }
            buf.append(" aggs ");
            buf.append(this.aggCalls);
            buf.append(")");
            return buf.toString();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Group && this.digest.equals(((Group)obj).digest);
        }

        public int hashCode() {
            return this.digest.hashCode();
        }

        public RelCollation collation() {
            return this.orderKeys;
        }

        public boolean isAlwaysNonEmpty() {
            int lowerKey = this.lowerBound.getOrderKey();
            int upperKey = this.upperBound.getOrderKey();
            return lowerKey > -1 && lowerKey <= upperKey;
        }

        public List<AggregateCall> getAggregateCalls(Window windowRel) {
            final List<String> fieldNames = Util.skip(windowRel.getRowType().getFieldNames(), windowRel.getInput().getRowType().getFieldCount());
            return new AbstractList<AggregateCall>(){

                @Override
                public int size() {
                    return Group.this.aggCalls.size();
                }

                @Override
                public AggregateCall get(int index) {
                    RexWinAggCall aggCall = (RexWinAggCall)Group.this.aggCalls.get(index);
                    SqlAggFunction op = (SqlAggFunction)aggCall.getOperator();
                    return AggregateCall.create(op, aggCall.distinct, false, Window.getProjectOrdinals(aggCall.getOperands()), -1, aggCall.getType(), (String)fieldNames.get(aggCall.ordinal));
                }
            };
        }
    }
}

