/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.util.NameMap;
import org.apache.calcite.util.NameMultimap;
import org.apache.calcite.util.NameSet;
import org.apache.flink.calcite.shaded.com.google.common.cache.CacheBuilder;
import org.apache.flink.calcite.shaded.com.google.common.cache.CacheLoader;
import org.apache.flink.calcite.shaded.com.google.common.cache.LoadingCache;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSortedMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSortedSet;

class CachingCalciteSchema
extends CalciteSchema {
    private final Cached<SubSchemaCache> implicitSubSchemaCache = new AbstractCached<SubSchemaCache>(){

        @Override
        public SubSchemaCache build() {
            return new SubSchemaCache(CachingCalciteSchema.this, CachingCalciteSchema.this.schema.getSubSchemaNames());
        }
    };
    private final Cached<NameSet> implicitTableCache = new AbstractCached<NameSet>(){

        @Override
        public NameSet build() {
            return NameSet.immutableCopyOf(CachingCalciteSchema.this.schema.getTableNames());
        }
    };
    private final Cached<NameSet> implicitFunctionCache = new AbstractCached<NameSet>(){

        @Override
        public NameSet build() {
            return NameSet.immutableCopyOf(CachingCalciteSchema.this.schema.getFunctionNames());
        }
    };
    private boolean cache = true;

    CachingCalciteSchema(CalciteSchema parent, Schema schema2, String name) {
        this(parent, schema2, name, null, null, null, null, null, null, null);
    }

    private CachingCalciteSchema(CalciteSchema parent, Schema schema2, String name, NameMap<CalciteSchema> subSchemaMap, NameMap<CalciteSchema.TableEntry> tableMap, NameMap<CalciteSchema.LatticeEntry> latticeMap, NameMultimap<CalciteSchema.FunctionEntry> functionMap, NameSet functionNames, NameMap<CalciteSchema.FunctionEntry> nullaryFunctionMap, List<? extends List<String>> path) {
        super(parent, schema2, name, subSchemaMap, tableMap, latticeMap, functionMap, functionNames, nullaryFunctionMap, path);
    }

    @Override
    public void setCache(boolean cache) {
        if (cache == this.cache) {
            return;
        }
        long now = System.currentTimeMillis();
        this.implicitSubSchemaCache.enable(now, cache);
        this.implicitTableCache.enable(now, cache);
        this.implicitFunctionCache.enable(now, cache);
        this.cache = cache;
    }

    @Override
    protected boolean isCacheEnabled() {
        return this.cache;
    }

    @Override
    protected CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        Iterator<String> iterator = subSchemaCache.names.range(schemaName, caseSensitive).iterator();
        if (iterator.hasNext()) {
            String schemaName2 = iterator.next();
            return subSchemaCache.cache.getUnchecked(schemaName2);
        }
        return null;
    }

    @Override
    public CalciteSchema add(String name, Schema schema2) {
        CachingCalciteSchema calciteSchema = new CachingCalciteSchema(this, schema2, name);
        this.subSchemaMap.put(name, calciteSchema);
        return calciteSchema;
    }

    @Override
    protected CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet implicitTableNames = this.implicitTableCache.get(now);
        for (String tableName2 : implicitTableNames.range(tableName, caseSensitive)) {
            Table table = this.schema.getTable(tableName2);
            if (table == null) continue;
            return this.tableEntry(tableName2, table);
        }
        return null;
    }

    @Override
    protected void addImplicitSubSchemaToBuilder(ImmutableSortedMap.Builder<String, CalciteSchema> builder) {
        ImmutableMap explicitSubSchemas = builder.build();
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        for (String name : subSchemaCache.names.iterable()) {
            if (explicitSubSchemas.containsKey(name)) continue;
            builder.put((Object)name, (Object)subSchemaCache.cache.getUnchecked(name));
        }
    }

    @Override
    protected void addImplicitTableToBuilder(ImmutableSortedSet.Builder<String> builder) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitTableCache.get(now);
        builder.addAll((Iterable)set.iterable());
    }

    @Override
    protected void addImplicitFunctionsToBuilder(ImmutableList.Builder<Function> builder, String name, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String name2 : set.range(name, caseSensitive)) {
            Collection<Function> functions = this.schema.getFunctions(name2);
            if (functions == null) continue;
            builder.addAll(functions);
        }
    }

    @Override
    protected void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        builder.addAll((Iterable)set.iterable());
    }

    @Override
    protected void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> builder) {
        ImmutableMap explicitTables = builder.build();
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String s : set.iterable()) {
            if (explicitTables.containsKey(s)) continue;
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                builder.put((Object)s, (Object)table);
            }
        }
    }

    @Override
    protected CalciteSchema.TableEntry getImplicitTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        long now = System.currentTimeMillis();
        NameSet set = this.implicitFunctionCache.get(now);
        for (String s : set.range(tableName, caseSensitive)) {
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        }
        return null;
    }

    @Override
    protected CalciteSchema snapshot(CalciteSchema parent, SchemaVersion version) {
        CachingCalciteSchema snapshot = new CachingCalciteSchema(parent, this.schema.snapshot(version), this.name, null, this.tableMap, this.latticeMap, this.functionMap, this.functionNames, this.nullaryFunctionMap, this.getPath());
        for (CalciteSchema subSchema : this.subSchemaMap.map().values()) {
            CalciteSchema subSchemaSnapshot = subSchema.snapshot(snapshot, version);
            snapshot.subSchemaMap.put(subSchema.name, subSchemaSnapshot);
        }
        return snapshot;
    }

    @Override
    public boolean removeTable(String name) {
        if (this.cache) {
            long now = System.nanoTime();
            this.implicitTableCache.enable(now, false);
            this.implicitTableCache.enable(now, true);
        }
        return super.removeTable(name);
    }

    @Override
    public boolean removeFunction(String name) {
        if (this.cache) {
            long now = System.nanoTime();
            this.implicitFunctionCache.enable(now, false);
            this.implicitFunctionCache.enable(now, true);
        }
        return super.removeFunction(name);
    }

    private static class SubSchemaCache {
        final NameSet names;
        final LoadingCache<String, CalciteSchema> cache;

        private SubSchemaCache(final CalciteSchema calciteSchema, Set<String> names) {
            this.names = NameSet.immutableCopyOf(names);
            this.cache = CacheBuilder.newBuilder().build(new CacheLoader<String, CalciteSchema>(){

                @Override
                public CalciteSchema load(String schemaName) {
                    Schema subSchema = calciteSchema.schema.getSubSchema(schemaName);
                    if (subSchema == null) {
                        throw new RuntimeException("sub-schema " + schemaName + " not found");
                    }
                    return new CachingCalciteSchema(calciteSchema, subSchema, schemaName);
                }
            });
        }
    }

    private abstract class AbstractCached<T>
    implements Cached<T> {
        T t;
        boolean built = false;

        private AbstractCached() {
        }

        @Override
        public T get(long now) {
            if (!CachingCalciteSchema.this.cache) {
                return this.build();
            }
            if (!this.built) {
                this.t = this.build();
            }
            this.built = true;
            return this.t;
        }

        @Override
        public void enable(long now, boolean enabled) {
            if (!enabled) {
                this.t = null;
            }
            this.built = false;
        }
    }

    private static interface Cached<T> {
        public T get(long var1);

        public T build();

        public void enable(long var1, boolean var3);
    }
}

