/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.IOException;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.NoSuchConnectionException;
import org.apache.calcite.avatica.remote.AvaticaRuntimeException;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.Service;

public abstract class AbstractHandler<T>
implements Handler<T> {
    private static final String NULL_EXCEPTION_MESSAGE = "(null exception message)";
    protected final Service service;
    private Service.RpcMetadataResponse metadata = null;

    public AbstractHandler(Service service) {
        this.service = service;
    }

    abstract Service.Request decode(T var1) throws IOException;

    abstract T encode(Service.Response var1) throws IOException;

    Service.ErrorResponse unwrapException(Exception e2) {
        int errorCode = -1;
        String sqlState = "00000";
        AvaticaSeverity severity = AvaticaSeverity.UNKNOWN;
        String errorMsg = null;
        if (e2 instanceof AvaticaRuntimeException) {
            AvaticaRuntimeException rte = (AvaticaRuntimeException)e2;
            errorCode = rte.getErrorCode();
            sqlState = rte.getSqlState();
            severity = rte.getSeverity();
            errorMsg = rte.getErrorMessage();
        } else if (e2 instanceof NoSuchConnectionException) {
            errorCode = 1;
            severity = AvaticaSeverity.ERROR;
            errorMsg = e2.getMessage();
        } else {
            errorMsg = this.getCausalChain(e2);
        }
        return new Service.ErrorResponse(e2, errorMsg, errorCode, sqlState, severity, this.metadata);
    }

    @Override
    public Handler.HandlerResponse<T> apply(T serializedRequest) {
        try {
            Service.Request request = this.decode(serializedRequest);
            Service.Response response = request.accept(this.service);
            return new Handler.HandlerResponse<T>(this.encode(response), 200);
        }
        catch (Exception e2) {
            return this.convertToErrorResponse(e2);
        }
    }

    public Handler.HandlerResponse<T> convertToErrorResponse(Exception e2) {
        return this.createErrorResponse(e2, 500);
    }

    public Handler.HandlerResponse<T> unauthenticatedErrorResponse(Exception e2) {
        return this.createErrorResponse(e2, 401);
    }

    public Handler.HandlerResponse<T> unauthorizedErrorResponse(Exception e2) {
        return this.createErrorResponse(e2, 403);
    }

    private Handler.HandlerResponse<T> createErrorResponse(Exception e2, int statusCode) {
        Service.ErrorResponse errorResp = this.unwrapException(e2);
        try {
            return new Handler.HandlerResponse<T>(this.encode(errorResp), statusCode);
        }
        catch (IOException e1) {
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new RuntimeException(e2);
        }
    }

    private String getCausalChain(Exception e2) {
        StringBuilder sb = new StringBuilder(16);
        for (Throwable curr = e2; null != curr; curr = curr.getCause()) {
            if (sb.length() > 0) {
                sb.append(" -> ");
            }
            String message = curr.getMessage();
            sb.append(curr.getClass().getSimpleName()).append(": ");
            sb.append(null == message ? NULL_EXCEPTION_MESSAGE : message);
        }
        if (sb.length() == 0) {
            return "Unknown error message";
        }
        return sb.toString();
    }

    @Override
    public void setRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.metadata = metadata;
    }
}

