/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest.entities;

import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaString {
    private String schemaType = "AVRO";
    private String schemaString;
    private List<SchemaReference> references = Collections.emptyList();
    private Integer maxId;

    public SchemaString() {
    }

    public SchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    public static SchemaString fromJson(String json) throws IOException {
        return JacksonMapper.INSTANCE.readValue(json, SchemaString.class);
    }

    @ApiModelProperty(value="Schema type")
    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @ApiModelProperty(value="Schema string identified by the ID")
    @JsonProperty(value="schema")
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty(value="schema")
    public void setSchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    @ApiModelProperty(value="Schema references")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @ApiModelProperty(value="Maximum ID")
    @JsonProperty(value="maxId")
    public Integer getMaxId() {
        return this.maxId;
    }

    @JsonProperty(value="maxId")
    public void setMaxId(Integer maxId) {
        this.maxId = maxId;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaString that = (SchemaString)o;
        return Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.schemaString, that.schemaString) && Objects.equals(this.references, that.references) && Objects.equals(this.maxId, that.maxId);
    }

    public int hashCode() {
        return Objects.hash(this.schemaType, this.schemaString, this.references, this.maxId);
    }
}

