/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils;

import java.util.StringTokenizer;

public final class Java {
    private static final Version VERSION = Java.parseVersion(System.getProperty("java.specification.version"));
    public static final boolean IS_JAVA9_COMPATIBLE = VERSION.isJava9Compatible();
    public static final boolean IS_JAVA11_COMPATIBLE = VERSION.isJava11Compatible();

    private Java() {
    }

    static Version parseVersion(String versionString) {
        StringTokenizer st = new StringTokenizer(versionString, ".");
        int majorVersion = Integer.parseInt(st.nextToken());
        int minorVersion = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
        return new Version(majorVersion, minorVersion);
    }

    public static boolean isIbmJdk() {
        return System.getProperty("java.vendor").contains("IBM");
    }

    static class Version {
        public final int majorVersion;
        public final int minorVersion;

        private Version(int majorVersion, int minorVersion) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        public String toString() {
            return "Version(majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ")";
        }

        boolean isJava9Compatible() {
            return this.majorVersion >= 9;
        }

        boolean isJava11Compatible() {
            return this.majorVersion >= 11;
        }
    }
}

