/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class ApiVersionsResponse
extends AbstractResponse {
    public static final ApiVersionsResponse DEFAULT_API_VERSIONS_RESPONSE = ApiVersionsResponse.createApiVersionsResponse(0, (byte)2);
    public final ApiVersionsResponseData data;

    public ApiVersionsResponse(ApiVersionsResponseData data) {
        this.data = data;
    }

    public ApiVersionsResponse(Struct struct) {
        this(new ApiVersionsResponseData(struct, (short)(ApiVersionsResponseData.SCHEMAS.length - 1)));
    }

    public ApiVersionsResponse(Struct struct, short version) {
        this(new ApiVersionsResponseData(struct, version));
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public ApiVersionsResponseData.ApiVersionsResponseKey apiVersion(short apiKey) {
        return this.data.apiKeys().find(apiKey);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public static ApiVersionsResponse parse(ByteBuffer buffer, short version) {
        int prev = buffer.position();
        try {
            return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), version));
        }
        catch (RuntimeException e) {
            buffer.position(prev);
            if (version != 0) {
                return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), 0));
            }
            throw e;
        }
    }

    public static ApiVersionsResponse fromStruct(Struct struct, short version) {
        try {
            return new ApiVersionsResponse(struct, version);
        }
        catch (SchemaException e) {
            if (version != 0) {
                return new ApiVersionsResponse(struct, 0);
            }
            throw e;
        }
    }

    public static ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, byte maxMagic) {
        if (maxMagic == 2 && throttleTimeMs == 0) {
            return DEFAULT_API_VERSIONS_RESPONSE;
        }
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, maxMagic);
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, byte minMagic) {
        ApiVersionsResponseData.ApiVersionsResponseKeyCollection apiKeys = new ApiVersionsResponseData.ApiVersionsResponseKeyCollection();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey.minRequiredInterBrokerMagic > minMagic) continue;
            apiKeys.add(new ApiVersionsResponseData.ApiVersionsResponseKey().setApiKey(apiKey.id).setMinVersion(apiKey.oldestVersion()).setMaxVersion(apiKey.latestVersion()));
        }
        ApiVersionsResponseData data = new ApiVersionsResponseData();
        data.setThrottleTimeMs(throttleTimeMs);
        data.setErrorCode(Errors.NONE.code());
        data.setApiKeys(apiKeys);
        return new ApiVersionsResponse(data);
    }
}

