/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.memory.MemoryPool;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.Authenticator;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.ChannelBuilders;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.KafkaChannel;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.ListenerName;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.network.PlaintextTransportLayer;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaintextChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(PlaintextChannelBuilder.class);
    private final ListenerName listenerName;
    private Map<String, ?> configs;

    public PlaintextChannelBuilder(ListenerName listenerName) {
        this.listenerName = listenerName;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        this.configs = configs;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry) throws KafkaException {
        try {
            PlaintextTransportLayer transportLayer = this.buildTransportLayer(key);
            Supplier<Authenticator> authenticatorCreator = () -> new PlaintextAuthenticator(this.configs, transportLayer, this.listenerName);
            return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE, metadataRegistry);
        }
        catch (Exception e) {
            log.warn("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    protected PlaintextTransportLayer buildTransportLayer(SelectionKey key) throws IOException {
        return new PlaintextTransportLayer(key);
    }

    @Override
    public void close() {
    }

    private static class PlaintextAuthenticator
    implements Authenticator {
        private final PlaintextTransportLayer transportLayer;
        private final KafkaPrincipalBuilder principalBuilder;
        private final ListenerName listenerName;

        private PlaintextAuthenticator(Map<String, ?> configs, PlaintextTransportLayer transportLayer, ListenerName listenerName) {
            this.transportLayer = transportLayer;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, transportLayer, this, null, null);
            this.listenerName = listenerName;
        }

        @Override
        public void authenticate() {
        }

        @Override
        public KafkaPrincipal principal() {
            InetAddress clientAddress = this.transportLayer.socketChannel().socket().getInetAddress();
            if (this.listenerName == null) {
                throw new IllegalStateException("Unexpected call to principal() when listenerName is null");
            }
            return this.principalBuilder.build(new PlaintextAuthenticationContext(clientAddress, this.listenerName.value()));
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public void close() {
            if (this.principalBuilder instanceof Closeable) {
                Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
            }
        }
    }
}

