/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteUtils;

public class LeaderAndIsrRequestData
implements ApiMessage {
    private int controllerId;
    private int controllerEpoch;
    private long brokerEpoch;
    private List<LeaderAndIsrPartitionState> ungroupedPartitionStates;
    private List<LeaderAndIsrTopicState> topicStates;
    private List<LeaderAndIsrLiveLeader> liveLeaders;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_0), "The state of each partition, in a v0 or v1 message."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_1), "The state of each partition, in a v0 or v1 message."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new ArrayOf(LeaderAndIsrTopicState.SCHEMA_2), "Each topic."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_3 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new ArrayOf(LeaderAndIsrTopicState.SCHEMA_3), "Each topic."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_4 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new CompactArrayOf(LeaderAndIsrTopicState.SCHEMA_4), "Each topic."), new Field("live_leaders", new CompactArrayOf(LeaderAndIsrLiveLeader.SCHEMA_4), "The current live leaders."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};

    public LeaderAndIsrRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaderAndIsrRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public LeaderAndIsrRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>();
        this.topicStates = new ArrayList<LeaderAndIsrTopicState>();
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>();
    }

    @Override
    public short apiKey() {
        return 4;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<LeaderAndIsrPartitionState> newCollection;
        int arrayLength;
        this.controllerId = _readable.readInt();
        this.controllerEpoch = _readable.readInt();
        this.brokerEpoch = _version >= 2 ? _readable.readLong() : -1L;
        if (_version <= 1) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ungroupedPartitionStates was serialized as null");
            }
            newCollection = new ArrayList<LeaderAndIsrPartitionState>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
            }
            this.ungroupedPartitionStates = newCollection;
        } else {
            this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>();
        }
        if (_version >= 2) {
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            }
        } else {
            this.topicStates = new ArrayList<LeaderAndIsrTopicState>();
        }
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveLeaders was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrLiveLeader(_readable, _version)));
            }
            this.liveLeaders = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveLeaders was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((LeaderAndIsrPartitionState)((Object)new LeaderAndIsrLiveLeader(_readable, _version)));
            }
            this.liveLeaders = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.controllerId);
        _writable.writeInt(this.controllerEpoch);
        if (_version >= 2) {
            _writable.writeLong(this.brokerEpoch);
        }
        if (_version <= 1) {
            _writable.writeInt(this.ungroupedPartitionStates.size());
            for (LeaderAndIsrPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                ungroupedPartitionStatesElement.write(_writable, _cache, _version);
            }
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 2) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.topicStates.size() + 1);
                for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.topicStates.size());
                for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.liveLeaders.size() + 1);
            for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
                liveLeadersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.liveLeaders.size());
            for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
                liveLeadersElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        Object[] _nestedObjects;
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.controllerId = struct.getInt("controller_id");
        this.controllerEpoch = struct.getInt("controller_epoch");
        this.brokerEpoch = _version >= 2 ? struct.getLong("broker_epoch") : -1L;
        if (_version <= 1) {
            _nestedObjects = struct.getArray("ungrouped_partition_states");
            this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.ungroupedPartitionStates.add(new LeaderAndIsrPartitionState((Struct)nestedObject, _version));
            }
        } else {
            this.ungroupedPartitionStates = new ArrayList<LeaderAndIsrPartitionState>();
        }
        if (_version >= 2) {
            _nestedObjects = struct.getArray("topic_states");
            this.topicStates = new ArrayList<LeaderAndIsrTopicState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topicStates.add(new LeaderAndIsrTopicState((Struct)nestedObject, _version));
            }
        } else {
            this.topicStates = new ArrayList<LeaderAndIsrTopicState>();
        }
        _nestedObjects = struct.getArray("live_leaders");
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.liveLeaders.add(new LeaderAndIsrLiveLeader((Struct)nestedObject, _version));
        }
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        int i;
        Struct[] _nestedObjects;
        TreeMap _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("controller_id", (Object)this.controllerId);
        struct.set("controller_epoch", (Object)this.controllerEpoch);
        if (_version >= 2) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        if (_version <= 1) {
            _nestedObjects = new Struct[this.ungroupedPartitionStates.size()];
            i = 0;
            for (LeaderAndIsrPartitionState leaderAndIsrPartitionState : this.ungroupedPartitionStates) {
                _nestedObjects[i++] = leaderAndIsrPartitionState.toStruct(_version);
            }
            struct.set("ungrouped_partition_states", (Object)_nestedObjects);
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 2) {
            _nestedObjects = new Struct[this.topicStates.size()];
            i = 0;
            for (LeaderAndIsrTopicState leaderAndIsrTopicState : this.topicStates) {
                _nestedObjects[i++] = leaderAndIsrTopicState.toStruct(_version);
            }
            struct.set("topic_states", (Object)_nestedObjects);
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        _nestedObjects = new Struct[this.liveLeaders.size()];
        i = 0;
        for (LeaderAndIsrLiveLeader leaderAndIsrLiveLeader : this.liveLeaders) {
            _nestedObjects[i++] = leaderAndIsrLiveLeader.toStruct(_version);
        }
        struct.set("live_leaders", (Object)_nestedObjects);
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _arraySize;
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 4;
        if (_version >= 2) {
            _size += 8;
        }
        if (_version <= 1) {
            _arraySize = 0;
            _arraySize += 4;
            for (LeaderAndIsrPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                _arraySize += ungroupedPartitionStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version >= 2) {
            _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topicStates.size() + 1)) : (_arraySize += 4);
            for (LeaderAndIsrTopicState topicStatesElement : this.topicStates) {
                _arraySize += topicStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        _arraySize = 0;
        _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.liveLeaders.size() + 1)) : (_arraySize += 4);
        for (LeaderAndIsrLiveLeader liveLeadersElement : this.liveLeaders) {
            _arraySize += liveLeadersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaderAndIsrRequestData)) {
            return false;
        }
        LeaderAndIsrRequestData other = (LeaderAndIsrRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.ungroupedPartitionStates == null ? other.ungroupedPartitionStates != null : !this.ungroupedPartitionStates.equals(other.ungroupedPartitionStates)) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        return !(this.liveLeaders == null ? other.liveLeaders != null : !this.liveLeaders.equals(other.liveLeaders));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.ungroupedPartitionStates == null ? 0 : this.ungroupedPartitionStates.hashCode());
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        hashCode = 31 * hashCode + (this.liveLeaders == null ? 0 : this.liveLeaders.hashCode());
        return hashCode;
    }

    public String toString() {
        return "LeaderAndIsrRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", ungroupedPartitionStates=" + MessageUtil.deepToString(this.ungroupedPartitionStates.iterator()) + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ", liveLeaders=" + MessageUtil.deepToString(this.liveLeaders.iterator()) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<LeaderAndIsrPartitionState> ungroupedPartitionStates() {
        return this.ungroupedPartitionStates;
    }

    public List<LeaderAndIsrTopicState> topicStates() {
        return this.topicStates;
    }

    public List<LeaderAndIsrLiveLeader> liveLeaders() {
        return this.liveLeaders;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaderAndIsrRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public LeaderAndIsrRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setUngroupedPartitionStates(List<LeaderAndIsrPartitionState> v) {
        this.ungroupedPartitionStates = v;
        return this;
    }

    public LeaderAndIsrRequestData setTopicStates(List<LeaderAndIsrTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public LeaderAndIsrRequestData setLiveLeaders(List<LeaderAndIsrLiveLeader> v) {
        this.liveLeaders = v;
        return this;
    }

    public static class LeaderAndIsrPartitionState
    implements Message {
        private String topicName;
        private int partitionIndex;
        private int controllerEpoch;
        private int leader;
        private int leaderEpoch;
        private List<Integer> isr;
        private int zkVersion;
        private List<Integer> replicas;
        private List<Integer> addingReplicas;
        private List<Integer> removingReplicas;
        private boolean isNew;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name.  This is only present in v0 or v1."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.STRING, "The topic name.  This is only present in v0 or v1."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_3 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("adding_replicas", new ArrayOf(Type.INT32), "The replica IDs that we are adding this partition to, or null if no replicas are being added."), new Field("removing_replicas", new ArrayOf(Type.INT32), "The replica IDs that we are removing this partition from, or null if no replicas are being removed."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema SCHEMA_4 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new CompactArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new CompactArrayOf(Type.INT32), "The replica IDs."), new Field("adding_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are adding this partition to, or null if no replicas are being added."), new Field("removing_replicas", new CompactArrayOf(Type.INT32), "The replica IDs that we are removing this partition from, or null if no replicas are being removed."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};

        public LeaderAndIsrPartitionState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrPartitionState(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public LeaderAndIsrPartitionState() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leader = 0;
            this.leaderEpoch = 0;
            this.isr = new ArrayList<Integer>();
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>();
            this.addingReplicas = new ArrayList<Integer>();
            this.removingReplicas = new ArrayList<Integer>();
            this.isNew = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            if (_version <= 1) {
                short length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topicName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topicName had invalid length " + length);
                }
                this.topicName = _readable.readString(length);
            } else {
                this.topicName = "";
            }
            this.partitionIndex = _readable.readInt();
            this.controllerEpoch = _readable.readInt();
            this.leader = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isr was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isr = newCollection;
            this.zkVersion = _readable.readInt();
            arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicas was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicas = newCollection;
            if (_version >= 3) {
                arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field addingReplicas was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.addingReplicas = newCollection;
            } else {
                this.addingReplicas = new ArrayList<Integer>();
            }
            if (_version >= 3) {
                arrayLength = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field removingReplicas was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.removingReplicas = newCollection;
            } else {
                this.removingReplicas = new ArrayList<Integer>();
            }
            this.isNew = _version >= 1 ? _readable.readByte() != 0 : false;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version <= 1) {
                _stringBytes = _cache.getSerializedValue(this.topicName);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.controllerEpoch);
            _writable.writeInt(this.leader);
            _writable.writeInt(this.leaderEpoch);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.isr.size() + 1);
            } else {
                _writable.writeInt(this.isr.size());
            }
            _stringBytes = this.isr.iterator();
            while (_stringBytes.hasNext()) {
                Integer isrElement = (Integer)_stringBytes.next();
                _writable.writeInt(isrElement);
            }
            _writable.writeInt(this.zkVersion);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.replicas.size() + 1);
            } else {
                _writable.writeInt(this.replicas.size());
            }
            for (Integer replicasElement : this.replicas) {
                _writable.writeInt(replicasElement);
            }
            if (_version >= 3) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.addingReplicas.size());
                }
                for (Integer addingReplicasElement : this.addingReplicas) {
                    _writable.writeInt(addingReplicasElement);
                }
            }
            if (_version >= 3) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.removingReplicas.size());
                }
                for (Integer removingReplicasElement : this.removingReplicas) {
                    _writable.writeInt(removingReplicasElement);
                }
            }
            if (_version >= 1) {
                _writable.writeByte(this.isNew ? (byte)1 : 0);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topicName = _version <= 1 ? struct.getString("topic_name") : "";
            this.partitionIndex = struct.getInt("partition_index");
            this.controllerEpoch = struct.getInt("controller_epoch");
            this.leader = struct.getInt("leader");
            this.leaderEpoch = struct.getInt("leader_epoch");
            Object[] _nestedObjects = struct.getArray("isr");
            this.isr = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.isr.add((Integer)nestedObject);
            }
            this.zkVersion = struct.getInt("zk_version");
            _nestedObjects = struct.getArray("replicas");
            this.replicas = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.replicas.add((Integer)nestedObject);
            }
            if (_version >= 3) {
                _nestedObjects = struct.getArray("adding_replicas");
                this.addingReplicas = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.addingReplicas.add((Integer)nestedObject);
                }
            } else {
                this.addingReplicas = new ArrayList<Integer>();
            }
            if (_version >= 3) {
                _nestedObjects = struct.getArray("removing_replicas");
                this.removingReplicas = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.removingReplicas.add((Integer)nestedObject);
                }
            } else {
                this.removingReplicas = new ArrayList<Integer>();
            }
            this.isNew = _version >= 1 ? struct.getBoolean("is_new") : false;
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            TreeMap _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            if (_version <= 1) {
                struct.set("topic_name", (Object)this.topicName);
            }
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("controller_epoch", (Object)this.controllerEpoch);
            struct.set("leader", (Object)this.leader);
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            Integer[] _nestedObjects = new Integer[this.isr.size()];
            int i = 0;
            for (Integer element : this.isr) {
                _nestedObjects[i++] = element;
            }
            struct.set("isr", (Object)_nestedObjects);
            struct.set("zk_version", (Object)this.zkVersion);
            _nestedObjects = new Integer[this.replicas.size()];
            i = 0;
            for (Integer element : this.replicas) {
                _nestedObjects[i++] = element;
            }
            struct.set("replicas", (Object)_nestedObjects);
            if (_version >= 3) {
                _nestedObjects = new Integer[this.addingReplicas.size()];
                i = 0;
                for (Integer element : this.addingReplicas) {
                    _nestedObjects[i++] = element;
                }
                struct.set("adding_replicas", (Object)_nestedObjects);
            }
            if (_version >= 3) {
                _nestedObjects = new Integer[this.removingReplicas.size()];
                i = 0;
                for (Integer element : this.removingReplicas) {
                    _nestedObjects[i++] = element;
                }
                struct.set("removing_replicas", (Object)_nestedObjects);
            }
            if (_version >= 1) {
                struct.set("is_new", (Object)this.isNew);
            }
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version <= 1) {
                byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topicName, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            _size += 4;
            _size += 4;
            _size += 4;
            _size += 4;
            int _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.isr.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.isr.size() * 4);
            _size += 4;
            _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.replicas.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.replicas.size() * 4);
            if (_version >= 3) {
                _arraySize = 0;
                _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.addingReplicas.size() + 1)) : (_arraySize += 4);
                _size += (_arraySize += this.addingReplicas.size() * 4);
            }
            if (_version >= 3) {
                _arraySize = 0;
                _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.removingReplicas.size() + 1)) : (_arraySize += 4);
                _size += (_arraySize += this.removingReplicas.size() * 4);
            }
            if (_version >= 1) {
                ++_size;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrPartitionState)) {
                return false;
            }
            LeaderAndIsrPartitionState other = (LeaderAndIsrPartitionState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leader != other.leader) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
                return false;
            }
            if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
                return false;
            }
            return this.isNew == other.isNew;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leader;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
            hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
            hashCode = 31 * hashCode + (this.isNew ? 1231 : 1237);
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrPartitionState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", addingReplicas=" + MessageUtil.deepToString(this.addingReplicas.iterator()) + ", removingReplicas=" + MessageUtil.deepToString(this.removingReplicas.iterator()) + ", isNew=" + (this.isNew ? "true" : "false") + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> addingReplicas() {
            return this.addingReplicas;
        }

        public List<Integer> removingReplicas() {
            return this.removingReplicas;
        }

        public boolean isNew() {
            return this.isNew;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrPartitionState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public LeaderAndIsrPartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLeader(int v) {
            this.leader = v;
            return this;
        }

        public LeaderAndIsrPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public LeaderAndIsrPartitionState setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public LeaderAndIsrPartitionState setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public LeaderAndIsrPartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setAddingReplicas(List<Integer> v) {
            this.addingReplicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setRemovingReplicas(List<Integer> v) {
            this.removingReplicas = v;
            return this;
        }

        public LeaderAndIsrPartitionState setIsNew(boolean v) {
            this.isNew = v;
            return this;
        }
    }

    public static class LeaderAndIsrLiveLeader
    implements Message {
        private int brokerId;
        private String hostName;
        private int port;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;

        public LeaderAndIsrLiveLeader(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrLiveLeader(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public LeaderAndIsrLiveLeader() {
            this.brokerId = 0;
            this.hostName = "";
            this.port = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrLiveLeader");
            }
            this.brokerId = _readable.readInt();
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field hostName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field hostName had invalid length " + length);
            }
            this.hostName = _readable.readString(length);
            this.port = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrLiveLeader");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue(this.hostName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrLiveLeader");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.brokerId = struct.getInt("broker_id");
            this.hostName = struct.getString("host_name");
            this.port = struct.getInt("port");
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrLiveLeader");
            }
            TreeMap _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("broker_id", (Object)this.brokerId);
            struct.set("host_name", (Object)this.hostName);
            struct.set("port", (Object)this.port);
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrLiveLeader");
            }
            _size += 4;
            byte[] _stringBytes = this.hostName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'hostName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.hostName, _stringBytes);
            _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrLiveLeader)) {
                return false;
            }
            LeaderAndIsrLiveLeader other = (LeaderAndIsrLiveLeader)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
                return false;
            }
            return this.port == other.port;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.hostName == null ? 0 : this.hostName.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrLiveLeader(brokerId=" + this.brokerId + ", hostName=" + (this.hostName == null ? "null" : "'" + this.hostName.toString() + "'") + ", port=" + this.port + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String hostName() {
            return this.hostName;
        }

        public int port() {
            return this.port;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrLiveLeader setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setHostName(String v) {
            this.hostName = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setPort(int v) {
            this.port = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The leader's broker ID."), new Field("host_name", Type.STRING, "The leader's hostname."), new Field("port", Type.INT32, "The leader's port."))));
            SCHEMA_4 = new Schema(new Field("broker_id", Type.INT32, "The leader's broker ID."), new Field("host_name", Type.COMPACT_STRING, "The leader's hostname."), new Field("port", Type.INT32, "The leader's port."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class LeaderAndIsrTopicState
    implements Message {
        private String topicName;
        private List<LeaderAndIsrPartitionState> partitionStates;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_2 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_2), "The state of each partition"));
        public static final Schema SCHEMA_3 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(LeaderAndIsrPartitionState.SCHEMA_3), "The state of each partition"));
        public static final Schema SCHEMA_4 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partition_states", new CompactArrayOf(LeaderAndIsrPartitionState.SCHEMA_4), "The state of each partition"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2, SCHEMA_3, SCHEMA_4};

        public LeaderAndIsrTopicState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrTopicState(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public LeaderAndIsrTopicState() {
            this.topicName = "";
            this.partitionStates = new ArrayList<LeaderAndIsrPartitionState>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<LeaderAndIsrPartitionState> newCollection;
            int arrayLength;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrTopicState");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                newCollection = new ArrayList<LeaderAndIsrPartitionState>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new LeaderAndIsrPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrTopicState");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.partitionStates.size() + 1);
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    LeaderAndIsrPartitionState partitionStatesElement = (LeaderAndIsrPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitionStates.size());
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    LeaderAndIsrPartitionState partitionStatesElement = (LeaderAndIsrPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrTopicState");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topicName = struct.getString("topic_name");
            Object[] _nestedObjects = struct.getArray("partition_states");
            this.partitionStates = new ArrayList<LeaderAndIsrPartitionState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionStates.add(new LeaderAndIsrPartitionState((Struct)nestedObject, _version));
            }
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrTopicState");
            }
            TreeMap _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_name", (Object)this.topicName);
            Struct[] _nestedObjects = new Struct[this.partitionStates.size()];
            int i = 0;
            for (LeaderAndIsrPartitionState element : this.partitionStates) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partition_states", (Object)_nestedObjects);
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrTopicState");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.partitionStates.size() + 1)) : (_arraySize += 4);
            for (LeaderAndIsrPartitionState partitionStatesElement : this.partitionStates) {
                _arraySize += partitionStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrTopicState)) {
                return false;
            }
            LeaderAndIsrTopicState other = (LeaderAndIsrTopicState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return !(this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrTopicState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<LeaderAndIsrPartitionState> partitionStates() {
            return this.partitionStates;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrTopicState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrTopicState setPartitionStates(List<LeaderAndIsrPartitionState> v) {
            this.partitionStates = v;
            return this;
        }
    }
}

