/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.Bytes;

public class JoinGroupResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private int generationId;
    private String protocolType;
    private String protocolName;
    private String leader;
    private String memberId;
    private List<JoinGroupResponseMember> members;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public JoinGroupResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public JoinGroupResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public JoinGroupResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.generationId = -1;
        this.protocolType = null;
        this.protocolName = "";
        this.leader = "";
        this.memberId = "";
        this.members = new ArrayList<JoinGroupResponseMember>();
    }

    @Override
    public short apiKey() {
        return 11;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<JoinGroupResponseMember> newCollection;
        int arrayLength;
        int length;
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        this.errorCode = _readable.readShort();
        this.generationId = _readable.readInt();
        if (_version >= 7) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.protocolType = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field protocolType had invalid length " + length);
                }
                this.protocolType = _readable.readString(length);
            }
        } else {
            this.protocolType = null;
        }
        length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            if (_version < 7) throw new RuntimeException("non-nullable field protocolName was serialized as null");
            this.protocolName = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field protocolName had invalid length " + length);
            }
            this.protocolName = _readable.readString(length);
        }
        length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field leader was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field leader had invalid length " + length);
        }
        this.leader = _readable.readString(length);
        length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field members was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new JoinGroupResponseMember(_readable, _version));
            }
            this.members = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field members was serialized as null");
            }
            newCollection = new ArrayList<JoinGroupResponseMember>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new JoinGroupResponseMember(_readable, _version));
            }
            this.members = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version < 6) return;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeShort(this.errorCode);
        _writable.writeInt(this.generationId);
        if (_version >= 7) {
            if (this.protocolType == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.protocolType);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
        }
        if (this.protocolName == null) {
            if (_version < 7) throw new NullPointerException();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue(this.protocolName);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _stringBytes = _cache.getSerializedValue(this.leader);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.memberId);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.members.size() + 1);
            _stringBytes = this.members.iterator();
            while (_stringBytes.hasNext()) {
                JoinGroupResponseMember membersElement = (JoinGroupResponseMember)_stringBytes.next();
                membersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.members.size());
            _stringBytes = this.members.iterator();
            while (_stringBytes.hasNext()) {
                JoinGroupResponseMember membersElement = (JoinGroupResponseMember)_stringBytes.next();
                membersElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            return;
        } else {
            if (_numTaggedFields <= 0) return;
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        this.generationId = struct.getInt("generation_id");
        this.protocolType = _version >= 7 ? struct.getString("protocol_type") : null;
        this.protocolName = struct.getString("protocol_name");
        this.leader = struct.getString("leader");
        this.memberId = struct.getString("member_id");
        Object[] _nestedObjects = struct.getArray("members");
        this.members = new ArrayList<JoinGroupResponseMember>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.members.add(new JoinGroupResponseMember((Struct)nestedObject, _version));
        }
        if (_version >= 6 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 6) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        struct.set("generation_id", (Object)this.generationId);
        if (_version >= 7) {
            struct.set("protocol_type", (Object)this.protocolType);
        }
        struct.set("protocol_name", (Object)this.protocolName);
        struct.set("leader", (Object)this.leader);
        struct.set("member_id", (Object)this.memberId);
        Struct[] _nestedObjects = new Struct[this.members.size()];
        int i = 0;
        for (JoinGroupResponseMember element : this.members) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("members", (Object)_nestedObjects);
        if (_version >= 6) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size += 4;
        }
        _size += 2;
        _size += 4;
        if (_version >= 7) {
            if (this.protocolType == null) {
                ++_size;
            } else {
                _stringBytes = this.protocolType.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'protocolType' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.protocolType, _stringBytes);
                _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            }
        }
        if (this.protocolName == null) {
            _size = _version >= 6 ? ++_size : (_size += 2);
        } else {
            _stringBytes = this.protocolName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'protocolName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.protocolName, _stringBytes);
            _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        }
        _stringBytes = this.leader.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'leader' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.leader, _stringBytes);
        _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, _stringBytes);
        _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        int _arraySize = 0;
        _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.members.size() + 1)) : (_arraySize += 4);
        for (JoinGroupResponseMember membersElement : this.members) {
            _arraySize += membersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 6) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinGroupResponseData)) {
            return false;
        }
        JoinGroupResponseData other = (JoinGroupResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
            return false;
        }
        if (this.protocolName == null ? other.protocolName != null : !this.protocolName.equals(other.protocolName)) {
            return false;
        }
        if (this.leader == null ? other.leader != null : !this.leader.equals(other.leader)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        return !(this.members == null ? other.members != null : !this.members.equals(other.members));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + this.generationId;
        hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        hashCode = 31 * hashCode + (this.protocolName == null ? 0 : this.protocolName.hashCode());
        hashCode = 31 * hashCode + (this.leader == null ? 0 : this.leader.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
        return hashCode;
    }

    public String toString() {
        return "JoinGroupResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", generationId=" + this.generationId + ", protocolType=" + (this.protocolType == null ? "null" : "'" + this.protocolType.toString() + "'") + ", protocolName=" + (this.protocolName == null ? "null" : "'" + this.protocolName.toString() + "'") + ", leader=" + (this.leader == null ? "null" : "'" + this.leader.toString() + "'") + ", memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int generationId() {
        return this.generationId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public String protocolName() {
        return this.protocolName;
    }

    public String leader() {
        return this.leader;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<JoinGroupResponseMember> members() {
        return this.members;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public JoinGroupResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public JoinGroupResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public JoinGroupResponseData setGenerationId(int v) {
        this.generationId = v;
        return this;
    }

    public JoinGroupResponseData setProtocolType(String v) {
        this.protocolType = v;
        return this;
    }

    public JoinGroupResponseData setProtocolName(String v) {
        this.protocolName = v;
        return this;
    }

    public JoinGroupResponseData setLeader(String v) {
        this.leader = v;
        return this;
    }

    public JoinGroupResponseData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public JoinGroupResponseData setMembers(List<JoinGroupResponseMember> v) {
        this.members = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("generation_id", Type.INT32, "The generation ID of the group."), new Field("protocol_name", Type.STRING, "The group protocol selected by the coordinator."), new Field("leader", Type.STRING, "The leader of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("members", new ArrayOf(JoinGroupResponseMember.SCHEMA_0), ""));
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("generation_id", Type.INT32, "The generation ID of the group."), new Field("protocol_name", Type.STRING, "The group protocol selected by the coordinator."), new Field("leader", Type.STRING, "The leader of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("members", new ArrayOf(JoinGroupResponseMember.SCHEMA_0), "")));
        SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("generation_id", Type.INT32, "The generation ID of the group."), new Field("protocol_name", Type.STRING, "The group protocol selected by the coordinator."), new Field("leader", Type.STRING, "The leader of the group."), new Field("member_id", Type.STRING, "The member ID assigned by the group coordinator."), new Field("members", new ArrayOf(JoinGroupResponseMember.SCHEMA_5), ""));
        SCHEMA_6 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("generation_id", Type.INT32, "The generation ID of the group."), new Field("protocol_name", Type.COMPACT_STRING, "The group protocol selected by the coordinator."), new Field("leader", Type.COMPACT_STRING, "The leader of the group."), new Field("member_id", Type.COMPACT_STRING, "The member ID assigned by the group coordinator."), new Field("members", new CompactArrayOf(JoinGroupResponseMember.SCHEMA_6), ""), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_7 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("generation_id", Type.INT32, "The generation ID of the group."), new Field("protocol_type", Type.COMPACT_NULLABLE_STRING, "The group protocol name."), new Field("protocol_name", Type.COMPACT_NULLABLE_STRING, "The group protocol selected by the coordinator."), new Field("leader", Type.COMPACT_STRING, "The leader of the group."), new Field("member_id", Type.COMPACT_STRING, "The member ID assigned by the group coordinator."), new Field("members", new CompactArrayOf(JoinGroupResponseMember.SCHEMA_6), ""), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class JoinGroupResponseMember
    implements Message {
        private String memberId;
        private String groupInstanceId;
        private byte[] metadata;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public JoinGroupResponseMember(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public JoinGroupResponseMember(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public JoinGroupResponseMember() {
            this.memberId = "";
            this.groupInstanceId = null;
            this.metadata = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of JoinGroupResponseMember");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            if (_version >= 5) {
                length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.groupInstanceId = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                    }
                    this.groupInstanceId = _readable.readString(length);
                }
            } else {
                this.groupInstanceId = null;
            }
            length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field metadata was serialized as null");
            }
            byte[] newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.metadata = newBytes;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of JoinGroupResponseMember");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.memberId);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 5) {
                if (this.groupInstanceId == null) {
                    if (_version >= 6) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                    if (_version >= 6) {
                        _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    } else {
                        _writable.writeShort((short)_stringBytes.length);
                    }
                    _writable.writeByteArray(_stringBytes);
                }
            } else if (this.groupInstanceId != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
            }
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.metadata.length + 1);
            } else {
                _writable.writeInt(this.metadata.length);
            }
            _writable.writeByteArray(this.metadata);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of JoinGroupResponseMember");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.memberId = struct.getString("member_id");
            this.groupInstanceId = _version >= 5 ? struct.getString("group_instance_id") : null;
            this.metadata = struct.getByteArray("metadata");
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of JoinGroupResponseMember");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("member_id", (Object)this.memberId);
            if (_version >= 5) {
                struct.set("group_instance_id", (Object)this.groupInstanceId);
            } else if (this.groupInstanceId != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
            }
            struct.setByteArray("metadata", this.metadata);
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of JoinGroupResponseMember");
            }
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (_version >= 5) {
                if (this.groupInstanceId == null) {
                    _size = _version >= 6 ? ++_size : (_size += 2);
                } else {
                    _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.groupInstanceId, _stringBytes);
                    _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
                }
            }
            int _bytesSize = this.metadata.length;
            _bytesSize = _version >= 6 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint(this.metadata.length + 1)) : (_bytesSize += 4);
            _size += _bytesSize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JoinGroupResponseMember)) {
                return false;
            }
            JoinGroupResponseMember other = (JoinGroupResponseMember)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
                return false;
            }
            return Arrays.equals(this.metadata, other.metadata);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.metadata);
            return hashCode;
        }

        public String toString() {
            return "JoinGroupResponseMember(memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", metadata=" + Arrays.toString(this.metadata) + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String groupInstanceId() {
            return this.groupInstanceId;
        }

        public byte[] metadata() {
            return this.metadata;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public JoinGroupResponseMember setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public JoinGroupResponseMember setGroupInstanceId(String v) {
            this.groupInstanceId = v;
            return this;
        }

        public JoinGroupResponseMember setMetadata(byte[] v) {
            this.metadata = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("member_id", Type.STRING, "The group member ID."), new Field("metadata", Type.BYTES, "The group member metadata.")))));
            SCHEMA_5 = new Schema(new Field("member_id", Type.STRING, "The group member ID."), new Field("group_instance_id", Type.NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("metadata", Type.BYTES, "The group member metadata."));
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field("member_id", Type.COMPACT_STRING, "The group member ID."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("metadata", Type.COMPACT_BYTES, "The group member metadata."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

