/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client;

import java.util.Collections;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.common.config.ConfigDef;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.config.ConfigDef;

public class SchemaRegistryClientConfig {
    public static final String CLIENT_NAMESPACE = "schema.registry.";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE = "bearer.auth.credentials.source";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";

    public static void withClientSslSupport(org.apache.flink.avro.registry.confluent.shaded.io.confluent.common.config.ConfigDef configDef, String namespace) {
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        for (ConfigDef.ConfigKey configKey : sslConfigDef.configKeys().values()) {
            ConfigDef.Type type = SchemaRegistryClientConfig.typeFor(configKey.type);
            configDef.define(namespace + configKey.name, type, configKey.defaultValue != null ? configKey.defaultValue : SchemaRegistryClientConfig.defaultFor(type), SchemaRegistryClientConfig.importanceFor(configKey.importance), configKey.documentation);
        }
    }

    private static ConfigDef.Type typeFor(ConfigDef.Type type) {
        return ConfigDef.Type.valueOf(type.name());
    }

    private static Object defaultFor(ConfigDef.Type type) {
        switch (type) {
            case BOOLEAN: {
                return false;
            }
            case STRING: {
                return "";
            }
            case INT: {
                return 0;
            }
            case LONG: {
                return 0L;
            }
            case DOUBLE: {
                return 0.0;
            }
            case LIST: {
                return Collections.emptyList();
            }
            case CLASS: {
                return Object.class;
            }
            case PASSWORD: {
                return "";
            }
            case MAP: {
                return Collections.emptyMap();
            }
        }
        return "";
    }

    private static ConfigDef.Importance importanceFor(ConfigDef.Importance importance) {
        return ConfigDef.Importance.valueOf(importance.name());
    }
}

