/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import org.apache.flink.formats.avro.SchemaCoder;
import org.apache.flink.formats.avro.registry.confluent.ConfluentSchemaRegistryCoder;

@Internal
class CachedSchemaCoderProvider
implements SchemaCoder.SchemaCoderProvider {
    private static final long serialVersionUID = 8610401613495438381L;
    private final String subject;
    private final String url;
    private final int identityMapCapacity;

    CachedSchemaCoderProvider(String url, int identityMapCapacity) {
        this(null, url, identityMapCapacity);
    }

    CachedSchemaCoderProvider(@Nullable String subject, String url, int identityMapCapacity) {
        this.subject = subject;
        this.url = Objects.requireNonNull(url);
        this.identityMapCapacity = identityMapCapacity;
    }

    @Override
    public SchemaCoder get() {
        return new ConfluentSchemaRegistryCoder(this.subject, new CachedSchemaRegistryClient(this.url, this.identityMapCapacity));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedSchemaCoderProvider that = (CachedSchemaCoderProvider)o;
        return this.identityMapCapacity == that.identityMapCapacity && Objects.equals(this.subject, that.subject) && this.url.equals(that.url);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.url, this.identityMapCapacity);
    }
}

