/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class DescribeLogDirsResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET_LAG = -1L;
    private static final String LOG_DIRS_KEY_NAME = "log_dirs";
    private static final String LOG_DIR_KEY_NAME = "log_dir";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String SIZE_KEY_NAME = "size";
    private static final String OFFSET_LAG_KEY_NAME = "offset_lag";
    private static final String IS_FUTURE_KEY_NAME = "is_future";
    private static final Schema DESCRIBE_LOG_DIRS_RESPONSE_V0;
    private static final Schema DESCRIBE_LOG_DIRS_RESPONSE_V1;
    private final int throttleTimeMs;
    private final Map<String, LogDirInfo> logDirInfos;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_LOG_DIRS_RESPONSE_V0, DESCRIBE_LOG_DIRS_RESPONSE_V1};
    }

    public DescribeLogDirsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.logDirInfos = new HashMap<String, LogDirInfo>();
        for (Object logDirStructObj : struct.getArray(LOG_DIRS_KEY_NAME)) {
            Struct logDirStruct = (Struct)logDirStructObj;
            Errors error = Errors.forCode(logDirStruct.get(CommonFields.ERROR_CODE));
            String logDir = logDirStruct.getString(LOG_DIR_KEY_NAME);
            HashMap<TopicPartition, ReplicaInfo> replicaInfos = new HashMap<TopicPartition, ReplicaInfo>();
            for (Object topicStructObj : logDirStruct.getArray(TOPICS_KEY_NAME)) {
                Struct topicStruct = (Struct)topicStructObj;
                String topic = topicStruct.get(CommonFields.TOPIC_NAME);
                for (Object partitionStructObj : topicStruct.getArray(PARTITIONS_KEY_NAME)) {
                    Struct partitionStruct = (Struct)partitionStructObj;
                    int partition = partitionStruct.get(CommonFields.PARTITION_ID);
                    long size = partitionStruct.getLong(SIZE_KEY_NAME);
                    long offsetLag = partitionStruct.getLong(OFFSET_LAG_KEY_NAME);
                    boolean isFuture = partitionStruct.getBoolean(IS_FUTURE_KEY_NAME);
                    ReplicaInfo replicaInfo = new ReplicaInfo(size, offsetLag, isFuture);
                    replicaInfos.put(new TopicPartition(topic, partition), replicaInfo);
                }
            }
            this.logDirInfos.put(logDir, new LogDirInfo(error, replicaInfos));
        }
    }

    public DescribeLogDirsResponse(int throttleTimeMs, Map<String, LogDirInfo> logDirInfos) {
        this.throttleTimeMs = throttleTimeMs;
        this.logDirInfos = logDirInfos;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_LOG_DIRS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        ArrayList<Struct> logDirStructArray = new ArrayList<Struct>();
        for (Map.Entry<String, LogDirInfo> logDirInfosEntry : this.logDirInfos.entrySet()) {
            LogDirInfo logDirInfo = logDirInfosEntry.getValue();
            Struct logDirStruct = struct.instance(LOG_DIRS_KEY_NAME);
            logDirStruct.set(CommonFields.ERROR_CODE, logDirInfo.error.code());
            logDirStruct.set(LOG_DIR_KEY_NAME, (Object)logDirInfosEntry.getKey());
            Map<String, Map<Integer, ReplicaInfo>> replicaInfosByTopic = CollectionUtils.groupPartitionDataByTopic(logDirInfo.replicaInfos);
            ArrayList<Struct> topicStructArray = new ArrayList<Struct>();
            for (Map.Entry<String, Map<Integer, ReplicaInfo>> replicaInfosByTopicEntry : replicaInfosByTopic.entrySet()) {
                Struct topicStruct = logDirStruct.instance(TOPICS_KEY_NAME);
                topicStruct.set(CommonFields.TOPIC_NAME, replicaInfosByTopicEntry.getKey());
                ArrayList<Struct> partitionStructArray = new ArrayList<Struct>();
                for (Map.Entry<Integer, ReplicaInfo> replicaInfosByPartitionEntry : replicaInfosByTopicEntry.getValue().entrySet()) {
                    Struct partitionStruct = topicStruct.instance(PARTITIONS_KEY_NAME);
                    ReplicaInfo replicaInfo = replicaInfosByPartitionEntry.getValue();
                    partitionStruct.set(CommonFields.PARTITION_ID, replicaInfosByPartitionEntry.getKey());
                    partitionStruct.set(SIZE_KEY_NAME, (Object)replicaInfo.size);
                    partitionStruct.set(OFFSET_LAG_KEY_NAME, (Object)replicaInfo.offsetLag);
                    partitionStruct.set(IS_FUTURE_KEY_NAME, (Object)replicaInfo.isFuture);
                    partitionStructArray.add(partitionStruct);
                }
                topicStruct.set(PARTITIONS_KEY_NAME, (Object)partitionStructArray.toArray());
                topicStructArray.add(topicStruct);
            }
            logDirStruct.set(TOPICS_KEY_NAME, (Object)topicStructArray.toArray());
            logDirStructArray.add(logDirStruct);
        }
        struct.set(LOG_DIRS_KEY_NAME, (Object)logDirStructArray.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (LogDirInfo logDirInfo : this.logDirInfos.values()) {
            this.updateErrorCounts(errorCounts, logDirInfo.error);
        }
        return errorCounts;
    }

    public Map<String, LogDirInfo> logDirInfos() {
        return this.logDirInfos;
    }

    public static DescribeLogDirsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeLogDirsResponse(ApiKeys.DESCRIBE_LOG_DIRS.responseSchema(version).read(buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        DESCRIBE_LOG_DIRS_RESPONSE_V1 = DESCRIBE_LOG_DIRS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(LOG_DIRS_KEY_NAME, new ArrayOf(new Schema(CommonFields.ERROR_CODE, new Field(LOG_DIR_KEY_NAME, Type.STRING, "The absolute log directory path."), new Field(TOPICS_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(new Schema(CommonFields.PARTITION_ID, new Field(SIZE_KEY_NAME, Type.INT64, "The size of the log segments of the partition in bytes."), new Field(OFFSET_LAG_KEY_NAME, Type.INT64, "The lag of the log's LEO w.r.t. partition's HW (if it is the current log for the partition) or current replica's LEO (if it is the future log for the partition)"), new Field(IS_FUTURE_KEY_NAME, Type.BOOLEAN, "True if this log is created by AlterReplicaLogDirsRequest and will replace the current log of the replica in the future.")))))))))));
    }

    public static class ReplicaInfo {
        public final long size;
        public final long offsetLag;
        public final boolean isFuture;

        public ReplicaInfo(long size, long offsetLag, boolean isFuture) {
            this.size = size;
            this.offsetLag = offsetLag;
            this.isFuture = isFuture;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(size=").append(this.size).append(", offsetLag=").append(this.offsetLag).append(", isFuture=").append(this.isFuture).append(")");
            return builder.toString();
        }
    }

    public static class LogDirInfo {
        public final Errors error;
        public final Map<TopicPartition, ReplicaInfo> replicaInfos;

        public LogDirInfo(Errors error, Map<TopicPartition, ReplicaInfo> replicaInfos) {
            this.error = error;
            this.replicaInfos = replicaInfos;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(error=").append((Object)this.error).append(", replicas=").append(this.replicaInfos).append(")");
            return builder.toString();
        }
    }
}

