/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class DeleteRecordsResponse
extends AbstractResponse {
    public static final long INVALID_LOW_WATERMARK = -1L;
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String LOW_WATERMARK_KEY_NAME = "low_watermark";
    private static final Schema DELETE_RECORDS_RESPONSE_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, new Field("low_watermark", Type.INT64, "Smallest available offset of all live replicas"), CommonFields.ERROR_CODE);
    private static final Schema DELETE_RECORDS_RESPONSE_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(DELETE_RECORDS_RESPONSE_PARTITION_V0)));
    private static final Schema DELETE_RECORDS_RESPONSE_V0;
    private static final Schema DELETE_RECORDS_RESPONSE_V1;
    private final int throttleTimeMs;
    private final Map<TopicPartition, PartitionResponse> responses;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_RECORDS_RESPONSE_V0, DELETE_RECORDS_RESPONSE_V1};
    }

    public DeleteRecordsResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.responses = new HashMap<TopicPartition, PartitionResponse>();
        for (Object topicStructObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicStruct = (Struct)topicStructObj;
            String topic = topicStruct.get(CommonFields.TOPIC_NAME);
            for (Object partitionStructObj : topicStruct.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionStruct = (Struct)partitionStructObj;
                int partition = partitionStruct.get(CommonFields.PARTITION_ID);
                long lowWatermark = partitionStruct.getLong(LOW_WATERMARK_KEY_NAME);
                Errors error = Errors.forCode(partitionStruct.get(CommonFields.ERROR_CODE));
                this.responses.put(new TopicPartition(topic, partition), new PartitionResponse(lowWatermark, error));
            }
        }
    }

    public DeleteRecordsResponse(int throttleTimeMs, Map<TopicPartition, PartitionResponse> responses) {
        this.throttleTimeMs = throttleTimeMs;
        this.responses = responses;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DELETE_RECORDS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        Map<String, Map<Integer, PartitionResponse>> responsesByTopic = CollectionUtils.groupPartitionDataByTopic(this.responses);
        ArrayList<Struct> topicStructArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionResponse>> responsesByTopicEntry : responsesByTopic.entrySet()) {
            Struct topicStruct = struct.instance(TOPICS_KEY_NAME);
            topicStruct.set(CommonFields.TOPIC_NAME, responsesByTopicEntry.getKey());
            ArrayList<Struct> partitionStructArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionResponse> responsesByPartitionEntry : responsesByTopicEntry.getValue().entrySet()) {
                Struct partitionStruct = topicStruct.instance(PARTITIONS_KEY_NAME);
                PartitionResponse response = responsesByPartitionEntry.getValue();
                partitionStruct.set(CommonFields.PARTITION_ID, responsesByPartitionEntry.getKey());
                partitionStruct.set(LOW_WATERMARK_KEY_NAME, (Object)response.lowWatermark);
                partitionStruct.set(CommonFields.ERROR_CODE, response.error.code());
                partitionStructArray.add(partitionStruct);
            }
            topicStruct.set(PARTITIONS_KEY_NAME, (Object)partitionStructArray.toArray());
            topicStructArray.add(topicStruct);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicStructArray.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, PartitionResponse> responses() {
        return this.responses;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (PartitionResponse response : this.responses.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static DeleteRecordsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteRecordsResponse(ApiKeys.DELETE_RECORDS.responseSchema(version).read(buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        DELETE_RECORDS_RESPONSE_V1 = DELETE_RECORDS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(TOPICS_KEY_NAME, new ArrayOf(DELETE_RECORDS_RESPONSE_TOPIC_V0)));
    }

    public static final class PartitionResponse {
        public long lowWatermark;
        public Errors error;

        public PartitionResponse(long lowWatermark, Errors error) {
            this.lowWatermark = lowWatermark;
            this.error = error;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('{').append(",low_watermark: ").append(this.lowWatermark).append("error: ").append(this.error.toString()).append('}');
            return builder.toString();
        }
    }
}

