/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class ControlledShutdownResponse
extends AbstractResponse {
    private final ControlledShutdownResponseData data;

    public ControlledShutdownResponse(ControlledShutdownResponseData data) {
        this.data = data;
    }

    public ControlledShutdownResponse(Struct struct, short version) {
        this.data = new ControlledShutdownResponseData(struct, version);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(this.error(), 1);
    }

    public static ControlledShutdownResponse parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownResponse(ApiKeys.CONTROLLED_SHUTDOWN.parseResponse(version, buffer), version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public ControlledShutdownResponseData data() {
        return this.data;
    }

    public static ControlledShutdownResponse prepareResponse(Errors error, Set<TopicPartition> tps) {
        ControlledShutdownResponseData data = new ControlledShutdownResponseData();
        data.setErrorCode(error.code());
        ControlledShutdownResponseData.RemainingPartitionCollection pSet = new ControlledShutdownResponseData.RemainingPartitionCollection();
        tps.forEach(tp -> pSet.add(new ControlledShutdownResponseData.RemainingPartition().setTopicName(tp.topic()).setPartitionIndex(tp.partition())));
        data.setRemainingPartitions(pSet);
        return new ControlledShutdownResponse(data);
    }
}

