/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.avro;

import java.util.List;
import java.util.Optional;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.ParsedSchema;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.avro.AvroSchema;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaProvider.class);

    @Override
    public String schemaType() {
        return "AVRO";
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references) {
        try {
            return Optional.of(new AvroSchema(schemaString, references, this.resolveReferences(references), null));
        }
        catch (Exception e) {
            log.error("Could not parse Avro schema", (Throwable)e);
            return Optional.empty();
        }
    }
}

