/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry;

import java.util.List;
import java.util.Objects;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.CompatibilityChecker;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.CompatibilityLevel;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;

public interface ParsedSchema {
    public String schemaType();

    public String name();

    public String canonicalString();

    default public String formattedString(String format) {
        if (format == null || format.trim().isEmpty()) {
            return this.canonicalString();
        }
        throw new IllegalArgumentException("Format not supported: " + format);
    }

    public List<SchemaReference> references();

    default public void validate() {
    }

    public boolean isBackwardCompatible(ParsedSchema var1);

    default public boolean isCompatible(CompatibilityLevel level, List<? extends ParsedSchema> previousSchemas) {
        for (ParsedSchema parsedSchema : previousSchemas) {
            if (this.schemaType().equals(parsedSchema.schemaType())) continue;
            return false;
        }
        return CompatibilityChecker.checker(level).isCompatible(this, previousSchemas);
    }

    public Object rawSchema();

    default public boolean deepEquals(ParsedSchema schema) {
        return Objects.equals(this.rawSchema(), schema.rawSchema());
    }
}

