/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.org.apache.commons.httpclient.HttpMethod;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.InterruptableInputStream;

public class HttpMethodReleaseInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog((Class)HttpMethodReleaseInputStream.class);
    private InputStream inputStream = null;
    private HttpMethod httpMethod = null;
    private boolean alreadyReleased = false;
    private boolean underlyingStreamConsumed = false;

    public HttpMethodReleaseInputStream(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        try {
            this.inputStream = new InterruptableInputStream(httpMethod.getResponseBodyAsStream());
        }
        catch (IOException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Unable to obtain HttpMethod's response data stream", (Throwable)e);
            }
            httpMethod.releaseConnection();
            this.inputStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    protected void releaseConnection() throws IOException {
        if (!this.alreadyReleased) {
            if (!this.underlyingStreamConsumed) {
                this.httpMethod.abort();
            }
            this.httpMethod.releaseConnection();
            this.alreadyReleased = true;
        }
    }

    public int read() throws IOException {
        try {
            int read = this.inputStream.read();
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Released HttpMethod as its response data stream is fully consumed");
                    }
                }
            }
            return read;
        }
        catch (IOException e) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.inputStream.read(b, off, len);
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Released HttpMethod as its response data stream is fully consumed");
                    }
                }
            }
            return read;
        }
        catch (IOException e) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    public void close() throws IOException {
        if (!this.alreadyReleased) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Released HttpMethod as its response data stream is closed");
            }
        }
        this.inputStream.close();
    }

    protected void finalize() throws Throwable {
        if (!this.alreadyReleased) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Attempting to release HttpMethod in finalize() as its response data stream has gone out of scope. This attempt will not always succeed and cannot be relied upon! Please ensure S3 response data streams are always fully consumed or closed to avoid HTTP connection starvation.");
            }
            this.releaseConnection();
            if (log.isWarnEnabled()) {
                log.warn((Object)"Successfully released HttpMethod in finalize(). You were lucky this time... Please ensure S3 response data streams are always fully consumed or closed.");
            }
        }
        super.finalize();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

