/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.MapTaskRunner;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.SpillRecord;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

class MapTask
extends Task {
    public static final int MAP_OUTPUT_INDEX_RECORD_LENGTH = 24;
    private JobSplit.TaskSplitIndex splitMetaInfo = new JobSplit.TaskSplitIndex();
    private static final int APPROX_HEADER_LENGTH = 150;
    private static final Log LOG = LogFactory.getLog((String)MapTask.class.getName());

    public MapTask() {
        this.setPhase(TaskStatus.Phase.MAP);
    }

    public MapTask(String jobFile, org.apache.hadoop.mapred.TaskAttemptID taskId, int partition, JobSplit.TaskSplitIndex splitIndex, int numSlotsRequired) {
        super(jobFile, taskId, partition, numSlotsRequired);
        this.setPhase(TaskStatus.Phase.MAP);
        this.splitMetaInfo = splitIndex;
    }

    @Override
    public boolean isMapTask() {
        return true;
    }

    @Override
    public void localizeConfiguration(JobConf conf) throws IOException {
        super.localizeConfiguration(conf);
        if (this.supportIsolationRunner(conf) && this.isMapOrReduce()) {
            Path localSplitMeta = new LocalDirAllocator("mapred.local.dir").getLocalPathForWrite(TaskTracker.getLocalSplitFile(conf.getUser(), this.getJobID().toString(), this.getTaskID().toString()), conf);
            LOG.debug((Object)("Writing local split to " + localSplitMeta));
            FSDataOutputStream out = FileSystem.getLocal(conf).create(localSplitMeta);
            this.splitMetaInfo.write(out);
            ((FilterOutputStream)out).close();
        }
    }

    @Override
    public TaskRunner createRunner(TaskTracker tracker, TaskTracker.TaskInProgress tip, TaskTracker.RunningJob rjob) throws IOException {
        return new MapTaskRunner(tip, tracker, this.conf, rjob);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (this.isMapOrReduce()) {
            if (this.splitMetaInfo != null) {
                this.splitMetaInfo.write(out);
            } else {
                new JobSplit.TaskSplitIndex().write(out);
            }
            this.splitMetaInfo = null;
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        if (this.isMapOrReduce()) {
            this.splitMetaInfo.readFields(in);
        }
    }

    @Override
    public void run(JobConf job, TaskUmbilicalProtocol umbilical) throws IOException, ClassNotFoundException, InterruptedException {
        this.umbilical = umbilical;
        Task.TaskReporter reporter = new Task.TaskReporter(this, this.getProgress(), umbilical, this.jvmContext);
        reporter.startCommunicationThread();
        boolean useNewApi = job.getUseNewMapper();
        this.initialize(job, this.getJobID(), reporter, useNewApi);
        if (this.jobCleanup) {
            this.runJobCleanupTask(umbilical, reporter);
            return;
        }
        if (this.jobSetup) {
            this.runJobSetupTask(umbilical, reporter);
            return;
        }
        if (this.taskCleanup) {
            this.runTaskCleanupTask(umbilical, reporter);
            return;
        }
        if (useNewApi) {
            this.runNewMapper(job, this.splitMetaInfo, umbilical, reporter);
        } else {
            this.runOldMapper(job, this.splitMetaInfo, umbilical, reporter);
        }
        this.done(umbilical, reporter);
    }

    private <T> T getSplitDetails(Path file, long offset) throws IOException {
        Class<?> cls;
        FileSystem fs = file.getFileSystem(this.conf);
        FSDataInputStream inFile = fs.open(file);
        inFile.seek(offset);
        String className = Text.readString(inFile);
        try {
            cls = this.conf.getClassByName(className);
        }
        catch (ClassNotFoundException ce) {
            IOException wrap = new IOException("Split class " + className + " not found");
            wrap.initCause(ce);
            throw wrap;
        }
        SerializationFactory factory = new SerializationFactory(this.conf);
        Deserializer<?> deserializer = factory.getDeserializer(cls);
        deserializer.open(inFile);
        T split = deserializer.deserialize(null);
        long pos = inFile.getPos();
        this.getCounters().findCounter(Task.Counter.SPLIT_RAW_BYTES).increment(pos - offset);
        inFile.close();
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void runOldMapper(JobConf job, JobSplit.TaskSplitIndex splitIndex, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, InterruptedException, ClassNotFoundException {
        org.apache.hadoop.mapred.InputSplit inputSplit = (org.apache.hadoop.mapred.InputSplit)this.getSplitDetails(new Path(splitIndex.getSplitLocation()), splitIndex.getStartOffset());
        this.updateJobWithSplit(job, inputSplit);
        reporter.setInputSplit(inputSplit);
        TrackedRecordReader in = this.isSkipping() ? new SkippingRecordReader(inputSplit, umbilical, reporter) : new TrackedRecordReader(inputSplit, job, reporter);
        job.setBoolean("mapred.skip.on", this.isSkipping());
        int numReduceTasks = this.conf.getNumReduceTasks();
        LOG.info((Object)("numReduceTasks: " + numReduceTasks));
        MapOutputCollector collector = null;
        collector = numReduceTasks > 0 ? new MapOutputBuffer(umbilical, job, reporter) : new DirectMapOutputCollector(umbilical, job, reporter);
        MapRunnable runner = ReflectionUtils.newInstance(job.getMapRunnerClass(), job);
        try {
            runner.run(in, new OldOutputCollector(collector, this.conf), reporter);
            collector.flush();
            in.close();
            in = null;
            collector.close();
            collector = null;
        }
        finally {
            this.closeQuietly(in);
            this.closeQuietly(collector);
        }
    }

    private void updateJobWithSplit(JobConf job, org.apache.hadoop.mapred.InputSplit inputSplit) {
        if (inputSplit instanceof FileSplit) {
            FileSplit fileSplit = (FileSplit)inputSplit;
            job.set("map.input.file", fileSplit.getPath().toString());
            job.setLong("map.input.start", fileSplit.getStart());
            job.setLong("map.input.length", fileSplit.getLength());
        }
        LOG.info((Object)("Processing split: " + inputSplit));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void runNewMapper(JobConf job, JobSplit.TaskSplitIndex splitIndex, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, ClassNotFoundException, InterruptedException {
        TaskAttemptContext taskContext = new TaskAttemptContext((Configuration)job, this.getTaskID());
        Mapper<?, ?, ?, ?> mapper = ReflectionUtils.newInstance(taskContext.getMapperClass(), job);
        InputFormat<?, ?> inputFormat = ReflectionUtils.newInstance(taskContext.getInputFormatClass(), job);
        InputSplit split = null;
        split = (InputSplit)this.getSplitDetails(new Path(splitIndex.getSplitLocation()), splitIndex.getStartOffset());
        LOG.info((Object)("Processing split: " + split));
        NewTrackingRecordReader input = new NewTrackingRecordReader(split, inputFormat, reporter, job, taskContext);
        job.setBoolean("mapred.skip.on", this.isSkipping());
        RecordWriter output = null;
        Mapper.Context mapperContext = null;
        try {
            Constructor contextConstructor = Mapper.Context.class.getConstructor(Mapper.class, Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
            output = job.getNumReduceTasks() == 0 ? new NewDirectOutputCollector(taskContext, job, umbilical, reporter) : new NewOutputCollector(taskContext, job, umbilical, reporter);
            mapperContext = (Mapper.Context)contextConstructor.newInstance(mapper, job, this.getTaskID(), input, output, this.committer, reporter, split);
            ((RecordReader)input).initialize(split, mapperContext);
            mapper.run(mapperContext);
            ((RecordReader)input).close();
            input = null;
            output.close(mapperContext);
            output = null;
            this.closeQuietly(input);
            this.closeQuietly(output, mapperContext);
            return;
        }
        catch (NoSuchMethodException e) {
            try {
                throw new IOException("Can't find Context constructor", e);
                catch (InstantiationException e2) {
                    throw new IOException("Can't create Context", e2);
                }
                catch (InvocationTargetException e3) {
                    throw new IOException("Can't invoke Context constructor", e3);
                }
                catch (IllegalAccessException e4) {
                    throw new IOException("Can't invoke Context constructor", e4);
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(input);
                this.closeQuietly(output, mapperContext);
                throw throwable;
            }
        }
    }

    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void closeQuietly(org.apache.hadoop.mapred.RecordReader<INKEY, INVALUE> c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException ie) {
                LOG.info((Object)("Ignoring exception during close for " + c), (Throwable)ie);
            }
        }
    }

    private <OUTKEY, OUTVALUE> void closeQuietly(MapOutputCollector<OUTKEY, OUTVALUE> c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception ie) {
                LOG.info((Object)("Ignoring exception during close for " + c), (Throwable)ie);
            }
        }
    }

    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void closeQuietly(RecordReader<INKEY, INVALUE> c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception ie) {
                LOG.info((Object)("Ignoring exception during close for " + c), (Throwable)ie);
            }
        }
    }

    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void closeQuietly(RecordWriter<OUTKEY, OUTVALUE> c, Mapper.Context mapperContext) {
        if (c != null) {
            try {
                c.close(mapperContext);
            }
            catch (Exception ie) {
                LOG.info((Object)("Ignoring exception during close for " + c), (Throwable)ie);
            }
        }
    }

    private static class MapBufferTooSmallException
    extends IOException {
        public MapBufferTooSmallException(String s) {
            super(s);
        }
    }

    class MapOutputBuffer<K, V>
    implements MapOutputCollector<K, V>,
    IndexedSortable {
        private final int partitions;
        private final JobConf job;
        private final Task.TaskReporter reporter;
        private final Class<K> keyClass;
        private final Class<V> valClass;
        private final RawComparator<K> comparator;
        private final SerializationFactory serializationFactory;
        private final Serializer<K> keySerializer;
        private final Serializer<V> valSerializer;
        private final Task.CombinerRunner<K, V> combinerRunner;
        private final Task.CombineOutputCollector<K, V> combineCollector;
        private CompressionCodec codec = null;
        private volatile int kvstart = 0;
        private volatile int kvend = 0;
        private int kvindex = 0;
        private final int[] kvoffsets;
        private final int[] kvindices;
        private volatile int bufstart = 0;
        private volatile int bufend = 0;
        private volatile int bufvoid = 0;
        private int bufindex = 0;
        private int bufmark = 0;
        private byte[] kvbuffer;
        private static final int PARTITION = 0;
        private static final int KEYSTART = 1;
        private static final int VALSTART = 2;
        private static final int ACCTSIZE = 3;
        private static final int RECSIZE = 16;
        private volatile int numSpills = 0;
        private volatile Throwable sortSpillException = null;
        private final int softRecordLimit;
        private final int softBufferLimit;
        private final int minSpillsForCombine;
        private final IndexedSorter sorter;
        private final ReentrantLock spillLock = new ReentrantLock();
        private final Condition spillDone = this.spillLock.newCondition();
        private final Condition spillReady = this.spillLock.newCondition();
        private final BlockingBuffer bb = new BlockingBuffer();
        private volatile boolean spillThreadRunning = false;
        private final SpillThread spillThread = new SpillThread();
        private final FileSystem localFs;
        private final FileSystem rfs;
        private final Counters.Counter mapOutputByteCounter;
        private final Counters.Counter mapOutputRecordCounter;
        private final Counters.Counter combineOutputCounter;
        private final Counters.Counter fileOutputByteCounter;
        private ArrayList<SpillRecord> indexCacheList;
        private int totalIndexCacheMemory;
        private static final int INDEX_CACHE_MEMORY_LIMIT = 0x100000;

        public MapOutputBuffer(TaskUmbilicalProtocol umbilical, JobConf job, Task.TaskReporter reporter) throws IOException, ClassNotFoundException {
            this.job = job;
            this.reporter = reporter;
            this.localFs = FileSystem.getLocal(job);
            this.partitions = job.getNumReduceTasks();
            this.rfs = ((LocalFileSystem)this.localFs).getRaw();
            this.indexCacheList = new ArrayList();
            float spillper = job.getFloat("io.sort.spill.percent", 0.8f);
            float recper = job.getFloat("io.sort.record.percent", 0.05f);
            int sortmb = job.getInt("io.sort.mb", 100);
            if (spillper > 1.0f || spillper < 0.0f) {
                throw new IOException("Invalid \"io.sort.spill.percent\": " + spillper);
            }
            if (recper > 1.0f || recper < 0.01f) {
                throw new IOException("Invalid \"io.sort.record.percent\": " + recper);
            }
            if ((sortmb & 0x7FF) != sortmb) {
                throw new IOException("Invalid \"io.sort.mb\": " + sortmb);
            }
            this.sorter = ReflectionUtils.newInstance(job.getClass("map.sort.class", QuickSort.class, IndexedSorter.class), job);
            LOG.info((Object)("io.sort.mb = " + sortmb));
            int maxMemUsage = sortmb << 20;
            int recordCapacity = (int)((float)maxMemUsage * recper);
            recordCapacity -= recordCapacity % 16;
            this.kvbuffer = new byte[maxMemUsage - recordCapacity];
            this.bufvoid = this.kvbuffer.length;
            this.kvoffsets = new int[recordCapacity /= 16];
            this.kvindices = new int[recordCapacity * 3];
            this.softBufferLimit = (int)((float)this.kvbuffer.length * spillper);
            this.softRecordLimit = (int)((float)this.kvoffsets.length * spillper);
            LOG.info((Object)("data buffer = " + this.softBufferLimit + "/" + this.kvbuffer.length));
            LOG.info((Object)("record buffer = " + this.softRecordLimit + "/" + this.kvoffsets.length));
            this.comparator = job.getOutputKeyComparator();
            this.keyClass = job.getMapOutputKeyClass();
            this.valClass = job.getMapOutputValueClass();
            this.serializationFactory = new SerializationFactory(job);
            this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
            this.keySerializer.open(this.bb);
            this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
            this.valSerializer.open(this.bb);
            this.mapOutputByteCounter = reporter.getCounter((Enum)Task.Counter.MAP_OUTPUT_BYTES);
            this.mapOutputRecordCounter = reporter.getCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
            Counter combineInputCounter = reporter.getCounter((Enum)Task.Counter.COMBINE_INPUT_RECORDS);
            this.combineOutputCounter = reporter.getCounter((Enum)Task.Counter.COMBINE_OUTPUT_RECORDS);
            this.fileOutputByteCounter = reporter.getCounter((Enum)Task.Counter.MAP_OUTPUT_MATERIALIZED_BYTES);
            if (job.getCompressMapOutput()) {
                Class<? extends CompressionCodec> codecClass = job.getMapOutputCompressorClass(DefaultCodec.class);
                this.codec = ReflectionUtils.newInstance(codecClass, job);
            }
            this.combinerRunner = Task.CombinerRunner.create(job, MapTask.this.getTaskID(), (Counters.Counter)combineInputCounter, reporter, null);
            this.combineCollector = this.combinerRunner != null ? new Task.CombineOutputCollector(this.combineOutputCounter, reporter, MapTask.this.conf) : null;
            this.minSpillsForCombine = job.getInt("min.num.spills.for.combine", 3);
            this.spillThread.setDaemon(true);
            this.spillThread.setName("SpillThread");
            this.spillLock.lock();
            try {
                this.spillThread.start();
                while (!this.spillThreadRunning) {
                    this.spillDone.await();
                }
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Spill thread failed to initialize").initCause(this.sortSpillException);
            }
            finally {
                this.spillLock.unlock();
            }
            if (this.sortSpillException != null) {
                throw (IOException)new IOException("Spill thread failed to initialize").initCause(this.sortSpillException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void collect(K key, V value, int partition) throws IOException {
            this.reporter.progress();
            if (key.getClass() != this.keyClass) {
                throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", recieved " + key.getClass().getName());
            }
            if (value.getClass() != this.valClass) {
                throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", recieved " + value.getClass().getName());
            }
            int kvnext = (this.kvindex + 1) % this.kvoffsets.length;
            this.spillLock.lock();
            try {
                boolean kvfull;
                do {
                    boolean kvsoftlimit;
                    if (this.sortSpillException != null) {
                        throw (IOException)new IOException("Spill failed").initCause(this.sortSpillException);
                    }
                    boolean bl = kvfull = kvnext == this.kvstart;
                    boolean bl2 = kvnext > this.kvend ? kvnext - this.kvend > this.softRecordLimit : (kvsoftlimit = this.kvend - kvnext <= this.kvoffsets.length - this.softRecordLimit);
                    if (this.kvstart == this.kvend && kvsoftlimit) {
                        LOG.info((Object)("Spilling map output: record full = " + kvsoftlimit));
                        this.startSpill();
                    }
                    if (!kvfull) continue;
                    try {
                        while (this.kvstart != this.kvend) {
                            this.reporter.progress();
                            this.spillDone.await();
                        }
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new IOException("Collector interrupted while waiting for the writer").initCause(e);
                    }
                } while (kvfull);
            }
            finally {
                this.spillLock.unlock();
            }
            try {
                int ind;
                int keystart = this.bufindex;
                this.keySerializer.serialize(key);
                if (this.bufindex < keystart) {
                    this.bb.reset();
                    keystart = 0;
                }
                int valstart = this.bufindex;
                this.valSerializer.serialize(value);
                int valend = this.bb.markRecord();
                if (partition < 0 || partition >= this.partitions) {
                    throw new IOException("Illegal partition for " + key + " (" + partition + ")");
                }
                this.mapOutputRecordCounter.increment(1L);
                this.mapOutputByteCounter.increment(valend >= keystart ? (long)(valend - keystart) : (long)(this.bufvoid - keystart + valend));
                this.kvoffsets[this.kvindex] = ind = this.kvindex * 3;
                this.kvindices[ind + 0] = partition;
                this.kvindices[ind + 1] = keystart;
                this.kvindices[ind + 2] = valstart;
                this.kvindex = kvnext;
            }
            catch (MapBufferTooSmallException e) {
                LOG.info((Object)("Record too large for in-memory buffer: " + e.getMessage()));
                this.spillSingleRecord(key, value, partition);
                this.mapOutputRecordCounter.increment(1L);
                return;
            }
        }

        @Override
        public int compare(int i, int j) {
            int ii = this.kvoffsets[i % this.kvoffsets.length];
            int ij = this.kvoffsets[j % this.kvoffsets.length];
            if (this.kvindices[ii + 0] != this.kvindices[ij + 0]) {
                return this.kvindices[ii + 0] - this.kvindices[ij + 0];
            }
            return this.comparator.compare(this.kvbuffer, this.kvindices[ii + 1], this.kvindices[ii + 2] - this.kvindices[ii + 1], this.kvbuffer, this.kvindices[ij + 1], this.kvindices[ij + 2] - this.kvindices[ij + 1]);
        }

        @Override
        public void swap(int i, int j) {
            int tmp = this.kvoffsets[i %= this.kvoffsets.length];
            this.kvoffsets[i] = this.kvoffsets[j %= this.kvoffsets.length];
            this.kvoffsets[j] = tmp;
        }

        @Override
        public synchronized void flush() throws IOException, ClassNotFoundException, InterruptedException {
            LOG.info((Object)"Starting flush of map output");
            this.spillLock.lock();
            try {
                while (this.kvstart != this.kvend) {
                    this.reporter.progress();
                    this.spillDone.await();
                }
                if (this.sortSpillException != null) {
                    throw (IOException)new IOException("Spill failed").initCause(this.sortSpillException);
                }
                if (this.kvend != this.kvindex) {
                    this.kvend = this.kvindex;
                    this.bufend = this.bufmark;
                    this.sortAndSpill();
                }
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Buffer interrupted while waiting for the writer").initCause(e);
            }
            finally {
                this.spillLock.unlock();
            }
            assert (!this.spillLock.isHeldByCurrentThread());
            try {
                this.spillThread.interrupt();
                this.spillThread.join();
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Spill failed").initCause(e);
            }
            this.kvbuffer = null;
            this.mergeParts();
            Path outputPath = MapTask.this.mapOutputFile.getOutputFile();
            this.fileOutputByteCounter.increment(this.rfs.getFileStatus(outputPath).getLen());
        }

        @Override
        public void close() {
        }

        private synchronized void startSpill() {
            LOG.info((Object)("bufstart = " + this.bufstart + "; bufend = " + this.bufmark + "; bufvoid = " + this.bufvoid));
            LOG.info((Object)("kvstart = " + this.kvstart + "; kvend = " + this.kvindex + "; length = " + this.kvoffsets.length));
            this.kvend = this.kvindex;
            this.bufend = this.bufmark;
            this.spillReady.signal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortAndSpill() throws IOException, ClassNotFoundException, InterruptedException {
            long size = (this.bufend >= this.bufstart ? this.bufend - this.bufstart : this.bufvoid - this.bufend + this.bufstart) + this.partitions * 150;
            FSDataOutputStream out = null;
            try {
                SpillRecord spillRec = new SpillRecord(this.partitions);
                Path filename = MapTask.this.mapOutputFile.getSpillFileForWrite(this.numSpills, size);
                out = this.rfs.create(filename);
                int endPosition = this.kvend > this.kvstart ? this.kvend : this.kvoffsets.length + this.kvend;
                this.sorter.sort(this, this.kvstart, endPosition, this.reporter);
                int spindex = this.kvstart;
                IndexRecord rec = new IndexRecord();
                InMemValBytes value = new InMemValBytes();
                for (int i = 0; i < this.partitions; ++i) {
                    IFile.Writer<K, V> writer = null;
                    try {
                        long segmentStart = out.getPos();
                        writer = new IFile.Writer<K, V>(this.job, out, this.keyClass, this.valClass, this.codec, MapTask.this.spilledRecordsCounter);
                        if (this.combinerRunner == null) {
                            DataInputBuffer key = new DataInputBuffer();
                            while (spindex < endPosition && this.kvindices[this.kvoffsets[spindex % this.kvoffsets.length] + 0] == i) {
                                int kvoff = this.kvoffsets[spindex % this.kvoffsets.length];
                                this.getVBytesForOffset(kvoff, value);
                                key.reset(this.kvbuffer, this.kvindices[kvoff + 1], this.kvindices[kvoff + 2] - this.kvindices[kvoff + 1]);
                                writer.append(key, value);
                                ++spindex;
                            }
                        } else {
                            int spstart = spindex;
                            while (spindex < endPosition && this.kvindices[this.kvoffsets[spindex % this.kvoffsets.length] + 0] == i) {
                                ++spindex;
                            }
                            if (spstart != spindex) {
                                this.combineCollector.setWriter(writer);
                                MRResultIterator kvIter = new MRResultIterator(spstart, spindex);
                                this.combinerRunner.combine(kvIter, this.combineCollector);
                            }
                        }
                        writer.close();
                        rec.startOffset = segmentStart;
                        rec.rawLength = writer.getRawLength();
                        rec.partLength = writer.getCompressedLength();
                        spillRec.putIndex(rec, i);
                        writer = null;
                        continue;
                    }
                    finally {
                        if (null != writer) {
                            writer.close();
                        }
                    }
                }
                if (this.totalIndexCacheMemory >= 0x100000) {
                    Path indexFilename = MapTask.this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, this.partitions * 24);
                    spillRec.writeToFile(indexFilename, this.job);
                } else {
                    this.indexCacheList.add(spillRec);
                    this.totalIndexCacheMemory += spillRec.size() * 24;
                }
                LOG.info((Object)("Finished spill " + this.numSpills));
                ++this.numSpills;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void spillSingleRecord(K key, V value, int partition) throws IOException {
            long size = this.kvbuffer.length + this.partitions * 150;
            FSDataOutputStream out = null;
            try {
                SpillRecord spillRec = new SpillRecord(this.partitions);
                Path filename = MapTask.this.mapOutputFile.getSpillFileForWrite(this.numSpills, size);
                out = this.rfs.create(filename);
                IndexRecord rec = new IndexRecord();
                for (int i = 0; i < this.partitions; ++i) {
                    IFile.Writer<K, V> writer = null;
                    try {
                        long segmentStart = out.getPos();
                        writer = new IFile.Writer<K, V>(this.job, out, this.keyClass, this.valClass, this.codec, MapTask.this.spilledRecordsCounter);
                        if (i == partition) {
                            long recordStart = out.getPos();
                            writer.append(key, value);
                            this.mapOutputByteCounter.increment(out.getPos() - recordStart);
                        }
                        writer.close();
                        rec.startOffset = segmentStart;
                        rec.rawLength = writer.getRawLength();
                        rec.partLength = writer.getCompressedLength();
                        spillRec.putIndex(rec, i);
                        writer = null;
                        continue;
                    }
                    catch (IOException e) {
                        if (null != writer) {
                            writer.close();
                        }
                        throw e;
                    }
                }
                if (this.totalIndexCacheMemory >= 0x100000) {
                    Path indexFilename = MapTask.this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, this.partitions * 24);
                    spillRec.writeToFile(indexFilename, this.job);
                } else {
                    this.indexCacheList.add(spillRec);
                    this.totalIndexCacheMemory += spillRec.size() * 24;
                }
                ++this.numSpills;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }

        private void getVBytesForOffset(int kvoff, InMemValBytes vbytes) {
            int nextindex = kvoff / 3 == (this.kvend - 1 + this.kvoffsets.length) % this.kvoffsets.length ? this.bufend : this.kvindices[(kvoff + 3 + 1) % this.kvindices.length];
            int vallen = nextindex >= this.kvindices[kvoff + 2] ? nextindex - this.kvindices[kvoff + 2] : this.bufvoid - this.kvindices[kvoff + 2] + nextindex;
            vbytes.reset(this.kvbuffer, this.kvindices[kvoff + 2], vallen);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mergeParts() throws IOException, InterruptedException, ClassNotFoundException {
            int i;
            long finalOutFileSize = 0L;
            long finalIndexFileSize = 0L;
            Path[] filename = new Path[this.numSpills];
            org.apache.hadoop.mapred.TaskAttemptID mapId = MapTask.this.getTaskID();
            for (i = 0; i < this.numSpills; ++i) {
                filename[i] = MapTask.this.mapOutputFile.getSpillFile(i);
                finalOutFileSize += this.rfs.getFileStatus(filename[i]).getLen();
            }
            if (this.numSpills == 1) {
                this.rfs.rename(filename[0], new Path(filename[0].getParent(), "file.out"));
                if (this.indexCacheList.size() == 0) {
                    this.rfs.rename(MapTask.this.mapOutputFile.getSpillIndexFile(0), new Path(filename[0].getParent(), "file.out.index"));
                } else {
                    this.indexCacheList.get(0).writeToFile(new Path(filename[0].getParent(), "file.out.index"), this.job);
                }
                return;
            }
            for (i = this.indexCacheList.size(); i < this.numSpills; ++i) {
                Path indexFileName = MapTask.this.mapOutputFile.getSpillIndexFile(i);
                this.indexCacheList.add(new SpillRecord(indexFileName, this.job, null));
            }
            finalIndexFileSize = this.partitions * 24;
            Path finalOutputFile = MapTask.this.mapOutputFile.getOutputFileForWrite(finalOutFileSize += (long)(this.partitions * 150));
            Path finalIndexFile = MapTask.this.mapOutputFile.getOutputIndexFileForWrite(finalIndexFileSize);
            FSDataOutputStream finalOut = this.rfs.create(finalOutputFile, true, 4096);
            if (this.numSpills == 0) {
                IndexRecord rec = new IndexRecord();
                SpillRecord sr = new SpillRecord(this.partitions);
                try {
                    for (int i2 = 0; i2 < this.partitions; ++i2) {
                        long segmentStart = finalOut.getPos();
                        IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.job, finalOut, this.keyClass, this.valClass, this.codec, null);
                        writer.close();
                        rec.startOffset = segmentStart;
                        rec.rawLength = writer.getRawLength();
                        rec.partLength = writer.getCompressedLength();
                        sr.putIndex(rec, i2);
                    }
                    sr.writeToFile(finalIndexFile, this.job);
                }
                finally {
                    finalOut.close();
                }
                return;
            }
            IndexRecord rec = new IndexRecord();
            SpillRecord spillRec = new SpillRecord(this.partitions);
            for (int parts = 0; parts < this.partitions; ++parts) {
                ArrayList segmentList = new ArrayList(this.numSpills);
                for (int i3 = 0; i3 < this.numSpills; ++i3) {
                    IndexRecord indexRecord = this.indexCacheList.get(i3).getIndex(parts);
                    Merger.Segment s = new Merger.Segment(this.job, this.rfs, filename[i3], indexRecord.startOffset, indexRecord.partLength, this.codec, true);
                    segmentList.add(i3, s);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("MapId=" + mapId + " Reducer=" + parts + "Spill =" + i3 + "(" + indexRecord.startOffset + "," + indexRecord.rawLength + ", " + indexRecord.partLength + ")"));
                }
                RawKeyValueIterator kvIter = Merger.merge((Configuration)this.job, this.rfs, this.keyClass, this.valClass, this.codec, segmentList, this.job.getInt("io.sort.factor", 100), new Path(mapId.toString()), this.job.getOutputKeyComparator(), this.reporter, null, MapTask.this.spilledRecordsCounter);
                long segmentStart = finalOut.getPos();
                IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.job, finalOut, this.keyClass, this.valClass, this.codec, MapTask.this.spilledRecordsCounter);
                if (this.combinerRunner == null || this.numSpills < this.minSpillsForCombine) {
                    Merger.writeFile(kvIter, writer, this.reporter, this.job);
                } else {
                    this.combineCollector.setWriter(writer);
                    this.combinerRunner.combine(kvIter, this.combineCollector);
                }
                writer.close();
                rec.startOffset = segmentStart;
                rec.rawLength = writer.getRawLength();
                rec.partLength = writer.getCompressedLength();
                spillRec.putIndex(rec, parts);
            }
            spillRec.writeToFile(finalIndexFile, this.job);
            finalOut.close();
            for (int i4 = 0; i4 < this.numSpills; ++i4) {
                this.rfs.delete(filename[i4], true);
            }
        }

        protected class MRResultIterator
        implements RawKeyValueIterator {
            private final DataInputBuffer keybuf = new DataInputBuffer();
            private final InMemValBytes vbytes = new InMemValBytes();
            private final int end;
            private int current;

            public MRResultIterator(int start, int end) {
                this.end = end;
                this.current = start - 1;
            }

            @Override
            public boolean next() throws IOException {
                return ++this.current < this.end;
            }

            @Override
            public DataInputBuffer getKey() throws IOException {
                int kvoff = MapOutputBuffer.this.kvoffsets[this.current % MapOutputBuffer.this.kvoffsets.length];
                this.keybuf.reset(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.kvindices[kvoff + 1], MapOutputBuffer.this.kvindices[kvoff + 2] - MapOutputBuffer.this.kvindices[kvoff + 1]);
                return this.keybuf;
            }

            @Override
            public DataInputBuffer getValue() throws IOException {
                MapOutputBuffer.this.getVBytesForOffset(MapOutputBuffer.this.kvoffsets[this.current % MapOutputBuffer.this.kvoffsets.length], this.vbytes);
                return this.vbytes;
            }

            @Override
            public Progress getProgress() {
                return null;
            }

            @Override
            public void close() {
            }
        }

        protected class InMemValBytes
        extends DataInputBuffer {
            private byte[] buffer;
            private int start;
            private int length;

            protected InMemValBytes() {
            }

            @Override
            public void reset(byte[] buffer, int start, int length) {
                this.buffer = buffer;
                this.start = start;
                this.length = length;
                if (start + length > MapOutputBuffer.this.bufvoid) {
                    this.buffer = new byte[this.length];
                    int taillen = MapOutputBuffer.this.bufvoid - start;
                    System.arraycopy(buffer, start, this.buffer, 0, taillen);
                    System.arraycopy(buffer, 0, this.buffer, taillen, length - taillen);
                    this.start = 0;
                }
                super.reset(this.buffer, this.start, this.length);
            }
        }

        protected class SpillThread
        extends Thread {
            protected SpillThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                MapOutputBuffer.this.spillLock.lock();
                MapOutputBuffer.this.spillThreadRunning = true;
                try {
                    try {}
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        MapOutputBuffer.this.spillLock.unlock();
                        MapOutputBuffer.this.spillThreadRunning = false;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    MapOutputBuffer.this.spillLock.unlock();
                    MapOutputBuffer.this.spillThreadRunning = false;
                    throw throwable;
                }
                while (true) {
                    MapOutputBuffer.this.spillDone.signal();
                    while (MapOutputBuffer.this.kvstart == MapOutputBuffer.this.kvend) {
                        MapOutputBuffer.this.spillReady.await();
                    }
                    try {
                        MapOutputBuffer.this.spillLock.unlock();
                        MapOutputBuffer.this.sortAndSpill();
                        continue;
                    }
                    catch (Exception e) {
                        MapOutputBuffer.this.sortSpillException = e;
                        continue;
                    }
                    catch (Throwable t) {
                        MapOutputBuffer.this.sortSpillException = t;
                        String logMsg = "Task " + MapTask.this.getTaskID() + " failed : " + StringUtils.stringifyException(t);
                        MapTask.this.reportFatalError(MapTask.this.getTaskID(), t, logMsg);
                        continue;
                    }
                    finally {
                        MapOutputBuffer.this.spillLock.lock();
                        if (MapOutputBuffer.this.bufend < MapOutputBuffer.this.bufindex && MapOutputBuffer.this.bufindex < MapOutputBuffer.this.bufstart) {
                            MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                        }
                        MapOutputBuffer.this.kvstart = MapOutputBuffer.this.kvend;
                        MapOutputBuffer.this.bufstart = MapOutputBuffer.this.bufend;
                        continue;
                    }
                    break;
                }
            }
        }

        public class Buffer
        extends OutputStream {
            private final byte[] scratch = new byte[1];

            @Override
            public synchronized void write(int v) throws IOException {
                this.scratch[0] = (byte)v;
                this.write(this.scratch, 0, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                boolean buffull = false;
                boolean wrap = false;
                MapOutputBuffer.this.spillLock.lock();
                try {
                    do {
                        if (MapOutputBuffer.this.sortSpillException != null) {
                            throw (IOException)new IOException("Spill failed").initCause(MapOutputBuffer.this.sortSpillException);
                        }
                        if (MapOutputBuffer.this.bufstart <= MapOutputBuffer.this.bufend && MapOutputBuffer.this.bufend <= MapOutputBuffer.this.bufindex) {
                            buffull = MapOutputBuffer.this.bufindex + len > MapOutputBuffer.this.bufvoid;
                            wrap = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufindex + MapOutputBuffer.this.bufstart > len;
                        } else {
                            wrap = false;
                            boolean bl = buffull = MapOutputBuffer.this.bufindex + len > MapOutputBuffer.this.bufstart;
                        }
                        if (MapOutputBuffer.this.kvstart == MapOutputBuffer.this.kvend) {
                            if (MapOutputBuffer.this.kvend != MapOutputBuffer.this.kvindex) {
                                boolean bufsoftlimit;
                                boolean bl = MapOutputBuffer.this.bufindex > MapOutputBuffer.this.bufend ? MapOutputBuffer.this.bufindex - MapOutputBuffer.this.bufend > MapOutputBuffer.this.softBufferLimit : (bufsoftlimit = MapOutputBuffer.this.bufend - MapOutputBuffer.this.bufindex < MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.softBufferLimit);
                                if (bufsoftlimit || buffull && !wrap) {
                                    LOG.info((Object)("Spilling map output: buffer full= " + bufsoftlimit));
                                    MapOutputBuffer.this.startSpill();
                                }
                            } else if (buffull && !wrap) {
                                int size = (MapOutputBuffer.this.bufend <= MapOutputBuffer.this.bufindex ? MapOutputBuffer.this.bufindex - MapOutputBuffer.this.bufend : MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufend + MapOutputBuffer.this.bufindex) + len;
                                MapOutputBuffer.this.bufstart = (MapOutputBuffer.this.bufend = (MapOutputBuffer.this.bufindex = (MapOutputBuffer.this.bufmark = 0)));
                                MapOutputBuffer.this.kvstart = (MapOutputBuffer.this.kvend = (MapOutputBuffer.this.kvindex = 0));
                                MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                                throw new MapBufferTooSmallException(size + " bytes");
                            }
                        }
                        if (!buffull || wrap) continue;
                        try {
                            while (MapOutputBuffer.this.kvstart != MapOutputBuffer.this.kvend) {
                                MapOutputBuffer.this.reporter.progress();
                                MapOutputBuffer.this.spillDone.await();
                            }
                        }
                        catch (InterruptedException e) {
                            throw (IOException)new IOException("Buffer interrupted while waiting for the writer").initCause(e);
                        }
                    } while (buffull && !wrap);
                }
                finally {
                    MapOutputBuffer.this.spillLock.unlock();
                }
                if (buffull) {
                    int gaplen = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufindex;
                    System.arraycopy(b, off, MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufindex, gaplen);
                    len -= gaplen;
                    off += gaplen;
                    MapOutputBuffer.this.bufindex = 0;
                }
                System.arraycopy(b, off, MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufindex, len);
                MapOutputBuffer.this.bufindex += len;
            }
        }

        protected class BlockingBuffer
        extends DataOutputStream {
            public BlockingBuffer() {
                this(mapOutputBuffer.new Buffer());
            }

            private BlockingBuffer(OutputStream out) {
                super(out);
            }

            public int markRecord() {
                MapOutputBuffer.this.bufmark = MapOutputBuffer.this.bufindex;
                return MapOutputBuffer.this.bufindex;
            }

            protected synchronized void reset() throws IOException {
                int headbytelen = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufmark;
                MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.bufmark;
                if (MapOutputBuffer.this.bufindex + headbytelen < MapOutputBuffer.this.bufstart) {
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, 0, MapOutputBuffer.this.kvbuffer, headbytelen, MapOutputBuffer.this.bufindex);
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufvoid, MapOutputBuffer.this.kvbuffer, 0, headbytelen);
                    MapOutputBuffer.this.bufindex += headbytelen;
                } else {
                    byte[] keytmp = new byte[MapOutputBuffer.this.bufindex];
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, 0, keytmp, 0, MapOutputBuffer.this.bufindex);
                    MapOutputBuffer.this.bufindex = 0;
                    this.out.write(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufmark, headbytelen);
                    this.out.write(keytmp);
                }
            }
        }
    }

    class DirectMapOutputCollector<K, V>
    implements MapOutputCollector<K, V> {
        private org.apache.hadoop.mapred.RecordWriter<K, V> out = null;
        private Task.TaskReporter reporter = null;
        private final Counters.Counter mapOutputRecordCounter;
        private final Counters.Counter fileOutputByteCounter;
        private final FileSystem.Statistics fsStats;

        public DirectMapOutputCollector(TaskUmbilicalProtocol umbilical, JobConf job, Task.TaskReporter reporter) throws IOException {
            this.reporter = reporter;
            String finalName = Task.getOutputName(MapTask.this.getPartition());
            FileSystem fs = FileSystem.get(job);
            OutputFormat outputFormat = job.getOutputFormat();
            FileSystem.Statistics matchedStats = null;
            if (outputFormat instanceof org.apache.hadoop.mapred.FileOutputFormat) {
                matchedStats = Task.getFsStatistics(org.apache.hadoop.mapred.FileOutputFormat.getOutputPath(job), job);
            }
            this.fsStats = matchedStats;
            this.mapOutputRecordCounter = reporter.getCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
            this.fileOutputByteCounter = reporter.getCounter((Enum)FileOutputFormat.Counter.BYTES_WRITTEN);
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out = job.getOutputFormat().getRecordWriter(fs, job, finalName, reporter);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                long bytesOutPrev = this.getOutputBytes(this.fsStats);
                this.out.close(this.reporter);
                long bytesOutCurr = this.getOutputBytes(this.fsStats);
                this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            }
        }

        @Override
        public void flush() throws IOException, InterruptedException, ClassNotFoundException {
        }

        @Override
        public void collect(K key, V value, int partition) throws IOException {
            this.reporter.progress();
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out.write(key, value);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            this.mapOutputRecordCounter.increment(1L);
        }

        private long getOutputBytes(FileSystem.Statistics stats) {
            return stats == null ? 0L : stats.getBytesWritten();
        }
    }

    static interface MapOutputCollector<K, V> {
        public void collect(K var1, V var2, int var3) throws IOException, InterruptedException;

        public void close() throws IOException, InterruptedException;

        public void flush() throws IOException, InterruptedException, ClassNotFoundException;
    }

    private class NewOutputCollector<K, V>
    extends RecordWriter<K, V> {
        private final MapOutputCollector<K, V> collector;
        private final org.apache.hadoop.mapreduce.Partitioner<K, V> partitioner;
        private final int partitions;

        NewOutputCollector(JobContext jobContext, JobConf job, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, ClassNotFoundException {
            this.collector = new MapOutputBuffer(umbilical, job, reporter);
            this.partitions = jobContext.getNumReduceTasks();
            this.partitioner = this.partitions > 0 ? ReflectionUtils.newInstance(jobContext.getPartitionerClass(), job) : new org.apache.hadoop.mapreduce.Partitioner<K, V>(){

                @Override
                public int getPartition(K key, V value, int numPartitions) {
                    return -1;
                }
            };
        }

        @Override
        public void write(K key, V value) throws IOException, InterruptedException {
            this.collector.collect(key, value, this.partitioner.getPartition(key, value, this.partitions));
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            try {
                this.collector.flush();
            }
            catch (ClassNotFoundException cnf) {
                throw new IOException("can't find class ", cnf);
            }
            this.collector.close();
        }
    }

    private class NewDirectOutputCollector<K, V>
    extends RecordWriter<K, V> {
        private final RecordWriter out;
        private final Task.TaskReporter reporter;
        private final Counters.Counter mapOutputRecordCounter;
        private final Counters.Counter fileOutputByteCounter;
        private final FileSystem.Statistics fsStats;

        NewDirectOutputCollector(JobContext jobContext, JobConf job, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, ClassNotFoundException, InterruptedException {
            this.reporter = reporter;
            FileSystem.Statistics matchedStats = null;
            if (MapTask.this.outputFormat instanceof FileOutputFormat) {
                matchedStats = Task.getFsStatistics(FileOutputFormat.getOutputPath(jobContext), job);
            }
            this.fsStats = matchedStats;
            this.mapOutputRecordCounter = reporter.getCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
            this.fileOutputByteCounter = reporter.getCounter((Enum)FileOutputFormat.Counter.BYTES_WRITTEN);
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out = MapTask.this.outputFormat.getRecordWriter(MapTask.this.taskContext);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        }

        @Override
        public void write(K key, V value) throws IOException, InterruptedException {
            this.reporter.progress();
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out.write(key, value);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            this.mapOutputRecordCounter.increment(1L);
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.reporter.progress();
            if (this.out != null) {
                long bytesOutPrev = this.getOutputBytes(this.fsStats);
                this.out.close(context);
                long bytesOutCurr = this.getOutputBytes(this.fsStats);
                this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            }
        }

        private long getOutputBytes(FileSystem.Statistics stats) {
            return stats == null ? 0L : stats.getBytesWritten();
        }
    }

    private static class OldOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private final Partitioner<K, V> partitioner;
        private final MapOutputCollector<K, V> collector;
        private final int numPartitions;

        OldOutputCollector(MapOutputCollector<K, V> collector, JobConf conf) {
            this.numPartitions = conf.getNumReduceTasks();
            this.partitioner = this.numPartitions > 0 ? ReflectionUtils.newInstance(conf.getPartitionerClass(), conf) : new Partitioner<K, V>(){

                @Override
                public void configure(JobConf job) {
                }

                @Override
                public int getPartition(K key, V value, int numPartitions) {
                    return -1;
                }
            };
            this.collector = collector;
        }

        @Override
        public void collect(K key, V value) throws IOException {
            try {
                this.collector.collect(key, value, this.partitioner.getPartition(key, value, this.numPartitions));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupt exception", ie);
            }
        }
    }

    static class NewTrackingRecordReader<K, V>
    extends RecordReader<K, V> {
        private final RecordReader<K, V> real;
        private final Counter inputRecordCounter;
        private final Counter fileInputByteCounter;
        private final Task.TaskReporter reporter;
        private InputSplit inputSplit;
        private final JobConf job;
        private final FileSystem.Statistics fsStats;

        NewTrackingRecordReader(InputSplit split, InputFormat inputFormat, Task.TaskReporter reporter, JobConf job, TaskAttemptContext taskContext) throws IOException, InterruptedException {
            this.reporter = reporter;
            this.inputSplit = split;
            this.job = job;
            this.inputRecordCounter = reporter.getCounter((Enum)Task.Counter.MAP_INPUT_RECORDS);
            this.fileInputByteCounter = reporter.getCounter((Enum)FileInputFormat.Counter.BYTES_READ);
            FileSystem.Statistics matchedStats = null;
            if (split instanceof org.apache.hadoop.mapreduce.lib.input.FileSplit) {
                matchedStats = Task.getFsStatistics(((org.apache.hadoop.mapreduce.lib.input.FileSplit)split).getPath(), job);
            }
            this.fsStats = matchedStats;
            long bytesInPrev = this.getInputBytes(this.fsStats);
            this.real = inputFormat.createRecordReader(split, taskContext);
            long bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
        }

        @Override
        public void close() throws IOException {
            long bytesInPrev = this.getInputBytes(this.fsStats);
            this.real.close();
            long bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
        }

        @Override
        public K getCurrentKey() throws IOException, InterruptedException {
            return this.real.getCurrentKey();
        }

        @Override
        public V getCurrentValue() throws IOException, InterruptedException {
            return this.real.getCurrentValue();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return this.real.getProgress();
        }

        @Override
        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            long bytesInPrev = this.getInputBytes(this.fsStats);
            this.real.initialize(split, context);
            long bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
        }

        @Override
        public boolean nextKeyValue() throws IOException, InterruptedException {
            boolean result = false;
            try {
                long bytesInPrev = this.getInputBytes(this.fsStats);
                result = this.real.nextKeyValue();
                long bytesInCurr = this.getInputBytes(this.fsStats);
                if (result) {
                    this.inputRecordCounter.increment(1L);
                    this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
                }
                this.reporter.setProgress(this.getProgress());
            }
            catch (IOException ioe) {
                if (this.inputSplit instanceof FileSplit) {
                    FileSplit fileSplit = (FileSplit)this.inputSplit;
                    LOG.error((Object)("IO error in map input file " + fileSplit.getPath().toString()));
                    throw new IOException("IO error in map input file " + fileSplit.getPath().toString(), ioe);
                }
                throw ioe;
            }
            return result;
        }

        private long getInputBytes(FileSystem.Statistics stats) {
            return stats == null ? 0L : stats.getBytesRead();
        }
    }

    class SkippingRecordReader<K, V>
    extends TrackedRecordReader<K, V> {
        private SortedRanges.SkipRangeIterator skipIt;
        private SequenceFile.Writer skipWriter;
        private boolean toWriteSkipRecs;
        private TaskUmbilicalProtocol umbilical;
        private Counters.Counter skipRecCounter;
        private long recIndex;

        SkippingRecordReader(org.apache.hadoop.mapred.InputSplit split, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException {
            super(split, MapTask.this.conf, reporter);
            this.recIndex = -1L;
            this.umbilical = umbilical;
            this.skipRecCounter = reporter.getCounter((Enum)Task.Counter.MAP_SKIPPED_RECORDS);
            this.toWriteSkipRecs = MapTask.this.toWriteSkipRecs() && SkipBadRecords.getSkipOutputPath(MapTask.this.conf) != null;
            this.skipIt = MapTask.this.getSkipRanges().skipRangeIterator();
        }

        @Override
        public synchronized boolean next(K key, V value) throws IOException {
            if (!this.skipIt.hasNext()) {
                LOG.warn((Object)"Further records got skipped.");
                return false;
            }
            boolean ret = this.moveToNext(key, value);
            long nextRecIndex = this.skipIt.next();
            long skip = 0L;
            while (this.recIndex < nextRecIndex && ret) {
                if (this.toWriteSkipRecs) {
                    this.writeSkippedRec(key, value);
                }
                ret = this.moveToNext(key, value);
                ++skip;
            }
            if (skip > 0L && this.skipIt.skippedAllRanges() && this.skipWriter != null) {
                this.skipWriter.close();
            }
            this.skipRecCounter.increment(skip);
            MapTask.this.reportNextRecordRange(this.umbilical, this.recIndex);
            if (ret) {
                this.incrCounters();
            }
            return ret;
        }

        @Override
        protected synchronized boolean moveToNext(K key, V value) throws IOException {
            ++this.recIndex;
            return super.moveToNext(key, value);
        }

        private void writeSkippedRec(K key, V value) throws IOException {
            if (this.skipWriter == null) {
                Path skipDir = SkipBadRecords.getSkipOutputPath(MapTask.this.conf);
                Path skipFile = new Path(skipDir, MapTask.this.getTaskID().toString());
                this.skipWriter = SequenceFile.createWriter(skipFile.getFileSystem(MapTask.this.conf), (Configuration)MapTask.this.conf, skipFile, this.createKey().getClass(), this.createValue().getClass(), SequenceFile.CompressionType.BLOCK, this.getTaskReporter());
            }
            this.skipWriter.append(key, value);
        }
    }

    class TrackedRecordReader<K, V>
    implements org.apache.hadoop.mapred.RecordReader<K, V> {
        private org.apache.hadoop.mapred.RecordReader<K, V> rawIn;
        private Counters.Counter inputByteCounter;
        private Counters.Counter inputRecordCounter;
        private Counters.Counter fileInputByteCounter;
        private org.apache.hadoop.mapred.InputSplit split;
        private Task.TaskReporter reporter;
        private long beforePos = -1L;
        private long afterPos = -1L;
        private long bytesInPrev = -1L;
        private long bytesInCurr = -1L;
        private final FileSystem.Statistics fsStats;

        TrackedRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Task.TaskReporter reporter) throws IOException {
            this.inputRecordCounter = reporter.getCounter((Enum)Task.Counter.MAP_INPUT_RECORDS);
            this.inputByteCounter = reporter.getCounter((Enum)Task.Counter.MAP_INPUT_BYTES);
            this.fileInputByteCounter = reporter.getCounter((Enum)FileInputFormat.Counter.BYTES_READ);
            FileSystem.Statistics matchedStats = null;
            if (split instanceof FileSplit) {
                matchedStats = Task.getFsStatistics(((FileSplit)split).getPath(), job);
            }
            this.fsStats = matchedStats;
            this.bytesInPrev = this.getInputBytes(this.fsStats);
            this.rawIn = job.getInputFormat().getRecordReader(split, job, reporter);
            this.bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(this.bytesInCurr - this.bytesInPrev);
            this.reporter = reporter;
            this.split = split;
            MapTask.this.conf = job;
        }

        @Override
        public K createKey() {
            return this.rawIn.createKey();
        }

        @Override
        public V createValue() {
            return this.rawIn.createValue();
        }

        @Override
        public synchronized boolean next(K key, V value) throws IOException {
            boolean ret = this.moveToNext(key, value);
            if (ret) {
                this.incrCounters();
            }
            return ret;
        }

        protected void incrCounters() {
            this.inputRecordCounter.increment(1L);
            this.inputByteCounter.increment(this.afterPos - this.beforePos);
            this.fileInputByteCounter.increment(this.bytesInCurr - this.bytesInPrev);
        }

        protected synchronized boolean moveToNext(K key, V value) throws IOException {
            boolean ret = false;
            try {
                this.reporter.setProgress(this.getProgress());
                this.beforePos = this.getPos();
                this.bytesInPrev = this.getInputBytes(this.fsStats);
                ret = this.rawIn.next(key, value);
                this.afterPos = this.getPos();
                this.bytesInCurr = this.getInputBytes(this.fsStats);
            }
            catch (IOException ioe) {
                if (this.split instanceof FileSplit) {
                    LOG.error((Object)("IO error in map input file " + MapTask.this.conf.get("map.input.file")));
                    throw new IOException("IO error in map input file " + MapTask.this.conf.get("map.input.file"), ioe);
                }
                throw ioe;
            }
            return ret;
        }

        @Override
        public long getPos() throws IOException {
            return this.rawIn.getPos();
        }

        @Override
        public void close() throws IOException {
            this.bytesInPrev = this.getInputBytes(this.fsStats);
            this.rawIn.close();
            this.bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(this.bytesInCurr - this.bytesInPrev);
        }

        @Override
        public float getProgress() throws IOException {
            return this.rawIn.getProgress();
        }

        Task.TaskReporter getTaskReporter() {
            return this.reporter;
        }

        private long getInputBytes(FileSystem.Statistics stats) {
            return stats == null ? 0L : stats.getBytesRead();
        }
    }
}

