/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.scala.typeutils.OptionSerializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import scala.Option;

class OptionSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Option<String>, Option<String>> {
    private static final String SPEC_NAME = "scala-option-serializer";

    OptionSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, ScalaOptionSerializerSetup.class, ScalaOptionSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class ScalaOptionSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Option<String>> {
        public TypeSerializer<Option<String>> createUpgradedSerializer() {
            return new OptionSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Matcher<Option<String>> testDataMatcher() {
            return CoreMatchers.is((Object)Option.empty());
        }

        public Matcher<TypeSerializerSchemaCompatibility<Option<String>>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class ScalaOptionSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Option<String>> {
        public TypeSerializer<Option<String>> createPriorSerializer() {
            return new OptionSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Option<String> createTestData() {
            return Option.empty();
        }
    }
}

