/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.flink.api.scala.typeutils.Foo;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001f\t)\u0012J\\:uC:$\u0018.\u0019;j_:,F/\u001b7UKN$(BA\u0002\u0005\u0003%!\u0018\u0010]3vi&d7O\u0003\u0002\u0006\r\u0005)1oY1mC*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'!\tA!\u001e;jY&\u0011QC\u0005\u0002\u000b)\u0016\u001cH\u000fT8hO\u0016\u0014\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003a!Xm\u001d;OKN$X\rZ*dC2\fG+\u001f9f'\u0016\u0014H)\u001a\u000b\u0002=A\u0011q$I\u0007\u0002A)\tQ!\u0003\u0002#A\t!QK\\5uQ\tYB\u0005\u0005\u0002&Q5\taE\u0003\u0002(\u0019\u0005)!.\u001e8ji&\u0011\u0011F\n\u0002\u0005)\u0016\u001cH\u000fC\u0003,\u0001\u0011\u0005Q$A\u000euKN$\u0018I\\8os6|Wo]*dC2\fG+\u001f9f'\u0016\u0014H)\u001a\u0015\u0003U\u0011BQA\f\u0001\u0005\n=\nAd]3sS\u0006d\u0017N_3EKN,'/[1mSj,\u0017J\\:uC:\u001cW-\u0006\u00021gQ\u0011\u0011\u0007\u0010\t\u0003eMb\u0001\u0001B\u00035[\t\u0007QGA\u0001U#\t1\u0014\b\u0005\u0002 o%\u0011\u0001\b\t\u0002\b\u001d>$\b.\u001b8h!\ty\"(\u0003\u0002<A\t\u0019\u0011I\\=\t\u000buj\u0003\u0019A\u0019\u0002\u0011%t7\u000f^1oG\u0016\u0004")
public class InstantiationUtilTest
extends TestLogger {
    @Test
    public void testNestedScalaTypeSerDe() {
        Foo.Bar.Foobar instance = new Foo.Bar.Foobar(42);
        Foo.Bar.Foobar copy = this.serializeDeserializeInstance(instance);
        Assert.assertThat((Object)copy, (Matcher)Matchers.equalTo((Object)instance));
    }

    @Test
    public void testAnonymousScalaTypeSerDe() {
        Foo.FooTrait instance = new Foo.FooTrait(null){
            private final int value;

            public int value() {
                return this.value;
            }

            public int hashCode() {
                return 37 * this.value();
            }

            public boolean equals(Object obj) {
                boolean bl;
                Object object = obj;
                if (object instanceof Foo.FooTrait) {
                    Foo.FooTrait fooTrait = (Foo.FooTrait)object;
                    bl = this.value() == fooTrait.value();
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.value = 41;
            }
        };
        Foo.FooTrait copy = this.serializeDeserializeInstance(instance);
        Assert.assertThat((Object)copy, (Matcher)Matchers.equalTo((Object)instance));
    }

    private <T> T serializeDeserializeInstance(T instance) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InstantiationUtil.serializeObject((OutputStream)baos, instance);
        return (T)InstantiationUtil.deserializeObject((byte[])baos.toByteArray(), (ClassLoader)this.getClass().getClassLoader());
    }
}

