/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.runtime;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTest$;
import org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTestInstance;
import org.apache.flink.api.scala.runtime.WeekDay$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.EitherTypeInfo;
import org.apache.flink.api.scala.typeutils.EnumValueTypeInfo;
import org.apache.flink.api.scala.typeutils.OptionTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.typeutils.ScalaNothingTypeInfo;
import org.apache.flink.api.scala.typeutils.TryTypeInfo;
import org.junit.jupiter.api.Test;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SortedMap;
import scala.collection.SortedMap$;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001f\ty2kY1mCN\u0003XmY5bYRK\b/Z:TKJL\u0017\r\\5{KJ$Vm\u001d;\u000b\u0005\r!\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0019R\"\u0001\n\u000b\u0003\u0015I!\u0001\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u001a\u00015\t!\u0001C\u0003\u001c\u0001\u0011\u0005A$\u0001\u0006uKN$x\n\u001d;j_:$\u0012!\b\t\u0003#yI!a\b\n\u0003\tUs\u0017\u000e\u001e\u0015\u00035\u0005\u0002\"A\t\u0015\u000e\u0003\rR!a\u0002\u0013\u000b\u0005\u00152\u0013a\u00026va&$XM\u001d\u0006\u0003O1\tQA[;oSRL!!K\u0012\u0003\tQ+7\u000f\u001e\u0005\u0006W\u0001!\t\u0001H\u0001\ti\u0016\u001cHoU8nK\"\u0012!&\t\u0005\u0006]\u0001!\t\u0001H\u0001\ti\u0016\u001cHOT8oK\"\u0012Q&\t\u0005\u0006c\u0001!\t\u0001H\u0001\u000bi\u0016\u001cH/R5uQ\u0016\u0014\bF\u0001\u0019\"\u0011\u0015!\u0004\u0001\"\u0001\u001d\u0003!!Xm\u001d;MK\u001a$\bFA\u001a\"\u0011\u00159\u0004\u0001\"\u0001\u001d\u0003%!Xm\u001d;SS\u001eDG\u000f\u000b\u00027C!)!\b\u0001C\u00019\u0005iA/Z:u\u000b:,XNV1mk\u0016D#!O\u0011\t\u000bu\u0002A\u0011\u0001\u000f\u0002\u000fQ,7\u000f\u001e+ss\"\u0012A(\t\u0005\u0006\u0001\u0002!\t\u0001H\u0001\fi\u0016\u001cHoU;dG\u0016\u001c8\u000f\u000b\u0002@C!)1\t\u0001C\u00019\u0005YA/Z:u\r\u0006LG.\u001e:fQ\t\u0011\u0015\u0005C\u0003G\u0001\u0011\u0005A$A\buKN$8\u000b\u001e:j]\u001e\f%O]1zQ\t)\u0015\u0005C\u0003J\u0001\u0011\u0005A$\u0001\u0007uKN$\u0018J\u001c;BeJ\f\u0017\u0010\u000b\u0002IC!)A\n\u0001C\u00019\u00051B/Z:u\u0003J\u0014\u0018-_,ji\"\u001c\u0015m]3DY\u0006\u001c8\u000f\u000b\u0002LC!)q\n\u0001C\u00019\u0005iA/Z:u'>\u0014H/\u001a3NCBD#AT\u0011\t\u000bI\u0003A\u0011\u0001\u000f\u0002\u001bQ,7\u000f^*peR,GmU3uQ\t\t\u0016\u0005C\u0003V\u0001\u00115a+\u0001\u0005sk:$Vm\u001d;t+\t9V\r\u0006\u0002Y]R\u0011Q$\u0017\u0005\b5R\u000b\t\u0011q\u0001\\\u0003))g/\u001b3f]\u000e,G%\r\t\u00049\u0006\u001cW\"A/\u000b\u0005y{\u0016\u0001\u0003;za\u0016LgNZ8\u000b\u0005\u00014\u0011AB2p[6|g.\u0003\u0002c;\nyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0005\u0002eK2\u0001A!\u00024U\u0005\u00049'!\u0001+\u0012\u0005!\\\u0007CA\tj\u0013\tQ'CA\u0004O_RD\u0017N\\4\u0011\u0005Ea\u0017BA7\u0013\u0005\r\te.\u001f\u0005\u0006_R\u0003\r\u0001]\u0001\nS:\u001cH/\u00198dKN\u00042!E9d\u0013\t\u0011(CA\u0003BeJ\f\u0017\u0010")
public class ScalaSpecialTypesSerializerTest {
    @Test
    public void testOption() {
        Option[] testData = (Option[])((Object[])new Option[]{new Some((Object)"Hello"), new Some((Object)"Ciao"), None$.MODULE$});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testSome() {
        Some[] testData = (Some[])((Object[])new Some[]{new Some((Object)"Hello"), new Some((Object)"Ciao")});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testNone() {
        None$[] testData = (None$[])((Object[])new None$[]{None$.MODULE$, None$.MODULE$});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testEither() {
        Either[] testData = (Either[])((Object[])new Either[]{package$.MODULE$.Left().apply((Object)"Hell"), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)3))});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Either.class, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)));
    }

    @Test
    public void testLeft() {
        Left[] testData = (Left[])((Object[])new Left[]{package$.MODULE$.Left().apply((Object)"Hell"), package$.MODULE$.Left().apply((Object)"CIao")});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Left.class, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), (TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testRight() {
        Right[] testData = (Right[])((Object[])new Right[]{package$.MODULE$.Right().apply((Object)"Hell"), package$.MODULE$.Right().apply((Object)"CIao")});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Right.class, (TypeInformation)new ScalaNothingTypeInfo(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testEnumValue() {
        Enumeration.Value[] testData = (Enumeration.Value[])((Object[])new Enumeration.Value[]{WeekDay$.MODULE$.Mon(), WeekDay$.MODULE$.Fri(), WeekDay$.MODULE$.Tue(), WeekDay$.MODULE$.Sun(), WeekDay$.MODULE$.Wed()});
        this.runTests(testData, (TypeInformation)new EnumValueTypeInfo((Enumeration)WeekDay$.MODULE$, Enumeration.Value.class));
    }

    @Test
    public void testTry() {
        Try[] testData = (Try[])((Object[])new Try[]{new Success((Object)"Hell"), new Failure((Throwable)new RuntimeException("test"))});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testSuccess() {
        Success[] testData = (Success[])((Object[])new Success[]{new Success((Object)"Hell"), new Success((Object)"Yeah")});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testFailure() {
        Failure[] testData = (Failure[])((Object[])new Failure[]{new Failure((Throwable)new RuntimeException("test")), new Failure((Throwable)new RuntimeException("one, two"))});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testStringArray() {
        String[][] testData = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"Foo", "Bar"}), (String[])((Object[])new String[]{"Hello"})});
        this.runTests(testData, (TypeInformation)BasicArrayTypeInfo.getInfoFor(String[].class));
    }

    @Test
    public void testIntArray() {
        int[][] testData = (int[][])((Object[])new int[][]{{1, 3, 3, 7}, {4, 7}});
        this.runTests(testData, (TypeInformation)PrimitiveArrayTypeInfo.getInfoFor(int[].class));
    }

    @Test
    public void testArrayWithCaseClass() {
        Object object;
        CaseClassTypeInfo<Tuple2<Object, String>> elementType;
        Tuple2[][] testData = (Tuple2[][])((Object[])new Tuple2[][]{(Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"String"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"Foo")}), (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)"String"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"Foo")})});
        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo = elementType = new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo2 = caseClassTypeInfo;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(caseClassTypeInfo2) : caseClassTypeInfo2 != null)) {
            object = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.BYTE_TYPE_INFO;
            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo3 = caseClassTypeInfo;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(caseClassTypeInfo3) : caseClassTypeInfo3 != null)) {
                object = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            } else {
                BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.CHAR_TYPE_INFO;
                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo4 = caseClassTypeInfo;
                if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(caseClassTypeInfo4) : caseClassTypeInfo4 != null)) {
                    object = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo5 = caseClassTypeInfo;
                    if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(caseClassTypeInfo5) : caseClassTypeInfo5 != null)) {
                        object = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.FLOAT_TYPE_INFO;
                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo6 = caseClassTypeInfo;
                        if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(caseClassTypeInfo6) : caseClassTypeInfo6 != null)) {
                            object = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.INT_TYPE_INFO;
                            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo7 = caseClassTypeInfo;
                            if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(caseClassTypeInfo7) : caseClassTypeInfo7 != null)) {
                                object = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.LONG_TYPE_INFO;
                                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo8 = caseClassTypeInfo;
                                if (!(basicTypeInfo7 != null ? !basicTypeInfo7.equals(caseClassTypeInfo8) : caseClassTypeInfo8 != null)) {
                                    object = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo8 = BasicTypeInfo.SHORT_TYPE_INFO;
                                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo9 = caseClassTypeInfo;
                                    if (!(basicTypeInfo8 != null ? !basicTypeInfo8.equals(caseClassTypeInfo9) : caseClassTypeInfo9 != null)) {
                                        object = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo9 = BasicTypeInfo.STRING_TYPE_INFO;
                                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo10 = caseClassTypeInfo;
                                        object = !(basicTypeInfo9 != null ? !basicTypeInfo9.equals(caseClassTypeInfo10) : caseClassTypeInfo10 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        PrimitiveArrayTypeInfo result = object;
        this.runTests(testData, (TypeInformation)result);
    }

    @Test
    public void testSortedMap() {
        SortedMap[] testData = (SortedMap[])((Object[])new SortedMap[]{SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Hello"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"World"), (Object)BoxesRunTime.boxToInteger((int)2))}), (Ordering)Ordering.String$.MODULE$), SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Foo"), (Object)BoxesRunTime.boxToInteger((int)42))}), (Ordering)Ordering.String$.MODULE$)});
        this.runTests(testData, TypeExtractor.createTypeInfo(SortedMap.class));
    }

    @Test
    public void testSortedSet() {
        SortedSet[] testData = (SortedSet[])((Object[])new SortedSet[]{SortedSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), (Ordering)Ordering.Int$.MODULE$), SortedSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}), (Ordering)Ordering.Int$.MODULE$)});
        this.runTests(testData, TypeExtractor.createTypeInfo(SortedSet.class));
    }

    private final <T> void runTests(Object instances, TypeInformation<T> evidence$1) {
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
        TypeSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
        Class typeClass = typeInfo.getTypeClass();
        ScalaSpecialTypesSerializerTestInstance test = new ScalaSpecialTypesSerializerTestInstance(serializer, typeClass, serializer.getLength(), instances);
        test.testAll();
    }
}

