/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.io.PojoCsvInputFormat;
import org.apache.flink.api.java.io.TupleCsvInputFormat;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.io.CsvInputFormatTest$;
import org.apache.flink.api.scala.io.TwitterPOJO;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-f\u0001B\u0001\u0003\u0001=\u0011!cQ:w\u0013:\u0004X\u000f\u001e$pe6\fG\u000fV3ti*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u001dA\u0011aA1qS*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0014\u001b\u0005\u0011\"\"A\u0003\n\u0005Q\u0011\"AB!osJ+g\rC\u0003\u0017\u0001\u0011\u0005q#\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0005!91\u0004\u0001b\u0001\n\u001ba\u0012\u0001\u0002)B)\"+\u0012!\b\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\n!AZ:\u000b\u0005\tB\u0011\u0001B2pe\u0016L!\u0001J\u0010\u0003\tA\u000bG\u000f\u001b\u0005\u0007M\u0001\u0001\u000bQB\u000f\u0002\u000bA\u000bE\u000b\u0013\u0011\t\u000f!\u0002!\u0019!C\u0007S\u0005Qa)\u0013*T)~\u0003\u0016I\u0015+\u0016\u0003)\u0002\"a\u000b\u001a\u000f\u00051\u0002\u0004CA\u0017\u0013\u001b\u0005q#BA\u0018\u000f\u0003\u0019a$o\\8u}%\u0011\u0011GE\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u00022%!1a\u0007\u0001Q\u0001\u000e)\n1BR%S'R{\u0006+\u0011*UA!9\u0001\b\u0001b\u0001\n\u001bI\u0013aC*F\u0007>sEi\u0018)B%RCaA\u000f\u0001!\u0002\u001bQ\u0013\u0001D*F\u0007>sEi\u0018)B%R\u0003\u0003\"\u0002\u001f\u0001\t\u0003i\u0014AH5h]>\u0014XmU5oO2,7\t[1s!J,g-\u001b=D_6lWM\u001c;t)\u0005q\u0004CA\t@\u0013\t\u0001%C\u0001\u0003V]&$\bFA\u001eC!\t\u0019e)D\u0001E\u0015\t)E\"A\u0003kk:LG/\u0003\u0002H\t\n!A+Z:u\u0011\u0015I\u0005\u0001\"\u0001>\u0003uIwM\\8sK6+H\u000e^5DQ\u0006\u0014\bK]3gSb\u001cu.\\7f]R\u001c\bF\u0001%C\u0011\u0015a\u0005\u0001\"\u0001>\u0003A\u0011X-\u00193TiJLgn\u001a$jK2$7\u000f\u000b\u0002L\u0005\")q\n\u0001C\u0001{\u0005Y\"/Z1e\u001b&DX\rZ)v_R,Gm\u0015;sS:<g)[3mIND#A\u0014\"\t\u000bI\u0003A\u0011A\u001f\u0002MI,\u0017\rZ*ue&twMR5fY\u0012\u001cx+\u001b;i)J\f\u0017\u000e\\5oO\u0012+G.[7ji\u0016\u00148\u000f\u000b\u0002R\u0005\")Q\u000b\u0001C\u0001{\u0005\tB/Z:u\u0013:$XmZ3s\r&,G\u000eZ:)\u0005Q\u0013\u0005\"\u0002-\u0001\t\u0003i\u0014A\u0004;fgR\u0014V-\u00193GSJ\u001cHO\u0014\u0015\u0003/\nCQa\u0017\u0001\u0005\u0002u\n\u0001\u0005^3tiJ+\u0017\rZ*qCJ\u001cXmV5uQB{7/\u001b;j_:\u001cV\r\u001e;fe\"\u0012!L\u0011\u0005\u0006=\u0002!IaX\u0001\u000fGJ,\u0017\r^3UK6\u0004h)\u001b7f)\t\u00017\r\u0005\u0002\u001fC&\u0011!m\b\u0002\u000f\r&dW-\u00138qkR\u001c\u0006\u000f\\5u\u0011\u0015!W\f1\u0001+\u0003\u001d\u0019wN\u001c;f]RDQA\u001a\u0001\u0005\u0002u\n\u0011\u0004^3ti^Kg\u000eZ8xg2Kg.Z#oIJ+Wn\u001c<bY\"\u0012QM\u0011\u0005\u0006S\u0002!IA[\u0001\u0017i\u0016\u001cHOU3n_ZLgn\u001a+sC&d\u0017N\\4D%R\u0019ah[7\t\u000b1D\u0007\u0019\u0001\u0016\u0002#1Lg.\u001a\"sK\u0006\\WM]%o\r&dW\rC\u0003oQ\u0002\u0007!&\u0001\tmS:,'I]3bW\u0016\u00148+\u001a;va\u001a!\u0001\u000f\u0001\u0001r\u0005!\u0001vJS(Ji\u0016l7CA8\u0011\u0011!\u0019xN!a\u0001\n\u0003!\u0018A\u00024jK2$\u0017'F\u0001v!\t\tb/\u0003\u0002x%\t\u0019\u0011J\u001c;\t\u0011e|'\u00111A\u0005\u0002i\f!BZ5fY\u0012\ft\fJ3r)\tq4\u0010C\u0004}q\u0006\u0005\t\u0019A;\u0002\u0007a$\u0013\u0007\u0003\u0005\u007f_\n\u0005\t\u0015)\u0003v\u0003\u001d1\u0017.\u001a7ec\u0001B\u0011\"!\u0001p\u0005\u0003\u0007I\u0011A\u0015\u0002\r\u0019LW\r\u001c33\u0011)\t)a\u001cBA\u0002\u0013\u0005\u0011qA\u0001\u000bM&,G\u000e\u001a\u001a`I\u0015\fHc\u0001 \u0002\n!AA0a\u0001\u0002\u0002\u0003\u0007!\u0006C\u0005\u0002\u000e=\u0014\t\u0011)Q\u0005U\u00059a-[3mIJ\u0002\u0003BCA\t_\n\u0005\r\u0011\"\u0001\u0002\u0014\u00051a-[3mIN*\"!!\u0006\u0011\u0007E\t9\"C\u0002\u0002\u001aI\u0011a\u0001R8vE2,\u0007BCA\u000f_\n\u0005\r\u0011\"\u0001\u0002 \u0005Qa-[3mINzF%Z9\u0015\u0007y\n\t\u0003C\u0005}\u00037\t\t\u00111\u0001\u0002\u0016!Q\u0011QE8\u0003\u0002\u0003\u0006K!!\u0006\u0002\u000f\u0019LW\r\u001c34A!1ac\u001cC\u0001\u0003S!\u0002\"a\u000b\u00020\u0005E\u00121\u0007\t\u0004\u0003[yW\"\u0001\u0001\t\rM\f9\u00031\u0001v\u0011\u001d\t\t!a\nA\u0002)B\u0001\"!\u0005\u0002(\u0001\u0007\u0011Q\u0003\u0005\u0007-=$\t!a\u000e\u0015\u0005\u0005-\u0002bBA\u001e\u0001\u0011%\u0011QH\u0001\u0011m\u0006d\u0017\u000eZ1uKB{%jT%uK6$2APA \u0011!\t\t%!\u000fA\u0002\u0005\r\u0013A\u00024pe6\fG\u000f\u0005\u0004\u0002F\u00055\u00131F\u0007\u0003\u0003\u000fR1aAA%\u0015\r\tYEB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002P\u0005\u001d#A\u0005)pU>\u001c5O^%oaV$hi\u001c:nCRDq!a\u0015\u0001\t\u0013\t)&A\u000bwC2LG-\u0019;f\u0007\u0006\u001cXm\u00117bgNLE/Z7\u0015\u0007y\n9\u0006\u0003\u0005\u0002B\u0005E\u0003\u0019AA-!\u0019\t)%a\u0017\u0002`%!\u0011QLA$\u0005M!V\u000f\u001d7f\u0007N4\u0018J\u001c9vi\u001a{'/\\1u!\u0011\t\t'!#\u000f\t\u0005\r\u00141\u0010\b\u0005\u0003K\nIH\u0004\u0003\u0002h\u0005]d\u0002BA5\u0003krA!a\u001b\u0002t9!\u0011QNA9\u001d\ri\u0013qN\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u001d\tiH\u0001E\u0001\u0003\u007f\n!cQ:w\u0013:\u0004X\u000f\u001e$pe6\fG\u000fV3tiB\u0019\u0011$!!\u0007\r\u0005\u0011\u0001\u0012AAB'\r\t\t\t\u0005\u0005\b-\u0005\u0005E\u0011AAD)\t\tyHB\u0004\u0002\f\u0006\u0005\u0005)!$\u0003\u001b\r\u000b7/Z\"mCN\u001c\u0018\n^3n'\u001d\tI\tEAH\u0003+\u00032!EAI\u0013\r\t\u0019J\u0005\u0002\b!J|G-^2u!\r\t\u0012qS\u0005\u0004\u00033\u0013\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"C:\u0002\n\nU\r\u0011\"\u0001u\u0011%q\u0018\u0011\u0012B\tB\u0003%Q\u000f\u0003\u0006\u0002\u0002\u0005%%Q3A\u0005\u0002%B!\"!\u0004\u0002\n\nE\t\u0015!\u0003+\u0011-\t\t\"!#\u0003\u0016\u0004%\t!a\u0005\t\u0017\u0005\u0015\u0012\u0011\u0012B\tB\u0003%\u0011Q\u0003\u0005\b-\u0005%E\u0011AAU)!\tY+a,\u00022\u0006M\u0006\u0003BAW\u0003\u0013k!!!!\t\rM\f9\u000b1\u0001v\u0011\u001d\t\t!a*A\u0002)B\u0001\"!\u0005\u0002(\u0002\u0007\u0011Q\u0003\u0005\u000b\u0003o\u000bI)!A\u0005\u0002\u0005e\u0016\u0001B2paf$\u0002\"a+\u0002<\u0006u\u0016q\u0018\u0005\tg\u0006U\u0006\u0013!a\u0001k\"I\u0011\u0011AA[!\u0003\u0005\rA\u000b\u0005\u000b\u0003#\t)\f%AA\u0002\u0005U\u0001BCAb\u0003\u0013\u000b\n\u0011\"\u0001\u0002F\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAdU\r)\u0018\u0011Z\u0016\u0003\u0003\u0017\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001b\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0006='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011Q\\AE#\u0003%\t!a8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001d\u0016\u0004U\u0005%\u0007BCAs\u0003\u0013\u000b\n\u0011\"\u0001\u0002h\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAuU\u0011\t)\"!3\t\u0015\u00055\u0018\u0011RA\u0001\n\u0003\ny/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003c\u0004B!a=\u0002|6\u0011\u0011Q\u001f\u0006\u0005\u0003o\fI0\u0001\u0003mC:<'BAA&\u0013\r\u0019\u0014Q\u001f\u0005\n\u0003\u007f\fI)!A\u0005\u0002Q\fA\u0002\u001d:pIV\u001cG/\u0011:jifD!Ba\u0001\u0002\n\u0006\u0005I\u0011\u0001B\u0003\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0002\u0003\u000eA\u0019\u0011C!\u0003\n\u0007\t-!CA\u0002B]fD\u0001\u0002 B\u0001\u0003\u0003\u0005\r!\u001e\u0005\u000b\u0005#\tI)!A\u0005B\tM\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tU\u0001C\u0002B\f\u0005;\u00119!\u0004\u0002\u0003\u001a)\u0019!1\u0004\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003 \te!\u0001C%uKJ\fGo\u001c:\t\u0015\t\r\u0012\u0011RA\u0001\n\u0003\u0011)#\u0001\u0005dC:,\u0015/^1m)\u0011\u00119C!\f\u0011\u0007E\u0011I#C\u0002\u0003,I\u0011qAQ8pY\u0016\fg\u000eC\u0005}\u0005C\t\t\u00111\u0001\u0003\b!Q!\u0011GAE\u0003\u0003%\tEa\r\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\u001e\u0005\u000b\u0005o\tI)!A\u0005B\te\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\bB\u0003B\u001f\u0003\u0013\u000b\t\u0011\"\u0011\u0003@\u00051Q-];bYN$BAa\n\u0003B!IAPa\u000f\u0002\u0002\u0003\u0007!qA\u0004\u000b\u0005\u000b\n\t)!A\t\u0002\t\u001d\u0013!D\"bg\u0016\u001cE.Y:t\u0013R,W\u000e\u0005\u0003\u0002.\n%cACAF\u0003\u0003\u000b\t\u0011#\u0001\u0003LM1!\u0011\nB'\u0003+\u0003\"Ba\u0014\u0003VUT\u0013QCAV\u001b\t\u0011\tFC\u0002\u0003TI\tqA];oi&lW-\u0003\u0003\u0003X\tE#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9aC!\u0013\u0005\u0002\tmCC\u0001B$\u0011)\u00119D!\u0013\u0002\u0002\u0013\u0015#\u0011\b\u0005\u000b\u0005C\u0012I%!A\u0005\u0002\n\r\u0014!B1qa2LH\u0003CAV\u0005K\u00129G!\u001b\t\rM\u0014y\u00061\u0001v\u0011\u001d\t\tAa\u0018A\u0002)B\u0001\"!\u0005\u0003`\u0001\u0007\u0011Q\u0003\u0005\u000b\u0005[\u0012I%!A\u0005\u0002\n=\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005c\u0012i\bE\u0003\u0012\u0005g\u00129(C\u0002\u0003vI\u0011aa\u00149uS>t\u0007cB\t\u0003zUT\u0013QC\u0005\u0004\u0005w\u0012\"A\u0002+va2,7\u0007\u0003\u0006\u0003\u0000\t-\u0014\u0011!a\u0001\u0003W\u000b1\u0001\u001f\u00131\u0011)\u0011\u0019I!\u0013\u0002\u0002\u0013%!QQ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\bB!\u00111\u001fBE\u0013\u0011\u0011Y)!>\u0003\r=\u0013'.Z2u\u0011\u0019\u0011y\t\u0001C\u0001{\u0005aA/Z:u!>Su\nV=qK\"\u001a!Q\u0012\"\t\r\tU\u0005\u0001\"\u0001>\u00035!Xm\u001d;DCN,7\t\\1tg\"\u001a!1\u0013\"\t\r\tm\u0005\u0001\"\u0001>\u0003q!Xm\u001d;Q\u001f*{E+\u001f9f/&$\bNR5fY\u0012l\u0015\r\u001d9j]\u001eD3A!'C\u0011\u0019\u0011\t\u000b\u0001C\u0001{\u0005AC/Z:u!>Su\nV=qK^KG\u000f\u001b$jK2$7+\u001e2tKR\fe\u000e\u001a#bi\u0006\u001cVOY:fi\"\u001a!q\u0014\"\t\r\t\u001d\u0006\u0001\"\u0001>\u0003Q!Xm\u001d;Q\u001f*{5+\u001e2dY\u0006\u001c8\u000fV=qK\"\u001a!Q\u0015\"")
public class CsvInputFormatTest {
    private final Path PATH = new Path("an/ignored/file/");
    private final String FIRST_PART;
    private final String SECOND_PART;

    private final Path PATH() {
        return this.PATH;
    }

    private final String FIRST_PART() {
        return this.FIRST_PART;
    }

    private final String SECOND_PART() {
        return this.SECOND_PART;
    }

    @Test
    public void ignoreSingleCharPrefixComments() {
        try {
            String fileContent = "#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple3<String, Integer, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<String, Integer, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<String, Integer, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Integer, Object>>(this, fieldSerializers){

                        public Tuple3<String, Integer, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)((String)fields[0]), (Object)((Integer)fields[1]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            format.setDelimiter("\n");
            format.setFieldDelimiter("|");
            format.setCommentPrefix("#");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = null;
            result = (Tuple3)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result._1());
            Assert.assertEquals((Object)new Integer(1), (Object)result._2());
            Assert.assertEquals((double)2.0, (double)BoxesRunTime.unboxToDouble((Object)result._3()), (double)1.0E-4);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result._1());
            Assert.assertEquals((Object)new Integer(3), (Object)result._2());
            Assert.assertEquals((double)4.0, (double)BoxesRunTime.unboxToDouble((Object)result._3()), (double)1.0E-4);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    @Test
    public void ignoreMultiCharPrefixComments() {
        try {
            String fileContent = "//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple3<String, Integer, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<String, Integer, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<String, Integer, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Integer, Object>>(this, fieldSerializers){

                        public Tuple3<String, Integer, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)((String)fields[0]), (Object)((Integer)fields[1]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            format.setDelimiter("\n");
            format.setFieldDelimiter("|");
            format.setCommentPrefix("//");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = null;
            result = (Tuple3)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result._1());
            Assert.assertEquals((Object)new Integer(1), (Object)result._2());
            Assert.assertEquals((double)2.0, (double)BoxesRunTime.unboxToDouble((Object)result._3()), (double)1.0E-4);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result._1());
            Assert.assertEquals((Object)new Integer(3), (Object)result._2());
            Assert.assertEquals((double)4.0, (double)BoxesRunTime.unboxToDouble((Object)result._3()), (double)1.0E-4);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    @Test
    public void readStringFields() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                        public Tuple3<String, String, String> createInstance(Object[] fields) {
                            return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            format.setDelimiter("\n");
            format.setFieldDelimiter("|");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = null;
            result = (Tuple3)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result._1());
            Assert.assertEquals((Object)"def", (Object)result._2());
            Assert.assertEquals((Object)"ghijk", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result._1());
            Assert.assertEquals((Object)"", (Object)result._2());
            Assert.assertEquals((Object)"hhg", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result._1());
            Assert.assertEquals((Object)"", (Object)result._2());
            Assert.assertEquals((Object)"", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    @Test
    public void readMixedQuotedStringFields() {
        try {
            String fileContent = "abc|\"de|f\"|ghijk\n\"a|bc\"||hhg\n|||";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                        public Tuple3<String, String, String> createInstance(Object[] fields) {
                            return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            format.setDelimiter("\n");
            format.enableQuotedStringParsing('\"');
            format.setFieldDelimiter("|");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = null;
            result = (Tuple3)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result._1());
            Assert.assertEquals((Object)"de|f", (Object)result._2());
            Assert.assertEquals((Object)"ghijk", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a|bc", (Object)result._1());
            Assert.assertEquals((Object)"", (Object)result._2());
            Assert.assertEquals((Object)"hhg", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result._1());
            Assert.assertEquals((Object)"", (Object)result._2());
            Assert.assertEquals((Object)"", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    @Test
    public void readStringFieldsWithTrailingDelimiters() {
        try {
            String fileContent = "abc|-def|-ghijk\nabc|-|-hhg\n|-|-|-\n";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<String, String, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                        public Tuple3<String, String, String> createInstance(Object[] fields) {
                            return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            format.setDelimiter("\n");
            format.setFieldDelimiter("|-");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = null;
            result = (Tuple3)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result._1());
            Assert.assertEquals((Object)"def", (Object)result._2());
            Assert.assertEquals((Object)"ghijk", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result._1());
            Assert.assertEquals((Object)"", (Object)result._2());
            Assert.assertEquals((Object)"hhg", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result._1());
            Assert.assertEquals((Object)"", (Object)result._2());
            Assert.assertEquals((Object)"", (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    @Test
    public void testIntegerFields() {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|\n";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple5<Object, Object, Object, Object, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple5<Object, Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, Object, Object, Object>>(this, fieldSerializers){

                        public Tuple5<Object, Object, Object, Object, Object> createInstance(Object[] fields) {
                            return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple5 result = null;
            result = (Tuple5)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result._1());
            Assert.assertEquals((Object)222, (Object)result._2());
            Assert.assertEquals((Object)333, (Object)result._3());
            Assert.assertEquals((Object)444, (Object)result._4());
            Assert.assertEquals((Object)555, (Object)result._5());
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)666, (Object)result._1());
            Assert.assertEquals((Object)777, (Object)result._2());
            Assert.assertEquals((Object)888, (Object)result._3());
            Assert.assertEquals((Object)999, (Object)result._4());
            Assert.assertEquals((Object)0, (Object)result._5());
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    @Test
    public void testReadFirstN() {
        try {
            String fileContent = "111|x|222|x|333|x|444|x|555|x|\n666|x|777|x|888|x|999|x|000|x|\n";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            format.setFieldDelimiter("|x|");
            format.configure(new Configuration());
            format.open(split);
            Tuple2 result = null;
            result = (Tuple2)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)BoxesRunTime.boxToInteger((int)result._1$mcI$sp()));
            Assert.assertEquals((Object)222, (Object)BoxesRunTime.boxToInteger((int)result._2$mcI$sp()));
            result = (Tuple2)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)666, (Object)BoxesRunTime.boxToInteger((int)result._1$mcI$sp()));
            Assert.assertEquals((Object)777, (Object)BoxesRunTime.boxToInteger((int)result._2$mcI$sp()));
            result = (Tuple2)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    @Test
    public void testReadSparseWithPositionSetter() {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile(fileContent);
            TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                        public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            }, new int[]{0, 3, 7});
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = null;
            result = (Tuple3)format.nextRecord(result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result._1());
            Assert.assertEquals((Object)444, (Object)result._2());
            Assert.assertEquals((Object)888, (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)0, (Object)result._1());
            Assert.assertEquals((Object)777, (Object)result._2());
            Assert.assertEquals((Object)333, (Object)result._3());
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)new StringBuilder(23).append("Test failed due to a ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        }
    }

    private FileInputSplit createTempFile(String content) {
        File tempFile = File.createTempFile("test_contents", "tmp");
        tempFile.deleteOnExit();
        FileWriter wrt = new FileWriter(tempFile);
        wrt.write(content);
        wrt.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), (String[])((Object[])new String[]{"localhost"}));
    }

    @Test
    public void testWindowsLineEndRemoval() {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\r\n");
        this.testRemovingTrailingCR("\r\n", "\n");
    }

    private void testRemovingTrailingCR(String lineBreakerInFile, String lineBreakerSetup) {
        File tempFile = null;
        String fileContent = new StringBuilder(0).append(this.FIRST_PART()).append(lineBreakerInFile).append(this.SECOND_PART()).append(lineBreakerInFile).toString();
        try {
            tempFile = File.createTempFile("CsvInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
            wrt.write(fileContent);
            wrt.close();
            TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(new Path(tempFile.toURI().toString()), (TupleTypeInfoBase)new CaseClassTypeInfo<Tuple1<String>>(null){

                public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple1<String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<Tuple1<String>> unused = new ScalaCaseClassSerializer<Tuple1<String>>(this, fieldSerializers){

                        public Tuple1<String> createInstance(Object[] fields) {
                            return new Tuple1((Object)((String)fields[0]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            });
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            inputFormat.setDelimiter(lineBreakerSetup);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            inputFormat.open(splits[0]);
            Tuple1 result = (Tuple1)inputFormat.nextRecord(null);
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)this.FIRST_PART(), (Object)result._1());
            result = (Tuple1)inputFormat.nextRecord((Object)result);
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)this.SECOND_PART(), (Object)result._1());
        }
        catch (Throwable t) {
            System.err.println(new StringBuilder(28).append("test failed with exception: ").append(t.getMessage()).toString());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }

    private void validatePOJOItem(PojoCsvInputFormat<POJOItem> format) {
        POJOItem result = new POJOItem(this);
        result = (POJOItem)format.nextRecord((Object)result);
        Assert.assertEquals((long)123L, (long)result.field1());
        Assert.assertEquals((Object)"HELLO", (Object)result.field2());
        Assert.assertEquals((double)3.123, (double)result.field3(), (double)0.001);
        result = (POJOItem)format.nextRecord((Object)result);
        Assert.assertEquals((long)456L, (long)result.field1());
        Assert.assertEquals((Object)"ABC", (Object)result.field2());
        Assert.assertEquals((double)1.234, (double)result.field3(), (double)0.001);
    }

    private void validateCaseClassItem(TupleCsvInputFormat<CaseClassItem> format) {
        CaseClassItem result = (CaseClassItem)format.nextRecord(null);
        Assert.assertEquals((long)123L, (long)result.field1());
        Assert.assertEquals((Object)"HELLO", (Object)result.field2());
        Assert.assertEquals((double)3.123, (double)result.field3(), (double)0.001);
        result = (CaseClassItem)format.nextRecord(null);
        Assert.assertEquals((long)456L, (long)result.field1());
        Assert.assertEquals((Object)"ABC", (Object)result.field2());
        Assert.assertEquals((double)1.234, (double)result.field3(), (double)0.001);
    }

    @Test
    public void testPOJOType() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String fileContent = "123,HELLO,3.123\n456,ABC,1.234";
        FileInputSplit tempFile = this.createTempFile(fileContent);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"field3", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"field2", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)new .colon.colon((Object)new Tuple2((Object)"field1", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$1.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        PojoTypeInfo typeInfo = (PojoTypeInfo)genericTypeInfo;
        PojoCsvInputFormat format = new PojoCsvInputFormat(this.PATH(), typeInfo);
        format.setDelimiter('\n');
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(tempFile);
        this.validatePOJOItem((PojoCsvInputFormat<POJOItem>)format);
    }

    @Test
    public void testCaseClass() {
        String fileContent = "123,HELLO,3.123\n456,ABC,1.234";
        FileInputSplit tempFile = this.createTempFile(fileContent);
        CaseClassTypeInfo<CaseClassItem> typeInfo = new CaseClassTypeInfo<CaseClassItem>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CaseClassItem> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<CaseClassItem> unused = new ScalaCaseClassSerializer<CaseClassItem>(this, fieldSerializers){

                    public CaseClassItem createInstance(Object[] fields) {
                        return new CaseClassItem(BoxesRunTime.unboxToInt((Object)fields[0]), (String)fields[1], BoxesRunTime.unboxToDouble((Object)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.api.scala.io.CsvInputFormatTest$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        TupleCsvInputFormat format = new TupleCsvInputFormat(this.PATH(), (TupleTypeInfoBase)typeInfo);
        format.setDelimiter('\n');
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(tempFile);
        this.validateCaseClassItem((TupleCsvInputFormat<CaseClassItem>)format);
    }

    @Test
    public void testPOJOTypeWithFieldMapping() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String fileContent = "HELLO,123,3.123\nABC,456,1.234";
        FileInputSplit tempFile = this.createTempFile(fileContent);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"field3", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"field2", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)new .colon.colon((Object)new Tuple2((Object)"field1", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$2.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        PojoTypeInfo typeInfo = (PojoTypeInfo)genericTypeInfo;
        PojoCsvInputFormat format = new PojoCsvInputFormat(this.PATH(), typeInfo, (String[])((Object[])new String[]{"field2", "field1", "field3"}));
        format.setDelimiter('\n');
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(tempFile);
        this.validatePOJOItem((PojoCsvInputFormat<POJOItem>)format);
    }

    @Test
    public void testPOJOTypeWithFieldSubsetAndDataSubset() {
        GenericTypeInfo genericTypeInfo;
        Class<POJOItem> clazz;
        String fileContent = "HELLO,123,NODATA,3.123,NODATA\nABC,456,NODATA,1.234,NODATA";
        FileInputSplit tempFile = this.createTempFile(fileContent);
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"field3", (Object)BasicTypeInfo.getInfoFor(Double.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"field2", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)new .colon.colon((Object)new Tuple2((Object)"field1", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)Nil$.MODULE$)));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = POJOItem.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$3.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        PojoTypeInfo typeInfo = (PojoTypeInfo)genericTypeInfo;
        PojoCsvInputFormat format = new PojoCsvInputFormat(this.PATH(), typeInfo, (String[])((Object[])new String[]{"field2", "field1", "field3"}), new boolean[]{true, true, false, true, false});
        format.setDelimiter('\n');
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(tempFile);
        this.validatePOJOItem((PojoCsvInputFormat<POJOItem>)format);
    }

    @Test
    public void testPOJOSubclassType() {
        String fileContent = "t1,foobar,tweet2\nt2,barfoo,tweet2";
        FileInputSplit tempFile = this.createTempFile(fileContent);
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(TwitterPOJO.class);
        PojoCsvInputFormat format = new PojoCsvInputFormat(this.PATH(), typeInfo);
        format.setDelimiter('\n');
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(tempFile);
        TwitterPOJO[] expected = (TwitterPOJO[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileContent.split("\n"))).map((Function1 & Serializable & scala.Serializable)line -> {
            String[] elements = line.split(",");
            return new TwitterPOJO(elements[0], elements[1], elements[2]);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TwitterPOJO.class)));
        ArrayBuffer actual = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean readNextElement = true;
        while (readNextElement) {
            ArrayBuffer arrayBuffer;
            TwitterPOJO element = (TwitterPOJO)format.nextRecord((Object)new TwitterPOJO());
            if (element != null) {
                arrayBuffer = actual.$plus$eq((Object)element);
                continue;
            }
            readNextElement = false;
            arrayBuffer = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected)).sameElements((GenIterable)actual));
    }

    public CsvInputFormatTest() {
        this.FIRST_PART = "That is the first part";
        this.SECOND_PART = "That is the second part";
    }

    public static class CaseClassItem
    implements Product,
    scala.Serializable {
        private final int field1;
        private final String field2;
        private final double field3;

        public int field1() {
            return this.field1;
        }

        public String field2() {
            return this.field2;
        }

        public double field3() {
            return this.field3;
        }

        public CaseClassItem copy(int field1, String field2, double field3) {
            return new CaseClassItem(field1, field2, field3);
        }

        public int copy$default$1() {
            return this.field1();
        }

        public String copy$default$2() {
            return this.field2();
        }

        public double copy$default$3() {
            return this.field3();
        }

        public String productPrefix() {
            return "CaseClassItem";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.field1());
                    break;
                }
                case 1: {
                    object = this.field2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this.field3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CaseClassItem;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.field1());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.field2()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.field3()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CaseClassItem)) return false;
            boolean bl = true;
            if (!bl) return false;
            CaseClassItem caseClassItem = (CaseClassItem)x$1;
            if (this.field1() != caseClassItem.field1()) return false;
            String string = this.field2();
            String string2 = caseClassItem.field2();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.field3() != caseClassItem.field3()) return false;
            if (!caseClassItem.canEqual(this)) return false;
            return true;
        }

        public CaseClassItem(int field1, String field2, double field3) {
            this.field1 = field1;
            this.field2 = field2;
            this.field3 = field3;
            Product.$init$((Product)this);
        }
    }

    public class POJOItem {
        private int field1;
        private String field2;
        private double field3;
        public final /* synthetic */ CsvInputFormatTest $outer;

        public int field1() {
            return this.field1;
        }

        public void field1_$eq(int x$1) {
            this.field1 = x$1;
        }

        public String field2() {
            return this.field2;
        }

        public void field2_$eq(String x$1) {
            this.field2 = x$1;
        }

        public double field3() {
            return this.field3;
        }

        public void field3_$eq(double x$1) {
            this.field3 = x$1;
        }

        public /* synthetic */ CsvInputFormatTest org$apache$flink$api$scala$io$CsvInputFormatTest$POJOItem$$$outer() {
            return this.$outer;
        }

        public POJOItem(CsvInputFormatTest $outer, int field1, String field2, double field3) {
            this.field1 = field1;
            this.field2 = field2;
            this.field3 = field3;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public POJOItem(CsvInputFormatTest $outer) {
            this($outer, -1, "", -1.0);
        }
    }
}

