/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.scala.typeutils.OptionSerializer;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Option;

@RunWith(value=Parameterized.class)
public class OptionSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Option<String>, Option<String>> {
    private static final String SPEC_NAME = "scala-option-serializer";

    public OptionSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<Option<String>, Option<String>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (MigrationVersion migrationVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, migrationVersion, ScalaOptionSerializerSetup.class, ScalaOptionSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class ScalaOptionSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Option<String>> {
        public TypeSerializer<Option<String>> createUpgradedSerializer() {
            return new OptionSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Matcher<Option<String>> testDataMatcher() {
            return CoreMatchers.is((Object)Option.empty());
        }

        public Matcher<TypeSerializerSchemaCompatibility<Option<String>>> schemaCompatibilityMatcher(MigrationVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class ScalaOptionSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Option<String>> {
        public TypeSerializer<Option<String>> createPriorSerializer() {
            return new OptionSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Option<String> createTestData() {
            return Option.empty();
        }
    }
}

