/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.runtime;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTest$;
import org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTestInstance;
import org.apache.flink.api.scala.runtime.WeekDay$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.EitherTypeInfo;
import org.apache.flink.api.scala.typeutils.EnumValueTypeInfo;
import org.apache.flink.api.scala.typeutils.OptionTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.typeutils.ScalaNothingTypeInfo;
import org.apache.flink.api.scala.typeutils.TryTypeInfo;
import org.junit.Assert;
import org.junit.Test;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SortedMap;
import scala.collection.SortedMap$;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u001f\ty2kY1mCN\u0003XmY5bYRK\b/Z:TKJL\u0017\r\\5{KJ$Vm\u001d;\u000b\u0005\r!\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0019R\"\u0001\n\u000b\u0003\u0015I!\u0001\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u001a\u00015\t!\u0001C\u0003\u001c\u0001\u0011\u0005A$\u0001\u0006uKN$x\n\u001d;j_:$\u0012!\b\t\u0003#yI!a\b\n\u0003\tUs\u0017\u000e\u001e\u0015\u00035\u0005\u0002\"AI\u0013\u000e\u0003\rR!\u0001\n\u0007\u0002\u000b),h.\u001b;\n\u0005\u0019\u001a#\u0001\u0002+fgRDQ\u0001\u000b\u0001\u0005\u0002q\t\u0001\u0002^3tiN{W.\u001a\u0015\u0003O\u0005BQa\u000b\u0001\u0005\u0002q\t\u0001\u0002^3ti:{g.\u001a\u0015\u0003U\u0005BQA\f\u0001\u0005\u0002q\t!\u0002^3ti\u0016KG\u000f[3sQ\ti\u0013\u0005C\u00032\u0001\u0011\u0005A$\u0001\u0005uKN$H*\u001a4uQ\t\u0001\u0014\u0005C\u00035\u0001\u0011\u0005A$A\u0005uKN$(+[4ii\"\u00121'\t\u0005\u0006o\u0001!\t\u0001H\u0001\u000ei\u0016\u001cH/\u00128v[Z\u000bG.^3)\u0005Y\n\u0003\"\u0002\u001e\u0001\t\u0003a\u0012a\u0002;fgR$&/\u001f\u0015\u0003s\u0005BQ!\u0010\u0001\u0005\u0002q\t1\u0002^3tiN+8mY3tg\"\u0012A(\t\u0005\u0006\u0001\u0002!\t\u0001H\u0001\fi\u0016\u001cHOR1jYV\u0014X\r\u000b\u0002@C!)1\t\u0001C\u00019\u0005yA/Z:u'R\u0014\u0018N\\4BeJ\f\u0017\u0010\u000b\u0002CC!)a\t\u0001C\u00019\u0005aA/Z:u\u0013:$\u0018I\u001d:bs\"\u0012Q)\t\u0005\u0006\u0013\u0002!\t\u0001H\u0001\u0017i\u0016\u001cH/\u0011:sCf<\u0016\u000e\u001e5DCN,7\t\\1tg\"\u0012\u0001*\t\u0005\u0006\u0019\u0002!\t\u0001H\u0001\u000ei\u0016\u001cHoU8si\u0016$W*\u00199)\u0005-\u000b\u0003\"B(\u0001\t\u0003a\u0012!\u0004;fgR\u001cvN\u001d;fIN+G\u000f\u000b\u0002OC!)!\u000b\u0001C\u0007'\u0006A!/\u001e8UKN$8/\u0006\u0002UER\u0011Qk\u001b\u000b\u0003;YCqaV)\u0002\u0002\u0003\u000f\u0001,\u0001\u0006fm&$WM\\2fIE\u00022!\u00170a\u001b\u0005Q&BA.]\u0003!!\u0018\u0010]3j]\u001a|'BA/\u0007\u0003\u0019\u0019w.\\7p]&\u0011qL\u0017\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]B\u0011\u0011M\u0019\u0007\u0001\t\u0015\u0019\u0017K1\u0001e\u0005\u0005!\u0016CA3i!\t\tb-\u0003\u0002h%\t9aj\u001c;iS:<\u0007CA\tj\u0013\tQ'CA\u0002B]fDQ\u0001\\)A\u00025\f\u0011\"\u001b8ti\u0006t7-Z:\u0011\u0007Eq\u0007-\u0003\u0002p%\t)\u0011I\u001d:bs\u0002")
public class ScalaSpecialTypesSerializerTest {
    @Test
    public void testOption() {
        Option[] testData = (Option[])((Object[])new Option[]{new Some((Object)"Hello"), new Some((Object)"Ciao"), None$.MODULE$});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testSome() {
        Some[] testData = (Some[])((Object[])new Some[]{new Some((Object)"Hello"), new Some((Object)"Ciao")});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testNone() {
        None$[] testData = (None$[])((Object[])new None$[]{None$.MODULE$, None$.MODULE$});
        this.runTests(testData, (TypeInformation)new OptionTypeInfo((TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testEither() {
        Either[] testData = (Either[])((Object[])new Either[]{package$.MODULE$.Left().apply((Object)"Hell"), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)3))});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Either.class, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)));
    }

    @Test
    public void testLeft() {
        Left[] testData = (Left[])((Object[])new Left[]{package$.MODULE$.Left().apply((Object)"Hell"), package$.MODULE$.Left().apply((Object)"CIao")});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Left.class, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), (TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testRight() {
        Right[] testData = (Right[])((Object[])new Right[]{package$.MODULE$.Right().apply((Object)"Hell"), package$.MODULE$.Right().apply((Object)"CIao")});
        this.runTests(testData, (TypeInformation)new EitherTypeInfo(Right.class, (TypeInformation)new ScalaNothingTypeInfo(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testEnumValue() {
        Enumeration.Value[] testData = (Enumeration.Value[])((Object[])new Enumeration.Value[]{WeekDay$.MODULE$.Mon(), WeekDay$.MODULE$.Fri(), WeekDay$.MODULE$.Tue(), WeekDay$.MODULE$.Sun(), WeekDay$.MODULE$.Wed()});
        this.runTests(testData, (TypeInformation)new EnumValueTypeInfo((Enumeration)WeekDay$.MODULE$, Enumeration.Value.class));
    }

    @Test
    public void testTry() {
        Try[] testData = (Try[])((Object[])new Try[]{new Success((Object)"Hell"), new Failure((Throwable)new RuntimeException("test"))});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testSuccess() {
        Success[] testData = (Success[])((Object[])new Success[]{new Success((Object)"Hell"), new Success((Object)"Yeah")});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)BasicTypeInfo.getInfoFor(String.class)));
    }

    @Test
    public void testFailure() {
        Failure[] testData = (Failure[])((Object[])new Failure[]{new Failure((Throwable)new RuntimeException("test")), new Failure((Throwable)new RuntimeException("one, two"))});
        this.runTests(testData, (TypeInformation)new TryTypeInfo((TypeInformation)new ScalaNothingTypeInfo()));
    }

    @Test
    public void testStringArray() {
        String[][] testData = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"Foo", "Bar"}), (String[])((Object[])new String[]{"Hello"})});
        this.runTests(testData, (TypeInformation)BasicArrayTypeInfo.getInfoFor(String[].class));
    }

    @Test
    public void testIntArray() {
        int[][] testData = (int[][])((Object[])new int[][]{{1, 3, 3, 7}, {4, 7}});
        this.runTests(testData, (TypeInformation)PrimitiveArrayTypeInfo.getInfoFor(int[].class));
    }

    @Test
    public void testArrayWithCaseClass() {
        Object object;
        CaseClassTypeInfo<Tuple2<Object, String>> elementType;
        Tuple2[][] testData = (Tuple2[][])((Object[])new Tuple2[][]{(Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"String"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"Foo")}), (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)"String"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"Foo")})});
        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo = elementType = new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo2 = caseClassTypeInfo;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(caseClassTypeInfo2) : caseClassTypeInfo2 != null)) {
            object = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.BYTE_TYPE_INFO;
            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo3 = caseClassTypeInfo;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(caseClassTypeInfo3) : caseClassTypeInfo3 != null)) {
                object = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            } else {
                BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.CHAR_TYPE_INFO;
                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo4 = caseClassTypeInfo;
                if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(caseClassTypeInfo4) : caseClassTypeInfo4 != null)) {
                    object = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo5 = caseClassTypeInfo;
                    if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(caseClassTypeInfo5) : caseClassTypeInfo5 != null)) {
                        object = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.FLOAT_TYPE_INFO;
                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo6 = caseClassTypeInfo;
                        if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(caseClassTypeInfo6) : caseClassTypeInfo6 != null)) {
                            object = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.INT_TYPE_INFO;
                            CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo7 = caseClassTypeInfo;
                            if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(caseClassTypeInfo7) : caseClassTypeInfo7 != null)) {
                                object = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.LONG_TYPE_INFO;
                                CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo8 = caseClassTypeInfo;
                                if (!(basicTypeInfo7 != null ? !basicTypeInfo7.equals(caseClassTypeInfo8) : caseClassTypeInfo8 != null)) {
                                    object = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo8 = BasicTypeInfo.SHORT_TYPE_INFO;
                                    CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo9 = caseClassTypeInfo;
                                    if (!(basicTypeInfo8 != null ? !basicTypeInfo8.equals(caseClassTypeInfo9) : caseClassTypeInfo9 != null)) {
                                        object = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo9 = BasicTypeInfo.STRING_TYPE_INFO;
                                        CaseClassTypeInfo<Tuple2<Object, String>> caseClassTypeInfo10 = caseClassTypeInfo;
                                        object = !(basicTypeInfo9 != null ? !basicTypeInfo9.equals(caseClassTypeInfo10) : caseClassTypeInfo10 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        PrimitiveArrayTypeInfo result = object;
        this.runTests(testData, (TypeInformation)result);
    }

    @Test
    public void testSortedMap() {
        SortedMap[] testData = (SortedMap[])((Object[])new SortedMap[]{SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Hello"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"World"), (Object)BoxesRunTime.boxToInteger((int)2))}), (Ordering)Ordering.String$.MODULE$), SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Foo"), (Object)BoxesRunTime.boxToInteger((int)42))}), (Ordering)Ordering.String$.MODULE$)});
        this.runTests(testData, TypeExtractor.createTypeInfo(SortedMap.class));
    }

    @Test
    public void testSortedSet() {
        SortedSet[] testData = (SortedSet[])((Object[])new SortedSet[]{SortedSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), (Ordering)Ordering.Int$.MODULE$), SortedSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}), (Ordering)Ordering.Int$.MODULE$)});
        this.runTests(testData, TypeExtractor.createTypeInfo(SortedSet.class));
    }

    private final <T> void runTests(Object instances, TypeInformation<T> evidence$1) {
        try {
            TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
            TypeSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
            Class typeClass = typeInfo.getTypeClass();
            ScalaSpecialTypesSerializerTestInstance test = new ScalaSpecialTypesSerializerTestInstance(serializer, typeClass, serializer.getLength(), instances);
            test.testAll();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

