/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.scala.operators.ScalaCsvOutputFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import scala.Product;
import scala.Tuple3;

public class ScalaCsvOutputFormatTest {
    private String path;
    private ScalaCsvOutputFormat<Tuple3<String, String, Integer>> csvOutputFormat;
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.path = this.tmpFolder.newFile().getAbsolutePath();
        this.csvOutputFormat = new ScalaCsvOutputFormat(new Path(this.path));
        this.csvOutputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        this.csvOutputFormat.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        this.csvOutputFormat.open(0, 1);
    }

    @Test
    public void testNullAllow() throws Exception {
        try {
            this.csvOutputFormat.setAllowNullValues(true);
            this.csvOutputFormat.writeRecord((Product)new Tuple3((Object)"One", null, (Object)8));
        }
        finally {
            this.csvOutputFormat.close();
        }
        java.nio.file.Path p = Paths.get(this.path, new String[0]);
        Assert.assertTrue((boolean)Files.exists(p, new LinkOption[0]));
        List<String> lines = Files.readAllLines(Paths.get(this.path, new String[0]), StandardCharsets.UTF_8);
        Assert.assertEquals((long)1L, (long)lines.size());
        Assert.assertEquals((Object)"One,,8", (Object)lines.get(0));
    }

    @Test
    public void testNullDisallowOnDefault() throws Exception {
        try {
            this.csvOutputFormat.setAllowNullValues(false);
            this.csvOutputFormat.writeRecord((Product)new Tuple3((Object)"One", null, (Object)8));
            Assert.fail((String)"should fail with an exception");
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.csvOutputFormat.close();
        }
    }
}

